///////////////////////////////////////////////////////////////////////////
// File:        itsywnd.h
// Author:      Ed McCreary, a straight port to MFC of code by Charlie Kindel
//              I just ported it, he did all of the work.
//              original files  Copyright (c) 1992 Charles E. Kindel, Jr..  
//              All Rights Reserved.
//
// Date:        9/12/94
// Purpose:     Implements miniture caption bars for popup windows
///////////////////////////////////////////////////////////////////////////

#ifndef _ITSYWND_H
#define _ITSYWND_H

#define IBS_HORZCAPTION    0x4000L
#define IBS_VERTCAPTION    0x8000L


/////////////////////////////////////////////////////////////////////////////
// CItsyWnd window

class CItsyWnd : public CWnd
{
// Construction
public:
    CItsyWnd();

// Attributes
public:

// Operations
public:

// Implementation
public:
    virtual ~CItsyWnd();

    UINT    GetCaptionSize(void) ;
    UINT    SetCaptionSize(UINT nSize ) ;    
    void    AdjustWindowRect(LPRECT lprc ) ;
    
    BOOL    Create(LPCSTR lpszClassName, LPCSTR lpszWindowName, DWORD dwStyle,           
                        int x, int y, int nWidth, int nHeight,HWND hwndParent, HMENU nIDorHMenu, 
                        LPSTR lpParam = NULL);

protected:
    BOOL fWin31;
    
    
    BOOL DepressMinMaxButton(UINT uiHT, LPRECT lprc) ;
    BOOL DoMenu(void) ;
    void SetupSystemMenu(CMenu *pMenu ) ;
    BOOL GetCaptionRect(LPRECT lprc ) ;
    BOOL GetIconRect(LPRECT lprc ) ;
    BOOL GetButtonRect(UINT nPos, LPRECT lprc ) ;
    BOOL GetMinButtonRect(LPRECT lprc ) ;
    BOOL GetMaxButtonRect(LPRECT lprc ) ;
    BOOL DrawCaption(CDC *pDC, LPRECT lprc,
                              BOOL fVert, BOOL fSysMenu, 
                              BOOL fMin, BOOL fMax, BOOL fActive ) ;
    void DrawSysMenu(CDC *pDC, BOOL fInvert ) ;
    void DrawButton(CDC *pDC, BOOL fMin, BOOL fDepressed ) ;
    void DrawArrow(CDC *pDC, LPRECT lprc, UINT uiStyle ) ;

    virtual BOOL OnCommand( WPARAM wParam, LPARAM lParam );
protected:
    // Generated message map functions
    //{{AFX_MSG(CItsyWnd)
    afx_msg void OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
    afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnNcDestroy();
    afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
    afx_msg UINT OnNcHitTest(CPoint point);
    afx_msg void OnNcLButtonDblClk(UINT nHitTest, CPoint point);
    afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
    afx_msg void OnNcPaint();
    afx_msg BOOL OnNcActivate(BOOL bActive);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif /* _ITSYWND_H */

#ifndef _RGB_H_
#define _RGB_H_
         
   // Some mildly useful macros for the standard 16 colors
   #define RGBBLACK     RGB(0,0,0)
   #define RGBRED       RGB(128,0,0)
   #define RGBGREEN     RGB(0,128,0)
   #define RGBBLUE      RGB(0,0,128)
   
   #define RGBBROWN     RGB(128,128,0)
   #define RGBMAGENTA   RGB(128,0,128)
   #define RGBCYAN      RGB(0,128,128)
   #define RGBLTGRAY    RGB(192,192,192)
   
   #define RGBGRAY      RGB(128,128,128)
   #define RGBLTRED     RGB(255,0,0)
   #define RGBLTGREEN   RGB(0,255,0)
   #define RGBLTBLUE    RGB(0,0,255)
   
   #define RGBYELLOW    RGB(255,255,0)
   #define RGBLTMAGENTA RGB(255,0,255)
   #define RGBLTCYAN    RGB(0,255,255)
   #define RGBWHITE     RGB(255,255,255)

#endif /* _RGB_H_ */

