/* Include file for use with OCELOT2-THE SQL! version 2.15 and C/C++ compilers

   Starting with version 2.15, C and C++ programs must contain
   #include "ocelot.h"
   
   If "windows.h" has not been seen, then FALSE, TRUE, FAR, PASCAL
   are temporarily defined within this .h file only.

   Some slight deviations from Microsoft ODBC are noted in the comments. */

/* If the size of an int is 4 then we guess this must be a 32-bit compiler. */
/* It's too bad that not all compilers accept a simple "sizeof(int)"! */
#ifndef __INTSIZE
#ifdef __ZTC__
#define __INTSIZE sizeof(int)
#else
#define __INTSIZE 2
#endif
#endif

#ifndef __SQL
#define __SQL

#ifndef PASCAL
#define ZQZ_PASCAL_DEFINE 1
#define PASCAL pascal
#endif

#ifndef FAR
#define ZQZ_FAR_DEFINE 1
#if (__INTSIZE==4)
#define FAR near
#endif
#if (__INTSIZE==2)
#define FAR far
#endif
#endif

#ifndef HWND
#define ZQZ_HWND_DEFINE 1
#define HWND int
#endif

#ifndef FALSE
#define ZQZ_FALSE_DEFINE 1
#define FALSE 0
#endif

#ifndef TRUE
#define ZQZ_TRUE_DEFINE 1
#define TRUE 1
#endif

#ifndef BOOL
#define ZQZ_BOOL_DEFINE 1
typedef int BOOL;
#endif

#define SQL_NTS                  -3  /* NTS = "NULL TERMINATED STRING" */
#define SQL_SQLSTATE_SIZE         5
#define SQL_MAX_MESSAGE_LENGTH  512  /* message buffer size           */
#define SQL_MAX_DSN_LENGTH       32

#define SQL_ERROR             -1
#define SQL_INVALID_HANDLE    -2
#define SQL_NEED_DATA         99
#define SQL_NO_DATA_FOUND    100
#define SQL_SUCCESS            0
#define SQL_SUCCESS_WITH_INFO  1

#define SQL_CLOSE              0
#define SQL_DROP               1
#define SQL_UNBIND             2
#define SQL_RESET_PARAMS       3

#define SQL_C_DEFAULT  99

#define SQL_COMMIT    0
#define SQL_ROLLBACK  1

#define SQL_CHAR      1
#define SQL_NUMERIC   2
#define SQL_DECIMAL   3
#define SQL_INTEGER   4
#define SQL_SMALLINT  5
#define SQL_FLOAT     6
#define SQL_REAL      7
#define SQL_DOUBLE    8
#define SQL_VARCHAR  12

#define SQL_TYPE_MIN   1
#define SQL_TYPE_NULL  0
#define SQL_TYPE_MAX  12

#define SQL_C_CHAR    SQL_CHAR
#define SQL_C_LONG    SQL_INTEGER
#define SQL_C_SHORT   SQL_SMALLINT
#define SQL_C_FLOAT   SQL_REAL
#define SQL_C_DOUBLE  SQL_DOUBLE

#define SQL_NO_NULLS         0
#define SQL_NULLABLE         1
#define SQL_NULLABLE_UNKNOWN 2

#define SQL_NULL_DATA       -1
#define SQL_DATA_AT_EXEC    -2

#define SQL_COLUMN_COUNT            0
#define SQL_COLUMN_NAME             1
#define SQL_COLUMN_TYPE             2
#define SQL_COLUMN_LENGTH           3
#define SQL_COLUMN_PRECISION        4
#define SQL_COLUMN_SCALE            5
#define SQL_COLUMN_DISPLAY_SIZE     6
#define SQL_COLUMN_NULLABLE         7
#define SQL_COLUMN_UNSIGNED         8
#define SQL_COLUMN_MONEY            9
#define SQL_COLUMN_UPDATABLE       10
#define SQL_COLUMN_AUTO_INCREMENT  11
#define SQL_COLUMN_CASE_SENSITIVE  12
#define SQL_COLUMN_SEARCHABLE      13
#define SQL_COLUMN_TYPE_NAME       14

#define SQL_ATTR_READONLY          0
#define SQL_ATTR_WRITE             1
#define SQL_ATTR_READWRITE_UNKNOWN 2

#define SQL_UNSEARCHABLE           0
#define SQL_LIKE_ONLY              1
#define SQL_ALL_EXCEPT_LIKE        2
#define SQL_SEARCHABLE             3

#define SQL_NULL_HENV    0
#define SQL_NULL_HDBC    0
#define SQL_NULL_HSTMT   0

#define SQL_API PASCAL FAR

/* SQLSetConnectOption label            =       default value */
#define SQL_OPT_SQLCODE_SIZE		1200 /*	2: indicators are 16-bit */
#define SQL_OPT_SELECT_ROWCOUNT		1201 /*	SQLRowCount ret=0 if SELECT */
#define SQL_OPT_DATE_SEPARATOR_CHAR	1202 /*	"/" */
#define SQL_OPT_DATE_ORDER		1203 /*	MONTH_DAY_YEAR */
#define SQL_OPT_DATE_MONTHSIZE		1204 /*	2 */
#define SQL_OPT_DATE_YEARSIZE		1205 /*	4 */
#define SQL_OPT_TIME_SEPARATOR_CHAR	1206 /*	":" */
#define SQL_OPT_TIME_INCLUDES		1207 /*	SECONDS_INCLUDED */
#define SQL_OPT_COMMIT_FLAGS		1208 /*	0 */
#define SQL_OPT_DBMS_FREE_PUT		1209 /*	0 */
#define SQL_OPT_DBMS_FIELD_DELIMITER	1211 /*	"," */
#define SQL_OPT_DBMS_QUOTE_DELIMITER	1212 /*	0x22 i.e. " */
#define SQL_OPT_DBMS_FILE_DELIMITER	1213 /*	0x26 i.e. control-Z */
#define SQL_OPT_DBMS_DELAY		1214 /*	0 */

typedef unsigned char       UCHAR;
typedef signed char         SCHAR;
typedef long int            SDWORD;
typedef short int           SWORD;
typedef unsigned long int   UDWORD;
typedef unsigned short int  UWORD;
typedef double              SDOUBLE;
typedef long double         LDOUBLE;
typedef float               SFLOAT;
typedef void FAR *          PTR;

/* In regular ODBC, HENV+HDBC+HSTMT are defined as "typedef void FAR *".
   We have changed that because we have a default handle value = -1,
   but using "typedef void FAR *" would cause no problem except a warning. */
typedef long int          HENV;
typedef long int          HDBC;
typedef long int          HSTMT;

typedef int                 RETCODE;

/* Prototypes of public routines in the Ocelot library.  In Zortech / Borland
   / Microsoft products, the constant __cplusplus is defined if compilation
   is for C++, e.g. the extension of the program name is .cpp). */
#ifdef __cplusplus
extern "C" {
#endif

RETCODE  SQL_API SQLAllocConnect(
    HENV        henv,
    HDBC   FAR *phdbc);

RETCODE  SQL_API SQLAllocEnv(
    HENV   FAR *phenv);

RETCODE  SQL_API SQLAllocStmt(
    HDBC        hdbc,
    HSTMT  FAR *phstmt);

/*
   SQLBindCol's **pcbValue is defined as "void far *".  ODBC's specification
   is "SDWORD far *", type checking is relaxed here because the return can be
   a 16-bit word.
*/
RETCODE  SQL_API SQLBindCol(
    HSTMT       hstmt,
    UWORD       icol,
    SWORD       fCType,
    PTR         rgbValue,
    SDWORD      cbValueMax,
    void    FAR *pcbValue);

/* Following function is not ODBC. */
RETCODE  SQL_API SQLBindDescriptor(
    HSTMT	hstmt,
    PTR		sqlda,
    UWORD	sqldasize);

RETCODE  SQL_API SQLCancel(
    HSTMT       hstmt);

RETCODE  SQL_API SQLColAttributes(
    HSTMT        hstmt,
    UWORD        icol,
    UWORD        fDescType,
    PTR          rgbDesc,
	SWORD		 cbDescMax,
    SWORD   FAR *pcbDesc,
    SDWORD  FAR *pfDesc);

RETCODE  SQL_API SQLConnect(
    HDBC        hdbc,
    UCHAR  FAR *szDSN,
    SWORD       cbDSN,
    UCHAR  FAR *szUID,
    SWORD       cbUID,
    UCHAR  FAR *szAuthStr,
    SWORD       cbAuthStr);

/* Following function is not ODBC. */
RETCODE  SQL_API SQLDescribe(
    HSTMT       hstmt,
    UCHAR   FAR *szSqlStr,
    SDWORD      cbSqlStr);

RETCODE  SQL_API SQLDescribeCol(
    HSTMT       hstmt,
    UWORD       icol,
    UCHAR  FAR *szColName,
    SWORD       cbColNameMax,
    SWORD  FAR *pcbColName,
    SWORD  FAR *pfSqlType,
    UDWORD FAR *pcbColDef,
    SWORD  FAR *pibScale,
    SWORD  FAR *pfNullable);

RETCODE  SQL_API SQLDisconnect(
    HDBC        hdbc);

/*
   SQLError's *pfNativeError is defined as "void far *".  ODBC's specification
   is "SDWORD far *", type checking is relaxed here because the return can be
   a 16-bit word.
*/
RETCODE  SQL_API SQLError(
    HENV        henv,
    HDBC        hdbc,
    HSTMT       hstmt,
    UCHAR  FAR *szSqlState,
    void   FAR *pfNativeError,
    UCHAR  FAR *szErrorMsg,
    SWORD       cbErrorMsgMax,
    SWORD  FAR *pcbErrorMsg);

RETCODE  SQL_API SQLExecDirect(
    HSTMT       hstmt,
    UCHAR  FAR *szSqlStr,
    SDWORD      cbSqlStr);

/* Following function is not ODBC. */
RETCODE  SQL_API SQLExecPseudocode(
    HSTMT       hstmt,
    UCHAR  FAR *szSqlStr,
    SDWORD      cbSqlStr);

RETCODE  SQL_API SQLExecute(
    HSTMT       hstmt);

RETCODE  SQL_API SQLFetch(
    HSTMT       hstmt);

RETCODE  SQL_API SQLFreeConnect(
    HDBC        hdbc);

RETCODE  SQL_API SQLFreeEnv(
    HENV        henv);

RETCODE  SQL_API SQLFreeStmt(
    HSTMT       hstmt,
    UWORD       fOption);

RETCODE  SQL_API SQLGetCursorName(
    HSTMT       hstmt,
    UCHAR  FAR *szCursor,
    SWORD       cbCursorMax,
    SWORD  FAR *pcbCursor);

RETCODE  SQL_API SQLNumResultCols(
    HSTMT       hstmt,
    SWORD  FAR *pccol);

RETCODE  SQL_API SQLPrepare(
    HSTMT       hstmt,
    UCHAR  FAR *szSqlStr,
    SDWORD      cbSqlStr);

RETCODE  SQL_API SQLRowCount(
    HSTMT       hstmt,
    SDWORD  FAR *pcrow);

RETCODE  SQL_API SQLSetCursorName(
    HSTMT       hstmt,
    UCHAR  FAR *szCursor,
    SWORD       cbCursor);

/*
   SQLSetParam's **pcbValue is defined as "void far *".  ODBC's specification
   is "SDWORD far *", type checking is relaxed here because the return can be
   a 16-bit word.
*/
RETCODE  SQL_API SQLSetParam(
    HSTMT       hstmt,
    UWORD       ipar,
    SWORD       fCType,
    SWORD       fSqlType,
    UDWORD      cbColDef,
    SWORD       ibScale,
    PTR         rgbValue,
    void        FAR *pcbValue);

RETCODE  SQL_API SQLTransact(
    HENV        henv,
    HDBC        hdbc,
    UWORD       fType);

#ifndef __SQLEXT
#define __SQLEXT

#define SQL_STILL_EXECUTING 2

#define SQL_DATE            9
#define SQL_TIME           10
#define SQL_TIMESTAMP      11
#define SQL_LONGVARCHAR    -1
#define SQL_BINARY         -2
#define SQL_VARBINARY      -3
#define SQL_LONGVARBINARY  -4
#define SQL_BIGINT         -5
#define SQL_TINYINT        -6
#define SQL_BIT            -7

#define SQL_C_DATE         SQL_DATE
#define SQL_C_TIME         SQL_TIME
#define SQL_C_TIMESTAMP    SQL_TIMESTAMP
#define SQL_C_BINARY       SQL_BINARY
#define SQL_C_BIT          SQL_BIT
#define SQL_C_TINYINT      SQL_TINYINT

typedef struct tagDATE_STRUCT
  {
  SWORD year;
  UWORD month;
  UWORD day;
  } DATE_STRUCT;

typedef struct tagTIME_SRUCT
  {
  UWORD hour;
  UWORD minute;
  UWORD second;
  } TIME_STRUCT;

typedef struct tagTIMESTAMP_STRUCT
  {
  SWORD year;
  UWORD month;
  UWORD day;
  UWORD hour;
  UWORD minute;
  UWORD second;
  UDWORD fraction;
  } TIMESTAMP_STRUCT;

#undef  SQL_TYPE_MIN  
#define SQL_TYPE_MIN      -7
#define SQL_ALL_TYPES      0

#define SQL_MODE_READ_WRITE     0
#define SQL_MODE_READ_ONLY      1

#define SQL_DRIVER_NOPROMPT           0
#define SQL_DRIVER_COMPLETE           1
#define SQL_DRIVER_PROMPT             2
#define SQL_DRIVER_COMPLETE_REQUIRED  3

#define SQL_NO_TOTAL           -4

#define SQL_API_SQLALLOCCONNECT      1
#define SQL_API_SQLALLOCENV          2
#define SQL_API_SQLALLOCSTMT         3
#define SQL_API_SQLBINDCOL           4
#define SQL_API_SQLCANCEL            5
#define SQL_API_SQLCOLATTRIBUTES     6
#define SQL_API_SQLCONNECT           7
#define SQL_API_SQLDESCRIBECOL       8
#define SQL_API_SQLDISCONNECT        9
#define SQL_API_SQLERROR            10
#define SQL_API_SQLEXECDIRECT       11
#define SQL_API_SQLEXECUTE          12
#define SQL_API_SQLFETCH            13
#define SQL_API_SQLFREECONNECT      14
#define SQL_API_SQLFREEENV          15
#define SQL_API_SQLFREESTMT         16
#define SQL_API_SQLGETCURSORNAME    17
#define SQL_API_SQLNUMRESULTCOLS    18
#define SQL_API_SQLPREPARE          19
#define SQL_API_SQLROWCOUNT         20
#define SQL_API_SQLSETCURSORNAME    21
#define SQL_API_SQLSETPARAM         22
#define SQL_API_SQLTRANSACT         23

#define SQL_NUM_FUNCTIONS           23

#define SQL_EXT_API_START           40

#define SQL_API_SQLCOLUMNS          40
#define SQL_API_SQLDRIVERCONNECT    41
#define SQL_API_SQLGETCONNECTOPTION 42
#define SQL_API_SQLGETDATA          43
#define SQL_API_SQLGETFUNCTIONS     44
#define SQL_API_SQLGETINFO          45
#define SQL_API_SQLGETSTMTOPTION    46
#define SQL_API_SQLGETTYPEINFO      47
#define SQL_API_SQLPARAMDATA        48
#define SQL_API_SQLPUTDATA          49
#define SQL_API_SQLSETCONNECTOPTION 50
#define SQL_API_SQLSETSTMTOPTION    51
#define SQL_API_SQLSPECIALCOLUMNS   52
#define SQL_API_SQLSTATISTICS       53
#define SQL_API_SQLTABLES           54

#define SQL_API_SQLBROWSECONNECT    55
#define SQL_API_SQLCOLUMNPRIVILEGES 56
#define SQL_API_SQLDATASOURCES      57
#define SQL_API_SQLDESCRIBEPARAM    58
#define SQL_API_SQLEXTENDEDFETCH    59
#define SQL_API_SQLFOREIGNKEYS      60
#define SQL_API_SQLMORERESULTS      61
#define SQL_API_SQLNATIVESQL        62
#define SQL_API_SQLNUMPARAMS        63
#define SQL_API_SQLPARAMOPTIONS     64
#define SQL_API_SQLPRIMARYKEYS      65
#define SQL_API_SQLPROCEDURECOLUMNS 66
#define SQL_API_SQLPROCEDURES       67
#define SQL_API_SQLSETPOS           68
#define SQL_API_SQLSETSCROLLOPTIONS 69
#define SQL_API_SQLTABLEPRIVILEGES  70

#define SQL_EXT_API_LAST            70

#define SQL_NUM_EXTENSIONS (SQL_EXT_API_LAST-SQL_EXT_API_START+1)

#define SQL_INFO_FIRST                       0
#define SQL_ACTIVE_CONNECTIONS               0
#define SQL_ACTIVE_STATEMENTS                1
#define SQL_DATA_SOURCE_NAME                 2
#define SQL_DRIVER_HDBC                      3
#define SQL_DRIVER_HENV                      4
#define SQL_DRIVER_HSTMT                     5
#define SQL_DRIVER_NAME                      6
#define SQL_DRIVER_VER                       7
#define SQL_FETCH_DIRECTION                  8
#define SQL_ODBC_API_CONFORMANCE             9
#define SQL_ODBC_VER                        10
#define SQL_ROW_UPDATES                     11
#define SQL_ODBC_SAG_CLI_CONFORMANCE        12
#define SQL_SERVER_NAME                     13
#define SQL_SEARCH_PATTERN_ESCAPE           14
#define SQL_ODBC_SQL_CONFORMANCE            15

#define SQL_DATABASE_NAME                   16
#define SQL_DBMS_NAME                       17
#define SQL_DBMS_VER                        18

#define SQL_ACCESSIBLE_TABLES               19
#define SQL_ACCESSIBLE_PROCEDURES           20
#define SQL_PROCEDURES                      21
#define SQL_CONCAT_NULL_BEHAVIOR            22
#define SQL_CURSOR_COMMIT_BEHAVIOR          23
#define SQL_CURSOR_ROLLBACK_BEHAVIOR        24
#define SQL_DATA_SOURCE_READ_ONLY           25
#define SQL_DEFAULT_TXN_ISOLATION           26
#define SQL_EXPRESSIONS_IN_ORDERBY          27
#define SQL_IDENTIFIER_CASE                 28
#define SQL_IDENTIFIER_QUOTE_CHAR           29
#define SQL_MAX_COLUMN_NAME_LEN             30
#define SQL_MAX_CURSOR_NAME_LEN             31
#define SQL_MAX_OWNER_NAME_LEN              32
#define SQL_MAX_PROCEDURE_NAME_LEN          33
#define SQL_MAX_QUALIFIER_NAME_LEN          34
#define SQL_MAX_TABLE_NAME_LEN              35
#define SQL_MULT_RESULT_SETS                36
#define SQL_MULTIPLE_ACTIVE_TXN             37
#define SQL_OUTER_JOINS                     38
#define SQL_OWNER_TERM                      39
#define SQL_PROCEDURE_TERM                  40
#define SQL_QUALIFIER_NAME_SEPARATOR        41
#define SQL_QUALIFIER_TERM                  42
#define SQL_SCROLL_CONCURRENCY              43
#define SQL_SCROLL_OPTIONS                  44
#define SQL_TABLE_TERM                      45
#define SQL_TXN_CAPABLE                     46
#define SQL_USER_NAME                       47

#define SQL_CONVERT_FUNCTIONS               48
#define SQL_NUMERIC_FUNCTIONS               49
#define SQL_STRING_FUNCTIONS                50
#define SQL_SYSTEM_FUNCTIONS                51
#define SQL_TIMEDATE_FUNCTIONS              52

#define SQL_CONVERT_BIGINT                  53
#define SQL_CONVERT_BINARY                  54
#define SQL_CONVERT_BIT                     55
#define SQL_CONVERT_CHAR                    56
#define SQL_CONVERT_DATE                    57
#define SQL_CONVERT_DECIMAL                 58
#define SQL_CONVERT_DOUBLE                  59
#define SQL_CONVERT_FLOAT                   60
#define SQL_CONVERT_INTEGER                 61
#define SQL_CONVERT_LONGVARCHAR             62
#define SQL_CONVERT_NUMERIC                 63
#define SQL_CONVERT_REAL                    64
#define SQL_CONVERT_SMALLINT                65
#define SQL_CONVERT_TIME                    66
#define SQL_CONVERT_TIMESTAMP               67
#define SQL_CONVERT_TINYINT                 68
#define SQL_CONVERT_VARBINARY               69
#define SQL_CONVERT_VARCHAR                 70
#define SQL_CONVERT_LONGVARBINARY           71

#define SQL_TXN_ISOLATION_OPTION            72
#define SQL_ODBC_SQL_OPT_IEF                73

#define SQL_INFO_LAST                       73
#define SQL_INFO_DRIVER_START               1000

#define SQL_CVT_CHAR                        0x00000001L
#define SQL_CVT_NUMERIC                     0x00000002L
#define SQL_CVT_DECIMAL                     0x00000004L
#define SQL_CVT_INTEGER                     0x00000008L
#define SQL_CVT_SMALLINT                    0x00000010L
#define SQL_CVT_FLOAT                       0x00000020L
#define SQL_CVT_REAL                        0x00000040L
#define SQL_CVT_DOUBLE                      0x00000080L
#define SQL_CVT_VARCHAR                     0x00000100L
#define SQL_CVT_LONGVARCHAR                 0x00000200L
#define SQL_CVT_BINARY                      0x00000400L
#define SQL_CVT_VARBINARY                   0x00000800L
#define SQL_CVT_BIT                         0x00001000L
#define SQL_CVT_TINYINT                     0x00002000L
#define SQL_CVT_BIGINT                      0x00004000L
#define SQL_CVT_DATE                        0x00008000L
#define SQL_CVT_TIME                        0x00010000L
#define SQL_CVT_TIMESTAMP                   0x00020000L
#define SQL_CVT_LONGVARBINARY               0x00040000L

#define SQL_FN_CVT_CONVERT                  0x00000001L

#define SQL_FN_STR_CONCAT                   0x00000001L
#define SQL_FN_STR_INSERT                   0x00000002L
#define SQL_FN_STR_LEFT                     0x00000004L
#define SQL_FN_STR_LTRIM                    0x00000008L
#define SQL_FN_STR_LENGTH                   0x00000010L
#define SQL_FN_STR_LOCATE                   0x00000020L
#define SQL_FN_STR_LCASE                    0x00000040L
#define SQL_FN_STR_REPEAT                   0x00000080L
#define SQL_FN_STR_REPLACE                  0x00000100L
#define SQL_FN_STR_RIGHT                    0x00000200L
#define SQL_FN_STR_RTRIM                    0x00000400L
#define SQL_FN_STR_SUBSTRING                0x00000800L
#define SQL_FN_STR_UCASE                    0x00001000L
#define SQL_FN_STR_ASCII                    0x00002000L
#define SQL_FN_STR_CHAR                     0x00004000L

#define SQL_FN_NUM_ABS                      0x00000001L
#define SQL_FN_NUM_ACOS                     0x00000002L
#define SQL_FN_NUM_ASIN                     0x00000004L
#define SQL_FN_NUM_ATAN                     0x00000008L
#define SQL_FN_NUM_ATAN2                    0x00000010L
#define SQL_FN_NUM_CEILING                  0x00000020L
#define SQL_FN_NUM_COS                      0x00000040L
#define SQL_FN_NUM_COT                      0x00000080L
#define SQL_FN_NUM_EXP                      0x00000100L
#define SQL_FN_NUM_FLOOR                    0x00000200L
#define SQL_FN_NUM_LOG                      0x00000400L
#define SQL_FN_NUM_MOD                      0x00000800L
#define SQL_FN_NUM_SIGN                     0x00001000L
#define SQL_FN_NUM_SIN                      0x00002000L
#define SQL_FN_NUM_SQRT                     0x00004000L
#define SQL_FN_NUM_TAN                      0x00008000L
#define SQL_FN_NUM_PI                       0x00010000L
#define SQL_FN_NUM_RAND                     0x00020000L

#define SQL_FN_TD_NOW                       0x00000001L
#define SQL_FN_TD_CURDATE                   0x00000002L
#define SQL_FN_TD_DAYOFMONTH                0x00000004L
#define SQL_FN_TD_DAYOFWEEK                 0x00000008L
#define SQL_FN_TD_DAYOFYEAR                 0x00000010L
#define SQL_FN_TD_MONTH                     0x00000020L
#define SQL_FN_TD_QUARTER                   0x00000040L
#define SQL_FN_TD_WEEK                      0x00000080L
#define SQL_FN_TD_YEAR                      0x00000100L
#define SQL_FN_TD_CURTIME                   0x00000200L
#define SQL_FN_TD_HOUR                      0x00000400L
#define SQL_FN_TD_MINUTE                    0x00000800L
#define SQL_FN_TD_SECOND                    0x00001000L

#define SQL_FN_SYS_USERNAME                 0x00000001L
#define SQL_FN_SYS_DBNAME                   0x00000002L
#define SQL_FN_SYS_IFNULL                   0x00000004L

#define SQL_SO_FORWARD_ONLY                 0x00000001L
#define SQL_SO_KEYSET_DRIVEN                0x00000002L
#define SQL_SO_DYNAMIC                      0x00000004L
#define SQL_SO_MIXED                        0x00000008L

#define SQL_SCCO_READ_ONLY                  0x00000001L
#define SQL_SCCO_LOCK                       0x00000002L
#define SQL_SCCO_OPT_TIMESTAMP              0x00000004L
#define SQL_SCCO_OPT_VALUES                 0x00000008L

#define SQL_FD_FETCH_NEXT                   0x00000001L
#define SQL_FD_FETCH_FIRST                  0x00000002L
#define SQL_FD_FETCH_LAST                   0x00000004L
#define SQL_FD_FETCH_PREV                   0x00000008L
#define SQL_FD_FETCH_ABSOLUTE               0x00000010L
#define SQL_FD_FETCH_RELATIVE               0x00000020L
#define SQL_FD_FETCH_RESUME                 0x00000040L

#define SQL_TXN_READ_UNCOMMITTED            0x00000001L
#define SQL_TXN_READ_COMMITTED              0x00000002L
#define SQL_TXN_REPEATABLE_READ             0x00000004L
#define SQL_TXN_SERIALIZABLE                0x00000008L
#define SQL_TXN_VERSIONING                  0x00000010L

#define SQL_QUERY_TIMEOUT       0
#define SQL_MAX_ROWS            1
#define SQL_NOSCAN              2
#define SQL_MAX_LENGTH          3
#define SQL_ASYNC_ENABLE        4
#define SQL_BIND_TYPE           5

#define SQL_BIND_BY_COLUMN      0    /* Suboption for SQL_BIND_TYPE */

#define SQL_ACCESS_MODE         101
#define SQL_AUTOCOMMIT          102
#define SQL_LOGIN_TIMEOUT       103
#define SQL_OPT_TRACE           104
#define SQL_OPT_TRACEFILE       105
#define SQL_TRANSLATE_DLL       106
#define SQL_TRANSLATE_OPTION    107
#define SQL_TXN_ISOLATION       108
#define SQL_CONNECT_OPT_DRVR_START  1000

#define SQL_BEST_ROWID 1
#define SQL_ROWVER     2

#define SQL_SCOPE_CURROW       0
#define SQL_SCOPE_TRANSACTION  1
#define SQL_SCOPE_SESSION      2

RETCODE  SQL_API SQLColumns(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName,
    UCHAR  FAR *szColumnName,
    SWORD      cbColumnName);

RETCODE  SQL_API SQLDriverConnect(
    HDBC       hdbc,
    HWND       hwnd,
    UCHAR  FAR *szConnStrIn,
    SWORD      cbConnStrIn,
    UCHAR  FAR *szConnStrOut,
    SWORD      cbConnStrOutMax,
    SWORD  FAR *pcbConnStrOut,
    UWORD      fDriverCompletion);

RETCODE  SQL_API SQLGetConnectOption(
    HDBC       hdbc,
    UWORD      fOption,
    PTR        pvParam);

RETCODE  SQL_API SQLGetData(
    HSTMT      hstmt,
    UWORD      icol,
    SWORD      fCType,
    PTR        rgbValue,
    SDWORD     cbValueMax,
    SDWORD FAR *pcbValue);

RETCODE  SQL_API SQLGetFunctions(
    HDBC       hdbc,
    UWORD      fFunction,
    UWORD  FAR *pfExists);

RETCODE  SQL_API SQLGetInfo(
    HDBC       hdbc,
    UWORD      fInfoType,
    PTR        rgbInfoValue,
    SWORD      cbInfoValueMax,
    SWORD  FAR *pcbInfoValue);

RETCODE  SQL_API SQLGetStmtOption(
    HSTMT      hstmt,
    UWORD      fOption,
    PTR        pvParam);

RETCODE  SQL_API SQLGetTypeInfo(
    HSTMT      hstmt,
    SWORD      fSqlType);

RETCODE  SQL_API SQLParamData(
    HSTMT      hstmt,
    PTR    FAR *prgbValue);

RETCODE  SQL_API SQLPutData(
    HSTMT      hstmt,
    PTR        rgbValue,
    SDWORD     cbValue);

RETCODE  SQL_API SQLSetConnectOption(
    HDBC       hdbc,
    UWORD      fOption,
    UDWORD     vParam);

RETCODE  SQL_API SQLSetStmtOption(
    HSTMT      hstmt,
    UWORD      fOption,
    UDWORD     vParam);

RETCODE  SQL_API SQLSpecialColumns(
    HSTMT      hstmt,
    UWORD      fColType,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName,
    UWORD      fScope,
    UWORD      fNullable);

RETCODE  SQL_API SQLStatistics(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName,
    UWORD      fUnique,
    UWORD      fAccuracy);

RETCODE  SQL_API SQLTables(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName,
    UCHAR  FAR *szTableType,
    SWORD      cbTableType);

#define SQL_FETCH_NEXT      1
#define SQL_FETCH_FIRST     2
#define SQL_FETCH_LAST      3
#define SQL_FETCH_PREV      4
#define SQL_FETCH_ABSOLUTE  5
#define SQL_FETCH_RELATIVE  6
#define SQL_FETCH_RESUME    7

#define SQL_ROW_SUCCESS     0
#define SQL_ROW_DELETED     1
#define SQL_ROW_UPDATED     2
#define SQL_ROW_NOROW       3

#define SQL_CASCADE         0
#define SQL_RESTRICT        1
#define SQL_SET_NULL        2

#define SQL_PARAM_TYPE_UNKNOWN  0
#define SQL_PARAM_INPUT         1
#define SQL_PARAM_INPUT_OUTPUT  2
#define SQL_RESULT_COL          3

#define SQL_CONCUR_READ_ONLY    1
#define SQL_CONCUR_LOCK         2
#define SQL_CONCUR_TIMESTAMP    3
#define SQL_CONCUR_VALUES       4

#define SQL_SCROLL_FORWARD_ONLY      0
#define SQL_SCROLL_KEYSET_DRIVEN    -1
#define SQL_SCROLL_DYNAMIC          -2

#define SQL_INDEX_UNIQUE    0
#define SQL_INDEX_ALL       1
#define SQL_ENSURE          1
#define SQL_QUICK           0

#define SQL_TABLE_STAT      0
#define SQL_INDEX_CLUSTERED 1
#define SQL_INDEX_HASHED    2
#define SQL_INDEX_OTHER     3

#define SQL_ENTIRE_ROWSET      0

RETCODE  SQL_API SQLBrowseConnect(
    HDBC       hdbc,
    UCHAR  FAR *szConnStrIn,
    SWORD      cbConnStrIn,
    UCHAR  FAR *szConnStrOut,
    SWORD      cbConnStrOutMax,
    SWORD  FAR *pcbConnStrOut);

RETCODE  SQL_API SQLColumnPrivileges(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName,
    UCHAR  FAR *szColumnName,
    SWORD      cbColumnName);

RETCODE  SQL_API SQLDataSources(
    HENV       henv,
    UWORD      fDirection,
    UCHAR  FAR *szDSN,
    SWORD      cbDSNMax,
    SWORD  FAR *pcbDSN,
    UCHAR  FAR *szDescription,
    SWORD      cbDescriptionMax,
    SWORD  FAR *pcbDescription);

RETCODE  SQL_API SQLDescribeParam(
    HSTMT      hstmt,
    UWORD      ipar,
    SWORD  FAR *pfSqlType,
    UDWORD FAR *pcbColDef,
    SWORD  FAR *pibScale,
    SWORD  FAR *pfNullable);
               
RETCODE  SQL_API SQLExtendedFetch(
    HSTMT      hstmt,
    UWORD      fFetchType,
    SDWORD     irow,
    UDWORD FAR *pcrow,
    UWORD  FAR *rgfRowStatus);

RETCODE  SQL_API SQLForeignKeys(
    HSTMT      hstmt,
    UCHAR  FAR *szPkTableQualifier,
    SWORD      cbPkTableQualifier,
    UCHAR  FAR *szPkTableOwner,
    SWORD      cbPkTableOwner,
    UCHAR  FAR *szPkTableName,
    SWORD      cbPkTableName,
    UCHAR  FAR *szFkTableQualifier,
    SWORD      cbFkTableQualifier,
    UCHAR  FAR *szFkTableOwner,
    SWORD      cbFkTableOwner,
    UCHAR  FAR *szFkTableName,
    SWORD      cbFkTableName);

RETCODE  SQL_API SQLMoreResults(
    HSTMT      hstmt);

RETCODE  SQL_API SQLNativeSql(
    HDBC       hdbc,
    UCHAR  FAR *szSqlStrIn,
    SDWORD     cbSqlStrIn,
    UCHAR  FAR *szSqlStr,
    SDWORD     cbSqlStrMax,
    SDWORD FAR *pcbSqlStr);

RETCODE  SQL_API SQLNumParams(
    HSTMT      hstmt,
    SWORD  FAR *pcpar);

RETCODE  SQL_API SQLParamOptions(
    HSTMT      hstmt,
    UDWORD     crow,
    UDWORD FAR *pirow);

RETCODE  SQL_API SQLPrimaryKeys(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName);

RETCODE  SQL_API SQLProcedureColumns(
    HSTMT      hstmt,
    UCHAR  FAR *szProcQualifier,
    SWORD      cbProcQualifier,
    UCHAR  FAR *szProcOwner,
    SWORD      cbProcOwner,
    UCHAR  FAR *szProcName,
    SWORD      cbProcName,
    UCHAR  FAR *szColumnName,
    SWORD      cbColumnName);

RETCODE  SQL_API SQLProcedures(
    HSTMT      hstmt,
    UCHAR  FAR *szProcQualifier,
    SWORD      cbProcQualifier,
    UCHAR  FAR *szProcOwner,
    SWORD      cbProcOwner,
    UCHAR  FAR *szProcName,
    SWORD      cbProcName);

RETCODE  SQL_API SQLSetPos(
    HSTMT      hstmt,
    UWORD      irow,
    BOOL       fRefresh,
    BOOL       fLock);

RETCODE  SQL_API SQLSetScrollOptions(
    HSTMT      hstmt,
    UWORD      fConcurrency,
    SDWORD     crowKeyset,
    UWORD      crowRowset);

RETCODE  SQL_API SQLTablePrivileges(
    HSTMT      hstmt,
    UCHAR  FAR *szTableQualifier,
    SWORD      cbTableQualifier,
    UCHAR  FAR *szTableOwner,
    SWORD      cbTableOwner,
    UCHAR  FAR *szTableName,
    SWORD      cbTableName);

#ifdef __cplusplus
}
#endif

#endif

#ifdef ZQZ_PASCAL_DEFINE
#undef PASCAL
#undef ZQZ_PASCAL_DEFINE
#endif

#ifdef ZQZ_FAR_DEFINE
#undef FAR
#undef ZQZ_FAR_DEFINE
#endif

#ifdef ZQZ_HWND_DEFINE
#undef HWND
#undef ZQZ_HWND_DEFINE
#endif

#ifdef ZQZ_TRUE_DEFINE
#undef TRUE
#undef ZQZ_TRUE_DEFINE
#endif

#ifdef ZQZ_FALSE_DEFINE
#undef FALSE
#undef ZQZ_FALSE_DEFINE
#endif

#ifdef ZQZ_BOOL_DEFINE
#undef BOOL
#undef ZQZ_BOOL_DEFINE
#endif

#endif
