/* Find out if a column is indexed

   This program is mentioned in chapter 6 of OPTIMIZING SQL, by Peter
   Gulutzan + Trudy Pelzer; R&D Publications 1994. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ocelot.h"
#define NON_UNIQUE 4	/*4th in result set, =FALSE if UNIQUE index*/
#define INDEX_NAME 6	/*6th in result set, =name of index */
#define SEQ_IN_INDEX 8	/*8th in result set, =col seq no, starts with 1*/
#define COLUMN_NAME 9	/*9th in result set, =name of column*/

#define NULL 0
#define	FALSE 0
int index_column_check (HSTMT hstmt);

void main ()
{
  HENV henv;
  HDBC hdbc;
  HSTMT hstmt;
  int i;

  SQLAllocEnv(&henv);
  SQLAllocConnect(henv,&hdbc);
  SQLAllocStmt(hdbc,&hstmt);
  SQLConnect(hdbc,"x",SQL_NTS,"",SQL_NTS,"",SQL_NTS);
  i=index_column_check(hstmt);
  if (i==0) printf("not indexed\n");
  if (i==1) printf("not first in any index\n");
  if (i==2) printf("not alone in UNIQUE index\n");
  if (i==3) printf("alone in UNIQUE index\n"); }
  SQLFreeStmt(hstmt,SQL_DROP);
  SQLDisconnect(hdbc);
  SQLFreeConnect(hdbc);
  SQLFreeEnv(henv); }

int index_column_check (HSTMT hstmt)
{
  RETCODE retcode;
  char query_table_name[18+1];
  SWORD sNonUnique;
  UCHAR szIndexName[18+1];
  SWORD sSeqInIndex;
  UCHAR szColumnName[18+1];
  SDWORD cbNonUnique,cbIndexName,cbSeqInIndex,cbColumnName;
  int occurs,occursfirst,occursfirstunique;
  char query_column_name[18+1];
  char uniqueindexname[18+1];

  printf("Enter table name:"); gets(query_table_name);
  printf("Enter column name:"); gets(query_column_name);

  retcode=SQLStatistics(hstmt,NULL,NULL,NULL,NULL,
  query_table_name,SQL_NTS,SQL_INDEX_ALL,SQL_QUICK);
  if (retcode!=SQL_SUCCESS && retcode!=SQL_SUCCESS_WITH_INFO) {
    return (0); }
  SQLBindCol(hstmt,NON_UNIQUE,SQL_C_SHORT,&sNonUnique,0,&cbNonUnique);
  SQLBindCol(hstmt,INDEX_NAME,SQL_C_CHAR,szIndexName,18+1,&cbIndexName);
  SQLBindCol(hstmt,SEQ_IN_INDEX,SQL_C_SHORT,&sSeqInIndex,0,&cbSeqInIndex);
  SQLBindCol(hstmt,COLUMN_NAME,SQL_C_CHAR,szColumnName,18+1,&cbColumnName);
     
  for (occurs=0,occursfirst=0,occursfirstunique=0;;) {
    retcode=SQLFetch(hstmt);
    if (retcode!=SQL_SUCCESS &&retcode!=SQL_SUCCESS_WITH_INFO) {
      break; }
    if (stricmp(szColumnName,query_column_name)==0) {
      ++occurs;				/* col occurs in some index */
      if (sSeqInIndex==1) {
        ++occursfirst;			/*col occurs first in some index*/
        if (sNonUnique==FALSE) {
          ++occursfirstunique;		/*col occurs first in unique index*/
          strcpy(uniqueindexname,szIndexName); } } }
    else if (sSeqInIndex==2) {
      if (occursfirstunique>0) {
      if (stricmp(uniqueindexname,szIndexName)==0) {
        /* This is the second column of a unique index, for
           which we incremented occursfirstunique.  We were wrong to do so. */
          --occursfirstunique; } } } }
  if (occursfirstunique>0) return (3);	/* "column is uniquely indexed" */
  if (occursfirst>0) return (2);	/* "column is indexed" */
  if (occurs>0) return (1);		/* "column is somewhere in index" */
  return (0); }				/* "column is not in any index" */
