'======================================================================='
'                                                                       '
'                        QELink.TXT                                 '
'                                                                       '
'                  Q+E Visual Basic Custom Controls                     '
'                         for All drivers                                 '
'                      Global Constants File                            '
'                                                                       '
'======================================================================='

'======================================================================='
'         Copyright: 1992 Pioneer Software Systems, Inc.                '
'                                                                       '
'         This software contains confidential and proprietary           '
'           information of Pioneer Software Systems, Inc.               '
'======================================================================='

'==============='
'  Error Codes  '
'==============='

Global Const QE_ERROR_CODES = 31000
Global Const QE_FUNCTION_ABORTED = 31001
Global Const QE_RECORD_NOT_FOUND = 31002
Global Const QE_DB_ERROR = 31003
Global Const QE_RECORD_LOCKED = 31004
Global Const QE_RECORD_CHANGED = 31005

'======================'
'  Record State Codes  '
'======================'

Global Const RECSTATE_NO_RECORD = 0
Global Const RECSTATE_FETCHING = 1
Global Const RECSTATE_UNCHANGED = 2
Global Const RECSTATE_CHANGED = 3
Global Const RECSTATE_NEW_UNCHANGED = 4
Global Const RECSTATE_NEW_CHANGED = 5
Global Const RECSTATE_QBE_UNCHANGED = 6
Global Const RECSTATE_QBE_CHANGED = 7
Global Const RECSTATE_COPYING = 8
Global Const RECSTATE_ENTERING_QBE = 9
Global Const RECSTATE_CLEARING_QBE = 10
Global Const RECSTATE_CLEARING_NEW = 11

'=================='
'  Function Codes  '
'=================='

Global Const F_DOQUERY = 1
Global Const F_ENDQUERY = 2
Global Const F_NEXT = 3
Global Const F_PREVIOUS = 4
Global Const F_RANDOM = 5
Global Const F_NEW = 6
Global Const F_ENTERQBE = 7
Global Const F_CLEARQBE = 8
Global Const F_INSERT = 9
Global Const F_UPDATE = 10
Global Const F_DELETE = 11
Global Const F_LOCK = 12
Global Const F_TRANBEGIN = 13
Global Const F_TRANCOMMIT = 14
Global Const F_TRANROLLBACK = 15
Global Const F_EXECSQL = 16
Global Const F_LOGON = 17
Global Const F_LOGOFF = 18

'========================================================'
' The following keywords can be used as the controltype  '
' in Visual Basic's "If...TypeOf" statement to identify  '
' the exact type of a QEVBDBF control.                   '
'                                                        '
'       QueryClass                                       '
'       QGrid                                            '
'       DB_CommandClass                                  '
'       DB_HScrollClass                                  '
'       DB_VScrollClass                                  '
'       DB_TextClass                                     '
'       DB_ComboClass                                    '
'       DB_ListClass                                     '
'       DB_CheckClass                                    '
'       DB_RadioGroupClass                               '
'       DB_PictureClass                                  '
'                                                        '
' ====================================================== '

'====================='
'  Declare Functions  '
'====================='

Declare Function fDoQuery Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fEndQuery Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fNext Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fPrevious Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fRandom Lib "QELink.vbx" (queryCtl As Control, ByVal RecNumber&) As Integer
Declare Function fNew Lib "QELink.vbx" (queryCtl As Control, ByVal rowIndex%, ByVal before%) As Integer
Declare Function fEnterQBE Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fClearQBE Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fInsert Lib "QELink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fUpdate Lib "QELink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fDelete Lib "QELink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fLock Lib "QELink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fTranBegin Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fTranCommit Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fTranRollback Lib "QELink.vbx" (queryCtl As Control) As Integer
Declare Function fExecSQL Lib "QELink.vbx" (queryCtl As Control, ByVal SQLStmt$) As Integer
Declare Function fLogon Lib "QELink.vbx" (connectionCtl As Control) As Integer
Declare Function fLogoff Lib "QELink.vbx" (connectionCtl As Control) As Integer

'====================='
'  Windows Functions  '
'====================='

Declare Function GetDC Lib "user" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "user" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function GetDeviceCaps Lib "gdi" (ByVal hDC As Integer, ByVal index As Integer) As Integer

