' Definitions for ODBCINST.DLL

' Constants
Global Const ODBC_ADD_DSN = 1
Global Const ODBC_CONFIG_DSN = 2
Global Const ODBC_REMOVE_DSN = 3

Dim qeODBCIni As String
Dim qeODBCInst As String

' Functions

Declare Function SQLConfigDataSource Lib "ODBCINST.DLL" (ByVal hwndParent As Integer, ByVal fRequest As Integer, ByVal lpszDriver As String, ByVal lpszAttributes As String) As Integer

Declare Function qeGetWindowsDirectory Lib "Kernel" Alias "GetWindowsDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function qeGetSystemDirectory Lib "Kernel" Alias "GetSystemDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function qeWritePrivateProfileString% Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString$, ByVal lpFileName$)
Declare Function qeGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpRetString$, ByVal nSize%, ByVal lpFileName$) As Integer

 

Function QECreateDataSource (ByVal DSN As String, ByVal driverName As String) As Integer
    QECreateDataSource = SQLConfigDataSource(0, ODBC_ADD_DSN, driverName, "DSN=" + DSN)

End Function

Sub QEInitSetup ()
    Dim temp As String * 128

    res% = qeGetWindowsDirectory(temp, 128)
    qeWinDir$ = UCase$(Left$(temp, res%)) + "\"

    res% = qeGetSystemDirectory(temp, 128)
    qeWinSysDir$ = UCase$(Left$(temp, res%)) + "\"

    qeODBCInst = qeWinDir$ + "ODBCINST.INI"
    qeODBCIni = qeWinDir$ + "ODBC.INI"

End Sub

Function QEInstallDriver (ByVal driverName As String, ByVal dllName As String) As Integer

    Dim ODBCInst As String

    res% = qeWritePrivateProfileString(driverName, "Driver", dllName, qeODBCInst)
    res% = qeWritePrivateProfileString(driverName, "Setup", dllName, qeODBCInst)
    res% = qeWritePrivateProfileString("ODBC Drivers", driverName, "Installed", qeODBCInst)

' Return OK error code

    QEInstallDriver = 1
    
End Function

Function QESetDataSourceOption (ByVal DSN As String, ByVal keyword As String, ByVal value As String) As Integer
    QESetDataSourceOption = qeWritePrivateProfileString(DSN, keyword, value, qeODBCIni$)
End Function

