
		/*-----------------------------+
		|         MLEXTEND.H           |
		+------------------------------+
		| Multilink Extension Include  |
		+-----------------------------*/

/*--------------------------------------------------------------+
|  Copyright: 1993 Pioneer Software, Inc.			|
|								|
|	This software contains confidential and	proprietary	|
|	information of Pioneer Software, Inc.			|
+--------------------------------------------------------------*/

#ifndef MLEXTEND
#define MLEXTEND


// The following declarations are needed when using the Borland C or C++
// compilers.

#ifdef __BORLANDC__
#define qeAPI		far pascal
#define qeLPSTR		char far *
#define qeLPDEC		qeLPSTR
#define qeLPVOID	void far *
#define qeLPLONG	long far *
#define qeHANDLE	short
#define qeSTATUS	short
#define qeRETFLT	float far *
#define qeRETDBL	double far *
#define qeHIDDENFLT	, float _ss *
#define qeHIDDENDBL	, double _ss *
#endif

// The following declarations are needed when using the Microsoft C or C++
// compilers

#ifndef qeAPI
#define qeAPI		__loadds __export far pascal
#define qeLPSTR		char far *
#define qeLPDEC		qeLPSTR
#define qeLPVOID	void far *
#define qeLPLONG	long far *
#define qeHANDLE	short
#define qeSTATUS	short
#define qeRETFLT	float
#define qeRETDBL	double
#define qeHIDDENFLT
#define qeHIDDENDBL
#endif

//-----------------------------------------------------------------------------
// Routines that may be exported by MLEXTEND.DLL
//-----------------------------------------------------------------------------

//--------
// MLINIT
//--------

void qeAPI	mlInit (qeHANDLE hTask,
		        unsigned short usVersion,
		        int fRuntime);

// mlInit is an initializtion routine.  It is called each time a VB generated
// executable program (EXE) is run.  It is also called each time a VB
// project is Opened in the VB designer.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to
//		mlTerm, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//
//	usVersion: the version of VB being run.  This can be used to
//		distinguish between the different versions of VB that may
//		exist.
//
//	fRuntime: 0 if opening a project in the VB designer, not equal to
//		0 if running a executable file (EXE).

//--------
// MLTERM
//--------

void qeAPI	mlTerm (qeHANDLE hTask);

// mlTerm is a termination routine.  It is called each time a VB generated
// executable program (EXE) terminates.  It is also called each time a VB
// project is Closed in the VB designer.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.

//---------
// MLLOGON
//---------

qeHANDLE qeAPI	mlLogon (qeHANDLE hTask,
			 qeLPSTR  ConnectCtlName,
			 qeLPSTR  pSource,
			 qeLPSTR  pLogonInfo);

// mlLogon is called each time Multilink needs to logon to a database system.
// This may be called in the VB designer, or from VB generated executables.
// To logon to a database, this routine must call the qeConnect routine
// defined below and exported by QELINK.VBX.  qeConnect returns a handle
// to a database connection (HDBC).  The HDBC should be returned by mlLogon.
// HDBC's are integer values > 0.
//
// Returns: the HDBC returned by qeConnect.
//	    Return qeUSER_CANCELLED (-4) if mlLogon is unable to connect to
//	    the database, or if the user cancelled the logon attempt.
//	    Return 0 to force QELINK.VBX to attempt to logon to the database.
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//
//	ConnectCtlName: name of the connection control that is generating
//		the database logon.  This is a read-only parameter.
//
//	pSource: value of the pSource property of the connection control.
//		This is a read-only parameter.  If the connection control's
//		pSource property has not been specified, this parameter may
//		be a NULL pointer.
//
//	pLogonInfo: value of the pLogonInfo property of the connection control.
//		This is a read-only parameter.  If the connection control's
//		pLogonInfo property has not been specified, this parameter may
//		be a NULL pointer.

//----------
// MLLOGOFF
//----------

void qeAPI	mlLogoff (qeHANDLE hTask,
			  qeHANDLE hdbc);

// mlLogoff is called each time Multilink needs to logoff from a database
// system.  This may be called in the VB designer, or from VB generated
// executables.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//	hdbc: The handle to the database connection (HDBC) returned by the
//		corresponding call to mlLogon.


//-----------------------------------------------------------------------------
// Routines exported by QELINK.VBX that may be called by routines in
// MLEXTEND.DLL.
//
// Note: These are a subset of the functions provided in the Q+E Database
// Library product (QELIB).
//-----------------------------------------------------------------------------

/* Useful constants */

#define qeMAX_ERR_MSG_LEN 512		/* Max length of an error message */

// Possible result code values returned by qeErr and other functions

#define qeUSER_CANCELLED	-4	/* User cancelled out of the logon */
					/* dialog box. */
#define qeOUT_OF_MEMORY		-3	/* Insufficient memory for operation*/
#define qeSUCCESS		0	/* Success */
#define qeDBSYS_ERROR		4	/* Error detected by the underlying */
					/* database system or driver. The */
					/* native error returned by qeDBErr */
					/* gives more specifics. */

//-------------------------------
// Database Connection functions 
//-------------------------------

//-----------
// QECONNECT
//-----------

qeHANDLE qeAPI qeConnect (
	qeLPSTR con_string);

// Opens a connection to a database system and returns the handle to 
// the connection (HDBC).  This logs-on to a database system.
//
// Returns: >0 if the connection was established.  The value is the handle
//		to the connection (HDBC) that identifies this database
//		connection.
//	    0 if connect fails.
//	    qeUSER_CANCELLED (-4) if the user cancelled the connection.
//
//	    If a 0 is returned, call qeErr to get an error number, and
//	    qeErrMsg or qeErrMsgBuf to get the corresponding error message.
//
// Parameters:
//
//	con_string: connection string that identifies the database system,
//		user name, password, and any other information required to
//		logon to a database system.  See the individual database
//		chapters in the User Guide for more information.

//--------------
// QEDISCONNECT
//--------------

qeSTATUS qeAPI qeDisconnect (
	qeHANDLE hdbc);

// Closes a connection to a database system.  This logs-off from a database
// system.
//
// Returns: A result code indicating whether the function succeeded.
//	    qeSUCCESS (0) means the function succeeded.
//
// Parameters:
//
//	hdbc: The handle to the database connection (HDBC) returned by the
//		corresponding call to qeConnect.

//--------------------------
// Error Handling functions 
//--------------------------

//-------
// QEERR
//-------

qeSTATUS qeAPI qeErr (void);

// Returns result code from most recent call to qeConnect or qeDisconnect.

//---------
// QEDBERR
//---------

long qeAPI qeDBErr (void);

// Returns database system error code from most recent call to qeConnect or
// qeDisconnect.

//----------
// QEERRMSG
//----------

qeLPSTR qeAPI qeErrMsg (void);

// Returns pointer to error message from most recent call to qeConnect or
// qeDisconnect.

//-------------
// QEERRMSGBUF
//-------------

void qeAPI qeErrMsgBuf (
	qeLPSTR	msg_buf);

// Retrieves error message from most recent call to qeConnect or qeDisconnect.
//
// Parameters:
//
//	msg_buf: a pointer to a buffer of at least qeMAX_ERR_MSG_LEN (512)
//		bytes to hold the error message.  This routine will fill the
//		buffer with the error message.

#endif

