//---------------------------------------------------------------------------
// mlExtend.cpp
//---------------------------------------------------------------------------
// Contains code to build the mlExtend DLL
//---------------------------------------------------------------------------
//
// Date: March 1993
//
// Copyright: 1993 Pioneer Software, Inc.
//
// This software contains confidential and proprietary
// information of Pioneer Software, Inc.
//
//--------------------------------------------------------------------------

#include <string.h>
#include "mlextend.h"

void qeAPI	mlInit (qeHANDLE hTask,
		        unsigned short usVersion,
		        int fRuntime)

// mlInit is an initializtion routine.  It is called each time a VB generated
// executable program (EXE) is run.  It is also called each time a VB
// project is Opened in the VB designer.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to
//		mlTerm, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//
//	usVersion: the version of VB being run.  This can be used to
//		distinguish between the different versions of VB that may
//		exist.
//
//	fRuntime: 0 if opening a project in the VB designer, not equal to
//		0 if running a executable file (EXE).
{
	// Add code here if you need to do some work each time a program
	// starts.
}

void qeAPI	mlTerm (qeHANDLE hTask)

// mlTerm is a termination routine.  It is called each time a VB generated
// executable program (EXE) terminates.  It is also called each time a VB
// project is Closed in the VB designer.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
{
	// Add code here if you need to do some work each time a program
	// ends.
}

qeHANDLE qeAPI	mlLogon (qeHANDLE hTask,
			 qeLPSTR  ConnectCtlName,
			 qeLPSTR  pSource,
			 qeLPSTR  pLogonInfo)

// mlLogon is called each time Multilink needs to logon to a database system.
// This may be called in the VB designer, or from VB generated executables.
// To logon to a database, this routine must call the qeConnect routine
// defined below and exported by QELINK.VBX.  qeConnect returns a handle
// to a database connection (HDBC).  The HDBC should be returned by mlLogon.
// HDBC's are integer values > 0.
//
// Returns: the HDBC returned by qeConnect.
//	    Return qeUSER_CANCELLED (-4) if mlLogon is unable to connect to
//	    the database, or if the user cancelled the logon attempt.
//	    Return 0 to force QELINK.VBX to attempt to logon to the database.
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//
//	ConnectCtlName: name of the connection control that is generating
//		the database logon.  This is a read-only parameter.
//
//	pSource: value of the pSource property of the connection control.
//		This is a read-only parameter.  If the connection control's
//		pSource property has not been specified, this parameter may
//		be a NULL pointer.
//
//	pLogonInfo: value of the pLogonInfo property of the connection control.
//		This is a read-only parameter.  If the connection control's
//		pLogonInfo property has not been specified, this parameter may
//		be a NULL pointer.

{
	qeHANDLE hdbc = 0;
	char con_string[256];

	// Note: The format of connection strings is
	//
	//	<attribute>=<value>[;<attribute>=<value>...]
	//
	// The first attribute must be the LOGN attribute.  Its value
	// can be any value that appears in the drop-down for the pSource
	// property.
	//
	// (Note for QELIB users: The DRV attribute used in QELIB cannot
	// be used with Multilink.  You must use the LOGN attribute instead.)
	//
	// If you include DLG=1 in the connection string, the call to
	// qeConnect will force the logon dialog box to be displayed.
	//
	// Other attributes are described in the User's Guide for the
	// individual database drivers.

	// The following code simply builds a connection string given the
	// values of the pSource and pLogonInfo properties of the
	// connection control

	if (pSource != 0) {
		strcpy (con_string, "LOGN=");
		strcat (con_string, pSource);

		// Force the Logon dialog box to appear for SQL database
		// systems.  This is optional
		
		strcat (con_string, ";DLG=1");

		// If any attributes are specified in the pLogonInfo
		// parameter, add them to the connection string.
		
		if (pLogonInfo != 0) {
			strcat (con_string, ";");
			strcat (con_string, pLogonInfo);
		}
	}
	else
		return (0);	// Let Multilink handle this error case

	// Form a connection to the database system by calling the
	// function exported from QELINK.VBX
	
	hdbc = qeConnect (con_string);

	// Check for errors and user cancelled (only possible if DLG=1 used)
	
	if (hdbc == 0) {
		if (qeErr() == qeUSER_CANCELLED)
			return (qeUSER_CANCELLED);
		else
			//Add code here to handle logon errors
			return (qeUSER_CANCELLED);
	}

	// Return the HDBC returned from the call to qeConnect
	
	return (hdbc);
}

void qeAPI	mlLogoff (qeHANDLE hTask,
			  qeHANDLE hdbc)

// mlLogoff is called each time Multilink needs to logoff from a database
// system.  This may be called in the VB designer, or from VB generated
// executables.
//
// Returns: N/A
//
// Parameters:
//
//	hTask: a task handle.  Multilink assigns a task handle to each
//		VB program that is run.  The task handle uniquely identifies
//		the program.  The same value will be sent to all calls to 
//		mlInit, mlLogon, or mlLogoff generated by the program, so
//		you may use this value to identify the individual programs
//		if more than one VB program is being run on a computer.
//	hdbc: The handle to the database connection (HDBC) returned by the
//		corresponding call to mlLogon.
{
	// Simply call the function exported from QELINK.VBX to logoff from
	// the database system
	
	qeDisconnect (hdbc);
}
