'======================================================================='
'                                                                       '
'                          QeLink.txt                                   '
'                                                                       '
'                   Q+E Multilink/VB Version 2.0                        '
'                      Global Constants File                            '
'                                                                       '
'======================================================================='

'======================================================================='
'         Copyright: 1992-93 Q+E Software, Inc.                         '
'                                                                       '
'         This software contains confidential and proprietary           '
'           information of Q+E Software Systems, Inc.                   '
'======================================================================='

'==============='
'  Error Codes  '
'==============='

Global Const QE_ERROR_CODES = 31000
Global Const QE_FUNCTION_ABORTED = 31001
Global Const QE_RECORD_NOT_FOUND = 31002
Global Const QE_DB_ERROR = 31003
Global Const QE_RECORD_LOCKED = 31004
Global Const QE_RECORD_CHANGED = 31005
Global Const QE_LOGON_CANCELLED = 31008

'======================'
'  Record State Codes  '
'======================'

Global Const RECSTATE_NO_RECORD = 0
Global Const RECSTATE_FETCHING = 1
Global Const RECSTATE_UNCHANGED = 2
Global Const RECSTATE_CHANGED = 3
Global Const RECSTATE_NEW_UNCHANGED = 4
Global Const RECSTATE_NEW_CHANGED = 5
Global Const RECSTATE_QBE_UNCHANGED = 6
Global Const RECSTATE_QBE_CHANGED = 7
Global Const RECSTATE_COPYING = 8
Global Const RECSTATE_ENTERING_QBE = 9
Global Const RECSTATE_CLEARING_QBE = 10
Global Const RECSTATE_CLEARING_NEW = 11
Global Const RECSTATE_FIND_UNCHANGED = 12
Global Const RECSTATE_FIND_CHANGED = 13
Global Const RECSTATE_ENTERING_FIND = 14
Global Const RECSTATE_CLEARING_FIND = 15

'============================'
'  pOneHstmtOptions Flags    '
'============================'

Global Const QE_READAHEAD_AT_EXEC = &H1        ' Read entire solution set into
					       ' log at execute time
Global Const QE_READAHEAD_AT_UPDATE = &H2      ' Read remainder of solution
					       ' set into log at update,
					       ' delete, or lock
Global Const QE_READAHEAD_COMMIT_UPDATES = &H4   ' All updates must be
						 ' committed before any
						 ' additional fetching

Global Const QE_ROUTING_READ = &H8             ' Sends the statement to a
					       ' read connection.
Global Const QE_ROUTING_UPDATE = &H10          ' Sends the statement to the
					       ' transaction connection
Global Const QE_ROUTING_DEFAULT = &H18         ' Lets Multilink decide which
					       ' connection to send the
					       ' statement

Global Const QE_HSTMT_LOCAL = &H20             ' States that this hstmt
					       ' cannot affect any other
					       ' active hstmts in the same
					       ' app
Global Const QE_HSTMT_NONLOCAL = &H40          ' States that this hstmt may
					       ' affect other hstmts in the
					       ' same app

Global Const QE_NO_LOCK_ON_KEY_PRESS = &H1000  ' Do not lock records whenever
					       ' a field changes

Global Const QE_NO_COMPARE_AFTER_LOCK = &H2000 ' Do not compare fields before
					       ' placing locks

'======================='
'  pFieldType constants  '
'======================='

Global Const QE_CHAR = 1
Global Const QE_VARCHAR = 2
Global Const QE_DECIMAL = 3
Global Const QE_INTEGER = 4
Global Const QE_SMALLINT = 5
Global Const QE_FLOAT = 6
Global Const QE_DOUBLEPRECISION = 7
Global Const QE_DATETIME = 8
Global Const QE_LONGVARCHAR = 100
Global Const QE_BINARY = 101
Global Const QE_VARBINARY = 102
Global Const QE_LONGVARBINARY = 103
Global Const QE_BIGINT = 108
Global Const QE_TINYINT = 109
Global Const QE_BIT = 110
Global Const QE_DATE = 111
Global Const QE_TIME = 112


'================'
'  Find Options  '
'================'

Global Const QE_FIND_FIRST = 1
Global Const QE_FIND_LAST = 2
Global Const QE_FIND_NEXT = 3
Global Const QE_FIND_NEXT_SKIP = 4
Global Const QE_FIND_PREV = 5
Global Const QE_FIND_PREV_SKIP = 6


'=================='
'  Function Codes  '
'=================='

Global Const F_DOQUERY = 1
Global Const F_ENDQUERY = 2
Global Const F_NEXT = 3
Global Const F_PREVIOUS = 4
Global Const F_RANDOM = 5
Global Const F_NEW = 6
Global Const F_ENTERQBE = 7
Global Const F_CLEARQBE = 8
Global Const F_INSERT = 9
Global Const F_UPDATE = 10
Global Const F_DELETE = 11
Global Const F_LOCK = 12
Global Const F_TRANBEGIN = 13
Global Const F_TRANCOMMIT = 14
Global Const F_TRANROLLBACK = 15
Global Const F_EXECSQL = 16
Global Const F_LOGON = 17
Global Const F_LOGOFF = 18
Global Const F_DISCARD = 19
Global Const F_ENTERFIND = 20
Global Const F_FIND = 21
Global Const F_CLEARFIND = 22

'========================================================'
' The following keywords can be used as the controltype  '
' in Visual Basic's "If...TypeOf" statement to identify  '
' the exact type of a Multilink control.                 '
'                                                        '
'       ConnectClass                                     '
'       QueryClass                                       '
'       QGrid                                            '
'       DB_CommandClass                                  '
'       DB_HScrollClass                                  '
'       DB_VScrollClass                                  '
'       DB_TextClass                                     '
'       DB_ComboClass                                    '
'       DB_ListClass                                     '
'       DB_CheckClass                                    '
'       DB_RadioGroupClass                               '
'       DB_PictureClass                                  '
'                                                        '
' ======================================================'

'====================='
'  Declare Functions  '
'====================='

Declare Function fDoQuery Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fEndQuery Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fNext Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fPrevious Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fRandom Lib "qelink.vbx" (queryCtl As Control, ByVal RecNumber&) As Integer
Declare Function fNew Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%, ByVal before%) As Integer
Declare Function fEnterQBE Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fClearQBE Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fInsert Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fUpdate Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fDelete Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fDiscard Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fLock Lib "qelink.vbx" (queryCtl As Control, ByVal rowIndex%) As Integer
Declare Function fTranBegin Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fTranCommit Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fTranRollback Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fExecSQL Lib "qelink.vbx" (queryCtl As Control, ByVal SQLStmt$) As Integer
Declare Function fLogon Lib "qelink.vbx" (connectionCtl As Control) As Integer
Declare Function fLogoff Lib "qelink.vbx" (connectionCtl As Control) As Integer
Declare Function fEnterFind Lib "qelink.vbx" (queryCtl As Control) As Integer
Declare Function fFind Lib "qelink.vbx" (queryCtl As Control, ByVal options%) As Integer
Declare Function fClearFind Lib "qelink.vbx" (queryCtl As Control) As Integer

