'**************************************************************************
'*************************  Setup Detect API's  ***************************
'**************************************************************************

''detect

DECLARE FUNCTION CbGetVersionOfFile LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION LGetVersionNthField LIB "msdetstf.dll" (szVersion$, nField%) AS LONG
DECLARE FUNCTION LcbGetSizeOfFile LIB "msdetstf.dll" (szFile$) AS LONG
DECLARE FUNCTION FGetValidDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetLocalHardDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetRemovableDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FGetNetworkDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION LcbTotalDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION LcbFreeDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION FIsValidDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsLocalHardDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsRemoveDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FIsRemoteDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION FDirExists LIB "msdetstf.dll" (szDir$) AS INTEGER
DECLARE FUNCTION FDoesFileExist LIB "msdetstf.dll" (szFileName$, mode%) AS INTEGER
DECLARE FUNCTION CbGetDateOfFile LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION FDoesIniSectionExist LIB "msdetstf.dll" (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION FDoesIniKeyExist LIB "msdetstf.dll" (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION CbGetIniKeyString LIB "msdetstf.dll" (szFile$, szSect$, szKey$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION WGetDOSMajorVersion LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetDOSMinorVersion LIB "msdetstf.dll" AS INTEGER



'*************************************************************************
'****************  Detect Basic Wrapper Declarations  ********************
'*************************************************************************


'' detect

DECLARE FUNCTION IsDriveValid (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveLocalHard (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveRemovable (szDrive$) AS INTEGER
DECLARE FUNCTION IsDriveNetwork (szDrive$) AS INTEGER
DECLARE SUB GetValidDrivesList (szSymbol$)
DECLARE SUB GetLocalHardDrivesList (szSymbol$)
DECLARE SUB GetRemovableDrivesList (szSymbol$)
DECLARE SUB GetNetworkDrivesList (szSymbol$)
DECLARE FUNCTION GetTotalSpaceForDrive (szDrive$) AS LONG
DECLARE FUNCTION GetFreeSpaceForDrive (szDrive$) AS LONG

DECLARE FUNCTION GetDOSMajorVersion AS INTEGER
DECLARE FUNCTION GetDOSMinorVersion AS INTEGER
DECLARE FUNCTION GetEnvVariableValue (szEnvVar$) AS STRING
DECLARE FUNCTION GetNumWinApps AS INTEGER

DECLARE FUNCTION DoesFileExist (szFile$, mode%) AS INTEGER
DECLARE FUNCTION GetDateOfFile (szFile$) AS STRING
DECLARE FUNCTION GetYearFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetMonthFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetDayFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetHourFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetMinuteFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetSecondFromDate (szDate$) AS INTEGER
DECLARE FUNCTION GetVersionOfFile (szFile$) AS STRING
DECLARE FUNCTION GetVersionNthField (szVersion$, nField%) AS LONG
DECLARE FUNCTION GetSizeOfFile (szFile$) AS LONG
DECLARE FUNCTION FindTargetOnEnvVar (szFile$, szEnvVar$) AS STRING
DECLARE FUNCTION FindFileInTree (szFile$, szDir$) AS STRING
DECLARE FUNCTION DoesDirExist (szDir$) AS INTEGER

DECLARE FUNCTION DoesIniSectionExist (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) AS STRING

'*************************************************************************
FUNCTION IsDriveValid (szDrive$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveValid", szDrive$
    end if
'$endif ''DEBUG
    IsDriveValid = FIsValidDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION IsDriveLocalHard (szDrive$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveLocalHard", szDrive$
    end if
'$endif ''DEBUG
    IsDriveLocalHard = FIsLocalHardDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION IsDriveRemovable (szDrive$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveRemovable", szDrive$
    end if
'$endif ''DEBUG
    IsDriveRemovable = FIsRemoveDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION IsDriveNetwork (szDrive$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveNetwork", szDrive$
    end if
'$endif ''DEBUG
    IsDriveNetwork = FIsRemoteDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION GetTotalSpaceForDrive (szDrive$) STATIC  AS LONG
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "GetTotalSpaceForDrive", szDrive$
    end if
'$endif ''DEBUG
    GetTotalSpaceForDrive = LcbTotalDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION GetFreeSpaceForDrive (szDrive$) STATIC  AS LONG
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "GetFreeSpaceForDrive", szDrive$
    end if
'$endif ''DEBUG
    GetFreeSpaceForDrive = LcbFreeDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
SUB GetValidDrivesList (szSymbol$) STATIC
'$ifdef DEBUG
    if szSymbol$ = "" then
        BadArgErr 1, "GetValidDrivesList", szSymbol$
    end if
'$endif ''DEBUG
    if FGetValidDrivesList(szSymbol$) = 0 then
'$ifdef DEBUG
        StfApiErr saeFail, "GetValidDrivesList", szSymbol$
'$endif ''DEBUG
        ERROR STFERR
    end if
END SUB


'*************************************************************************
SUB GetLocalHardDrivesList (szSymbol$) STATIC
'$ifdef DEBUG
    if szSymbol$ = "" then
        BadArgErr 1, "GetLocalHardDrivesList", szSymbol$
    end if
'$endif ''DEBUG
    if FGetLocalHardDrivesList(szSymbol$) = 0 then
'$ifdef DEBUG
        StfApiErr saeFail, "GetLocalHardDrivesList", szSymbol$
'$endif ''DEBUG
        ERROR STFERR
    end if
END SUB


'*************************************************************************
'*************************************************************************
'*************************************************************************
FUNCTION GetDOSMajorVersion STATIC  AS INTEGER
    GetDOSMajorVersion = WGetDOSMajorVersion
END FUNCTION


'*************************************************************************
FUNCTION GetDOSMinorVersion STATIC  AS INTEGER
    GetDOSMinorVersion = WGetDOSMinorVersion
END FUNCTION


'*************************************************************************
'*************************************************************************
FUNCTION GetNumWinApps STATIC  AS INTEGER
    GetNumWinApps = WGetNumWinApps
END FUNCTION


'*************************************************************************
FUNCTION DoesFileExist (szFileName$, mode%) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidFATPath(szFileName$) = 0 then
        BadArgErr 1, "DoesFileExist", szFileName$+", "+STR$(mode%)
    end if
'$endif ''DEBUG
    DoesFileExist = FDoesFileExist(szFileName$, mode%)
END FUNCTION


'*************************************************************************
FUNCTION GetDateOfFile (szFile$) STATIC  AS STRING
'$ifdef DEBUG
    if FValidFATPath(szFile$) = 0 then
        BadArgErr 1, "GetDateOfFile", szFile$
    end if
'$endif ''DEBUG
    cb% = 20
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetDateOfFile(szFile$, szBuf$, cb%)
    GetDateOfFile = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetDateOfFile", szFile$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION GetVersionOfFile (szFile$) STATIC  AS STRING
'$ifdef DEBUG
    if FValidFATPath(szFile$) = 0 then
        BadArgErr 1, "GetVersionOfFile", szFile$
    end if
'$endif ''DEBUG
    cb% = 30
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetVersionOfFile(szFile$, szBuf$, cb%)
    GetVersionOfFile = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetVersionOfFile", szFile$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION GetVersionNthField (szVersion$, nField%) STATIC  AS LONG
'$ifdef DEBUG
    if (nField% < 1) OR (nField% > 4) then
        BadArgErr 2, "GetVersionNthField", szVersion$+", "+STR$(nField%)
    end if
'$endif ''DEBUG
    GetVersionNthField = LGetVersionNthField(szVersion$, nField%)
END FUNCTION


'*************************************************************************

'*************************************************************************
FUNCTION DoesDirExist (szDir$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidFATDir(szDir$) = 0 then
        BadArgErr 1, "DoesDirExist", szDir$
    end if
'$endif ''DEBUG
    DoesDirExist = FDirExists(szDir$)
END FUNCTION


'*************************************************************************
FUNCTION DoesIniSectionExist (szFile$, szSect$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        BadArgErr 1, "DoesIniSectionExist", szFile$+", "+szSect$
    end if
'$endif ''DEBUG
    DoesIniSectionExist = FDoesIniSectionExist(szFile$, szSect$)
END FUNCTION


'*************************************************************************
FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        n% = 1
    elseif szKey$ = "" then
        n% = 3
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "DoesIniKeyExist", szFile$+", "+szSect$+", "+szKey$
    end if
'$endif ''DEBUG

    DoesIniKeyExist = FDoesIniKeyExist(szFile$, szSect$, szKey$)
END FUNCTION


'*************************************************************************
FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) STATIC  AS STRING
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        n% = 1
    elseif szKey$ = "" then
        n% = 3
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
    end if
'$endif ''DEBUG

    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetIniKeyString(szFile$, szSect$, szKey$, szBuf$, cb%)
    GetIniKeyString = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION



