VarPush err,anim,dir,bmp,btn

ScreenGraphics err,320,200
If err=0 Goto "vga"

Delay 250
ScreenForcePaletteZeroBlack 1

AnimationPlay anim,-1,-1,1,32,"install"
VarSet dir,"C:\SMACKER"
TextBackColor 247
TextColor 255

:mainloop
  inputmsgwin btn,-1,64,14,"Install to %dir%?"
  if btn=2 goto "cancel"
  if btn=8 goto "newdir"

  direxists err,dir
  ifset err=1 check,"dexists","nexists"
  goto check

 :existok

  BitmapAlloc bmp,320,200
  BitmapFromScreen bmp,0,0
  BitmapGetPalette bmp

  ScreenFilledBox 92,84,136,32,247
  ScreenBox 93,85,134,30,255
  TextSetXY 124,93
  TextNoCR "Copying..."

  filecopy err,"demo.lzh",dir
  if err=0 goto "copyerr"
  filecopy err,"samp.lzh",dir
  if err=0 goto "copyerr"
  filecopy err,"smack.lzh",dir
  if err=0 goto "copyerr"
  filecopy err,"lha.exe",dir
  if err=0 goto "copyerr"
  filecopy err,"smackscr.exe",dir
  if err=0 goto "copyerr"
  filecopy err,"install.ss",dir
  if err=0 goto "copyerr"
  dirchange err,dir
  if err=0 goto "copyerr"

  BitmapToScreen bmp,0,0
  inputmsgwin btn,-1,64,0,"The files must now be uncompressed."

  ScreenText

  Text "*** Uncompressing the Smacker files... ***"
  Text "=========================================="
  execute err,"lha x smack -c+ -m+"
  if err<>0 goto "extracterr"

  Text ""
  Text "*** Uncompressing the demo files... ***"
  Text "======================================="
  execute err,"lha x demo -c+ -m+"
  if err<>0 goto "extracterr"

  Text ""
  Text "*** Uncompressing the sample flic... ***"
  Text "========================================"
  execute err,"lha x samp -c+ -m+"
  if err<>0 goto "extracterr"

  FileDelete err,"smack.lzh"
  FileDelete err,"demo.lzh"
  FileDelete err,"samp.lzh"
  FileDelete err,"lha.exe"

  ScreenGraphics err,320,200
  TextBackColor 247
  TextColor 255
  BitmapToScreen bmp,0,0
  BitmapFadeInPalette bmp
  BitmapFree bmp

  inputmsgwin btn,-1,64,0,"Installation Complete."

  inputmsgwin btn,-1,64,12,"Would you like to run the demo?"
  if btn=8 goto "nodemo"

  VarPop
  ScreenFadeOutClear 0
  call "demo"
  goto "done"

 :nodemo
  inputmsgwin btn,-1,64,0,'To run it later, type "DEMO".'
  VarPop

 :done
  ScreenText
  Text "Smacker installation was successful."
  Text ""
  Text "Thank you for your purchase!"
end



:dexists
  inputmsgwin btn,-1,64,14,"Directory exists, ok to install?"
  if btn=2 goto "cancel"
  if btn=8 goto "mainloop"
goto "existok"


:nexists
  inputmsgwin btn,-1,64,14,"Directory doesn't exist, create it?"
  if btn=2 goto "cancel"
  if btn=8 goto "mainloop"
  dirmake err,dir
  if err=1 goto "existok"
  inputmsgwin btn,-1,64,0,"Error making directory, try another."
goto "mainloop"


:newdir
  VarPush d
  inputstrwin d,-1,64,24,"Enter the directory to install to:"
  strtrim d,d
  if d<>"" varset dir=d
  VarPop d
Goto "mainloop"


:copyerr
  ScreenText
  Text "An error occurred coping the Smacker files to the directory."
end


:extracterr
  ScreenText
  Text "An error occurred while uncompressing the Smacker files."
end


:novga
  Text "The Smacker installation program requires a VGA video card."
End


:cancel
  ScreenText
  Text "Installation of Smacker was cancelled."
end


