static const char rcsid[]="$Id: cal.c 0.31 1994/09/12 00:31:00 tom Exp $";
/*
*  cal.c     (C)opyright 1994  Thomas Esken
*
*  UN*X like `cal' program (REPLACEMENT) with MORE features !
*
*  Prints a calendar (gregorian dates, before [ 1582 | 1752 ] julian dates)
*    of one specified month or of one specified year.
*      --> For further comments/information read the text below !
*      --> For installing/adapting read the text from line: 370 !
*
   **************************************************************************
   *                                                                        *
   *  Thomas Esken Software , Im Hagenfeld 84 , D-48147 M"unster , GERMANY  *
   *  --------------------------------------------------------------------  *
   *                                                                        *
   *  This software doesn't claim completeness, correctitude or usability.  *
   *  On principle I will not be liable for any damages or losses (implict  *
   *  or explicit), which result from using or handling my software.        *
   *  If you use this software, you agree without any exception to this     *
   *  agreement,                                                            *
   *                        which binds you LEGALLY !!                      *
   *                                                                        *
   **************************************************************************
*
*
*
*  System requirements :
*  ---------------------
*    Compiler         : any? ANSI-C compiler (GCC, TCC, BCC, MSC, WCC, XLC, CC...)
*    Computer         : MS-DOS/Linux PC, Atari ST, most UN*X Workstations,
*                         OS/2 in future, perhaps some Mainfraimes
*    RAM              : below 60 KByte(UN*X/MS-DOS) load size
*    Graphics adapter : none
*    Device driver    : [n]ansi.sys recommended, but not essential
*    Harddisk         : none
*
*
*
*  This `C' program is free software and distributed under the terms of the
*  `GNU General Public License'; published by the `Free Software Foundation';
*  version 2 or (at your option) any later version and the following condition:
*     If not permitted by the author, it's strictly forbidden to
*     include/bundle this software in a commerical software suite
*     (e.g., Novell's Linux project) !!
*
*  It is written in ANSI-C style using Turbo-C (2.0, ++1.0 ...)
*  and should be able to be compiled using any ANSI-C compiler.
*
*  Any suggestions, improvements, extensions, bug reports, donations,
*  proposals for contract work, and so forth are welcome !
*  Do what you like with this source and have fun  :)
*
*
*                                  \\\_''/'
*  -------------------------oOO    (/o-o\)    OOo-------------------------
*  Thomas Esken                o  (.  "  .)  o   Internet :
*  Im Hagenfeld 84              \___) ~ (___/      <esken@uni-muenster.de>
*  D-48147 M"unster; GERMANY                     Phone : (+49) 0251 232585
*
*
*
*  If you like this tool, I'd appreciate a postcard from you !
*
*
*
*  Incomplete history (dates from my brain):
*  -----------------------------------------
*  v0.31   19940912 Symbol ISO_ASCII eliminated (now !EXT_ASCII),
*                   changed my signature, print year using %04d format always,
*                   GNU coding-scheme implemented, several bugfixes
*  v0.30   19940909 Respected julian flag for rc appointments/holiday list,
*                   julian option modifiers [bfc] (thanks to John T. Foley),
*                   modified help screen,
*                   `~'-char in rc-file line is replaced by a `\n' newline char
*  v0.29   19940905 Included copyright notice (gpl) and version,
*                   u.s. holidays (US_HDAY),
*                   repected (internal)holidays in case symbol USE_RC is defined,
*                   ascending/descending sort of holiday list/rc appointments,
*                   several bugs fixed (internal version)
*  v0.28   19940827 Management of %byyyy && %yyyyy items in rc file
*  v0.27   19940824 Help screen / holiday list modified (highlighting)
*  v0.26   19940819 Extended year-list / year-range mode implemented
*                   (yyyy+yyyy   yyyy;...;yyyy)
*  v0.25   19940815 Extended month-list / month-range mode implemented
*                   (mm[/yyyy]-mm[/yyyy]   mm[/yyyy],...,mm[/yyyy])
*  v0.24   19940808 (quick)sorted output of rc file lines implemented (internal version)
*  v0.23   19940803 Some conditional compilation statements (USE_RC) added (internal version)
*  v0.22   19940717 Resource file management implemented (internal version)
*  v0.21   19940712 Textual day/month names feature added
*  v0.20   19940603 Variable starting day of week feature (-s1..7) added
*  v0.19   19931117 \
*   ...              | Internal versions
*  v0.01   19910923 /
*
*
*
*  Usage: cal [<switch>option(s)] [command]
*
*  <switch> =
*
*    + or - or /
*
*  [option] =
*
*    ? or h or H --> Display help screen
*
*    l or L      --> Display software license
*
*    v or V      --> Display software version and compilation options
*
*    r or R<>    --> Amount of month rows <1|2|3|4|6|12>
*                      If this option is found, the program implies that
*                      a yearly calendar output is wanted !!
*
*    f or F[-]   --> f  = Print (internal)holiday list
*                           sorted in ascending order
*                    f- = Print (internal)holiday list
*                           sorted in descending order
*
*    j or J[]    --> Print julian dates (modifiers: b f[-] c[-])
*                    b    = Use both date notations at the
*                             same time (standard + julian dates)
*                    f[-] = Julian dates for (internal)holiday
*                             list ([-] = sort order is descending)
*                    c[-] = Julian dates for rc appointments
*                             (in case symbol USE_RC is defined,
*                             [-] = sort order is descending)
*                             If modifiers [f] or [c] are found, the
*                             related mode is activated implicit !!
*                             You may mix all modifiers like:
*                               -j -jb -jbf -jc-b -jf-c -jbfc -jf-bc- ...
*
*    s or S<>    --> Starting day of week <1..7|weekday name>
*                      -s7 or -ssu or -ssund or -ssunday
*                      thus all specifies the sunday (1=mo, 2=tu...7=su)
*
*    d or D      --> Disable highlighting current day/holiday/text
*                      If symbol  ANSISYS  is defined, this is done
*                      automatically in case output is redirected/piped
*
*  If symbol USE_RC is defined:
*
*    c or C[-]   --> c  = USE RESOURCE FILE
*                           and list dates related to current day
*                           sorted in ascending order
*                    c- = USE RESOURCE FILE
*                           and list dates related to current day
*                           sorted in descending order
*
*  If you want to operate with the following modifieres, the -c[-] option
*    MUST be leading (e.g., -c-t or -cw- ...) and only ONE other option
*    (except the enable switch [e]) is respected
*
*    e or E       --> Enable inclusion of (internal)holiday dates
*
*    t or T       --> List dates related to tomorrow, too
*
*    w|W[-]       --> w  = List dates between curent day of current week
*                            and last day of current week
*                     w- = List dates between starting day of current week
*                            and day before current day of current week
*
*    m|M[-]       --> m  = List dates between current day of current month
*                            and last day of current month
*                     m- = List dates between starting day of current month
*                            and day before current day of current month
*
*    y|Y[-]       --> y  = List dates between current day of current year
*                            and last day of current year
*                     y- = List dates between starting day of current year
*                            and day before current day of current year
*
*  [command]  =
*
*    cal                      --> Current month of current year
*
*    cal  monthname           --> Selected month of current year
*                                   e.g.,  "cal may"
*
*    cal  mm-mm               --> Range of current months'
*                                   e.g.,  "cal 3-7     or   cal 11-8"
*                                          "cal mar-dec or   cal 12-aug"
*
*    cal  mm/yyyy-mm/yyyy     --> Range of months' of year
*                                   e.g.,  "cal 3/1991-july/1992"
*                                          "cal dec/1994-3"
*                                          "cal sep-dec/2000"
*
*    cal  mm,...,mm           --> List of current months' (maximum 12)
*                                   e.g.,  "cal 1,5,12  or   cal 3,1,5,3"
*                                          "cal june,9,jan"
*
*    cal  mm/yyyy,...,mm/yyyy --> List of months' of year (maximum 12)
*                                   e.g.,  "cal 1/1992,5,12/2001"
*                                          "cal june/1991,9/1801,jan"
*
*    cal  mm-mm yyyy          --> Range of specified months' of selected year
*
*    cal  mm,...,mm yyyy      --> List of specified months' of selected year
*                                 (maximum 12)
*
*    cal  mm yyyy             --> Single month of selected year
*
*    cal  yyyy                --> Selected year
*
*    cal  yyyy+yyyy           --> Range of specified year's
*
*    cal  yyyy;...;yyyy       --> List of specified year's (maximum 12)
*
*
*  NOTE: `mm' is either a number or a monthname.
*        The range of `mm' is valid from `1' to `12' or valid from
*        `january'...`december' (you may abbreviate the monthnames in case
*        you do it significant). You may mix both notations.
*
*        `yyyy' is a number.
*        The range of `yyyy' is valid from `1' to `9999'
*
*
*
*  You may create a `cal' resource file for showing special month dates !
*  The use/management of the resource file is done by `cal' ONLY, if you
*  define the preprocessor symbol  USE_RC  !!!
*
*  Every time you execute `cal' in single month mode
*    (referencing the current month of current year)
*
*    e.g.:   todays date is: may 27th 1994
*
*            cal -c
*            cal -c may
*            cal -c 5 1994
*
*  it checks the resource file for dates and processes those that refer to
*  the current date (previous examples: output in ascending order)
*
*  Some more examples for the date mentioned above:
*
*            cal -ce
*            cal -cw-
*            cal -c-m may
*            cal -c-y- 5 1994
*            cal -jbc -c-et
*            cal -cey- 1994
*            cal -jc- -cey may 1994
*
*
*  You can list dates of past/present/future year's, too
*
*    e.g.:   cal -c 1993        --> List all date entries related to entire 1993
*                                   and all eternal date entries related to
*                                   entire 1993 in ascending order
*            cal -c- july 1993  --> List all date entries related to july 1993
*                                   and all eternal date entries related to
*                                   july 1993 in descending order
*            cal -ce july 1993  --> List all date entries related to july 1993
*                                   and all eternal date entries related to
*                                   july 1993 and all (internal)holiday entries
*                                   related to july 1993 in ascending order
*            cal -c-e 1993      --> List all date entries related to entire 1993
*                                   and all eternal date entries related to
*                                   entire 1993 and all (internal)holiday entries
*                                   related to entire 1993 in decending order
*
*
*  The name of the resource file MUST be:
*    --  UN*X-systems:  .calrc
*    --  otherwise:     calrc
*
*  The `cal' program expects the resource file in the actual directory
*  If it's not found, `cal' inspects:
*    --  UN*X-systems:  the $HOME directory
*    --  otherwise:     the PATH-environment variable
*  and scans the referenced directory(s) for the resource file
*
*
*  The structure of the resource file is:
*
*    yyyymmdd `text'
*
*  where:  yyyy   is the year including the century (range 0000..9999)
*            mm   is the month (range 00..12)
*            dd   is the day (range 00..31) or a weekday-name (range mo..su)
*         `text'  is any text you like
*
*  e.g., 19940715 dentist
*        00000921 my %b1962 birthday
*        00000903 gregorian reformation~is %y1752 year ago
*        00000000every day in every month in every year
*        199400fr       every friday in 1994
*        000007mo every monday~in july every year
*
*  NOTE: Between yyyymmdd and `text' may occur whitespace
*          characters (tab, blank...)
*
*  If yyyy is specified as 0000:
*    The month and day are assumed to be annual events
*      and the `text' will be displayed for any year.
*  If mm is specified as 00:
*    The day is assumed to be a monthly event for the specified year
*      and the `text' will be displayed for any month.
*  If dd is specified as 00:
*    Each day is assumed to be a dayly event for the specified year and month
*      and the `text' will be displayed for any day.
*  If dd is specified as a (short %2s)weekday-name:
*    The given weekday-name is assumed to be a weekly event for the
*     specified year and month and the `text' will be displayed for any week.
*
*  The `text' of a resource file line may contain two special macros:
*    1) %byyyy references a year of birth and is converted to an age value
*         e.g., the line `my %b1962 birthday' will be expanded
*                     to `my 32nd birthday' in case the current year is 1994.
*         The year of birth entries are evaluated/respeced only if the
*         age value is >0.
*    2) %yyyyy references any year and is converted to an age value
*         e.g., the line `sylvester 1912 is %y1912 year's ago' will be expanded
*                     to `sylvester 1912 is -82 year's ago' in case the
*         current year is 1994.
*
*  Furthermore, you can split long resource file lines:
*    Each time a `~' (TILDE) character is found, this character
*    is replaced by a '\n' NEWLINE character.
*
*  A line beginning with a `;' (SEMICOLON) character in the resource file is
*    treated as a remark and will not be used by `cal'.
*
*
*  yyyymmdd  Accepted command line arguments
*  -----------------------------------------
*  00000000  c, ct
*  000000dd  c, ct, cw, cm
*  0000mm00  c, ct
*  0000mmdd  c, ct, cw, cm, cy
*  yyyy0000  c, ct
*  yyyy00dd  c, ct, cw, cm
*  yyyymm00  c, ct
*  yyyymmdd  c, ct, cw, cm, cy
*  000000wn  c, ct, cw          ---
*  0000mmwn  c, ct, cw             \  `wn' is a short weekday-name
*  yyyy00wn  c, ct, cw             /    (two places, e.g., mo, tu, we ...)
*  yyyymmwn  c, ct, cw          ---
*
*
*
*
*  `cal' produces the following exit codes:
*
*    255 = Request for help screen/software license/program version
*    254 = Invalid option
*    253 = Year out of range for computing easter
*    252 = malloc() fails
*    251 = Invalid date entry in resource file
*    250 = Invalid month entry in resource file
*    249 = Invalid day entry in resource file
*      0 = Normal program termination
*/
#
#
#
#
#
/*
*
*  BEGIN: General program modification symbols,
*           which may be changed by the user !!
*
*/
#
/*
*  To adapt this program (-D`efinitions' in Makefile):
*
*  a)  - Define GERMAN for using german messages
*      - Delete the symbol GERMAN for using english messages
*
*  b)  - Define EXT_ASCII            to use the extended IBM-ASCII character set
*      - Delete the symbol EXT_ASCII to use the          ISO-ASCII/EBCDIC character set
*
*  c)  - Define ANSISYS to run this program using the [n]ansi.sys driver
*          (ibm-pc ms/pc-dos/linux) for highlighting the current day/holidays/text
*      - Delete the symbol ANSISYS to run this program not using the
*          [n]ansi.sys driver (recent Un*ces) for highlighting the current day
*      ... resp., replace the ANSI control sequence for highlighting the
*          current day according to your terminal type
*            (take a look into your local termcap/terminfo file)
*
*  d)  - Define USE_RC for using the special month dates functions
*          (print daily/weekly/monthly/yearly/eternal/special appointments
*           as stated in the resource file)
*      - Delete the symbol USE_RC if you don't like this feature...
*
*  e)  - Define US_HDAY for showing the specific u.s. holidays in (internal)
*          holiday list, too (active only in case symbol GERMAN is undefined !)
*      - Delete the symbol US_HDAY if you don't need them...
*/
#define  GERMAN
#define  EXT_ASCII
#define  ANSISYS
#define  USE_RC
#define  US_HDAY
#
/*
*
*  END: General program modification symbols,
*         which may be changed by the user !!
*
*/
#
/*
*  No further modifications, please !!!
*/
#
#
#
#
#
/*
*  Compiler dependent pragmas
*/
#ifdef __TURBOC__
#  pragma warn -pia
#  pragma warn -def
#endif
#
#
#
/*
*  Define the symbol MSDOS for MS-DOS machines
*/
#if defined(__MSDOS__) || defined(__MSDOS) || defined(_MSDOS) || defined(MSDOS)
#  ifndef MSDOS
#    define MSDOS     /* Now let's define the symbol MSDOS generally */
#  endif
#endif
#if defined(__TURBOC__) || defined(__ZTC__) || defined(M_I86xM)
#  ifndef MSDOS
#    define MSDOS     /* Now let's define the symbol MSDOS generally */
#  endif
#endif
/*
*  Define the symbol LINUX for Linux machines
*/
#if defined(__LINUX__) || defined(__LINUX) || defined(_LINUX) || defined(LINUX)
#  ifndef LINUX
#    define LINUX     /* Now let's define the symbol LINUX generally */
#  endif
#endif
#if defined(__linux__) || defined(__linux) || defined(_linux) || defined(linux)
#  ifndef LINUX
#    define LINUX     /* Now let's define the symbol LINUX generally */
#  endif
#endif
/*
*  Define the symbol UNIX for UN*X machines
*/
#if defined(__UNIX__) || defined(__UNIX) || defined(_UNIX) || defined(UNIX)
#  ifndef UNIX
#    define UNIX      /* Now let's define the symbol UNIX generally */
#  endif
#endif
#if defined(__unix__) || defined(__unix) || defined(_unix) || defined(unix)
#  ifndef UNIX
#    define UNIX      /* Now let's define the symbol UNIX generally */
#  endif
#endif
#if defined (___AIX) || defined(__AIX) || defined(_AIX) || defined(AIX)
#  ifndef UNIX
#    define UNIX      /* Now let's define the symbol UNIX for these machines, too */
#  endif
#endif
#if defined(___aix) || defined(__aix) || defined(_aix) || defined(aix) || defined(LINUX)
#  ifndef UNIX
#    define UNIX      /* now let's define the symbol UNIX for these machines, too */
#  endif
#endif
#
#
#
/*
*  Include header files
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
/*
*  Necessary for isatty()
*/
#if defined(MSDOS) || defined(ATARI)
#  include <io.h>
#else /* !MSDOS || !ATARI */
#  if defined(LINUX)
#    include <unistd.h>
#  else /* !LINUX == UNIX   ;) */
#    include <unistd.h>        /* Change line in case isatty() is anywhere */
#  endif /* !LINUX */
#endif /* !MSDOS || !ATARI  */
#
#
#
/*
*  Define the representation of the german `umlaute'
*/
#ifdef EXT_ASCII
#  define  AE          "\x84"
#  define  OE          "\x94"
#  define  UE          "\x81"
#  define  SZ          "\xE1"
#else /* !EXT_ASCII */
#  define  AE          "\"a"
#  define  OE          "\"o"
#  define  UE          "\"u"
#  define  SZ          "\"s"
#endif /* !EXT_ASCII */
#
#
#
/*
*  Define the highlighting sequences
*/
#ifdef ANSISYS
#  define  R_MARKER    "\x1b[0m"
#  define  R_HMARKER   R_MARKER
#  if defined(MSDOS) || defined(LINUX) || defined(ATARI)
#    define  L_MARKER    " \x1b[1m"
#    define  L_HM        "\x1b[36m"
#    define  L_HMARKER   " "L_HM
#  else /* !MSDOS || !LINUX || !ATARI */
#    define  L_MARKER    " \x1b[7m"
#    define  L_HM        "\x1b[1m"
#    define  L_HMARKER   " "L_HM
#  endif /* !MSDOS || !LINUX || !ATARI */
#else /* !ANSISYS */
#  ifdef EXT_ASCII
#    define  L_MARKER    "\x11"
#    define  R_MARKER    "\x10"
#    define  L_HMARKER   "\xae"
#    define  R_HMARKER   "\xaf"
#  else /* !EXT_ASCII */
#    define  L_MARKER    "<"
#    define  R_MARKER    ">"
#    define  L_HMARKER   ":"
#    define  R_HMARKER   ":"
#  endif /* !EXT_ASCII */
#endif /* !ANSISYS */
#
#
#
/*
*  Basic preprocessor statements
*/
#ifndef TRUE
#  define  TRUE         (0==0)
#endif
#ifndef FALSE
#  define  FALSE        (!TRUE)
#endif
#ifndef BUFSIZ
#  define  BUFSIZ       1024
#endif
#define  LOOP           for(;;)
#
#
#
/*
*  Special preprocessor statements
*/
#define  PRGR_NAME     "cal"
#define  VERSION_NO    "v0.31"
#define  HD_ELEMS_MAX  40         /* Maximum amount of (interal)holidays */
#define  LEN_HD_NAME   26         /* Maximum length of a holiday name - `\0' */
#ifdef UNIX
#  define  DIR_SEP       "/"      /* Directory/folder separator */
#else /* !UNIX */
#  define  DIR_SEP       "\\"     /* Directory/folder separator */
#endif /* !UNIX */
#ifdef USE_RC
#  define  RC_ELEMS_MAX  750      /* Maximum amount of rc-file appointments */
#  define  RC_REM_CHAR   ';'      /* Comment char of a rc-file line */
#  define  RC_FOR_CHAR   '%'      /* Activates %b / %y-mode if found in rc-file */
#  define  RC_NL_CHAR    '~'      /* Splits long rc-file lines if found */
#  ifdef UNIX
#    define  HOME_PATH     "HOME"
#    define  PATH_SEP      ":"
#    define  PRGR_RC_NAME  "."PRGR_NAME"rc"   /* Name of resource file */
#  else /* !UNIX */
#    define  HOME_PATH     "PATH"
#    define  PATH_SEP      ";"
#    define  PRGR_RC_NAME  PRGR_NAME"rc"      /* Name of resource file */
#  endif /* !UNIX */
#endif /* USE_RC */
#define  MLIST_SEP     ","        /* separator char of a month list (mm,mm) */
#define  MRANGE_SEP    "-"        /* separator char of a month range (mm-mm) */
#define  YLIST_SEP     ";"        /* separator char of a year list (yyyy;yyyy) */
#define  YRANGE_SEP    "+"        /* separator char of a year range (yyyy+yyyy) */
#define  YEAR_SEP      "/"        /* separator char between month and year (mm/yyyy) */
#define  S_OUT_ROWS    3          /* Number of default rows standard date */
#define  S_OUT_COLS    4          /* Number of default columns standard date */
#define  J_OUT_ROWS    4          /* Number of default rows julian date */
#define  J_OUT_COLS    3          /* Number of default columns julian date */
#define  B_OUT_ROWS    12         /* Number of default rows both dates */
#define  B_OUT_COLS    1          /* Number of default columns both dates */
#define  CENTURY       1900       /* Actual century, DON'T change ! */
#ifdef GERMAN
#  define  USAGE       "Aufruf: "
#  define  YEAR_LIT1   "jj"
#  define  YEAR_LIT2   YEAR_LIT1""YEAR_LIT1
#  define  GREG_YEAR   1582       /* Year of gregorian reformation in most parts of germany */
#  define  GREG_MONTH  10         /* Month of ... */
#  define  GREG_F_DAY  5          /* First missing day/date in oct 1582 */
#  define  GREG_L_DAY  14         /* Last missing day/date ... */
#else /* !GERMAN */
#  define  USAGE       "Usage:  "
#  define  YEAR_LIT1   "yy"
#  define  YEAR_LIT2   YEAR_LIT1""YEAR_LIT1
#  define  GREG_YEAR   1752       /* Year of gregorian reformation in most parts of uk/usa */
#  define  GREG_MONTH  9          /* Month of ... */
#  define  GREG_F_DAY  3          /* First missing day/date in sep 1752 */
#  define  GREG_L_DAY  13         /* Last missing day/date ... */
#endif /* !GERMAN */
#define  DAY_MIN     1            /* Minimum day of week */
#define  DAY_MAX     7            /* Maximum day of week */
#define  MONTH_MIN   1            /* Minimum month of year */
#define  MONTH_MAX   12           /* Maximum month of year */
#define  YEAR_MIN    1            /* Minimum year able to compute */
#define  YEAR_MAX    9999         /* Maximum year able to compute */
#define  EASTER_MIN  GREG_YEAR+1  /* Minimum year for computing eastern */
#define  EASTER_MAX  YEAR_MAX     /* Maximum year for computing eastern */
#define  MONTH_ROWS  7            /* Maximum amount of rows of a month */
#define  MONTH_COLS  6            /* Maximum amount of columns of a month */
/*
*  VEC_BLOCK = MONTH_ROWS * MONTH_COLS :   42 = 7 * 6
*/
#define  VEC_BLOCK   42
/*
*  VEC_ELEMS = MONTH_MAX * VEC_BLOCK :    504 = 12 * 42
*/
#define  VEC_ELEMS   504
#
#
#
/*
*  Preprocessor macros
*/
#define  S_NEWLINE(dev)  fputc('\n', (dev))
#define  D_NEWLINE(dev)  fputs("\n\n", (dev))
#define  SYEAR(_d, _s)   (((_d)-(_s)+1) < DAY_MIN) \
                         ? ((_d)-(_s)+(DAY_MAX+1)) \
                         : ((_d)-(_s)+1)
#define  SDAY(_d, _s)    (((_d)+(_s)-1) > DAY_MAX) \
                         ? ((_d)+(_s)-(DAY_MAX+1)) \
                         : ((_d)+(_s)-1)
#
#
#
/*
*  Cut resp., replace some long names to 6 significant places
*    so ANY linker should be able to bind an executable file
*/
#define compare_dayname         F_cd
#define compare_monthname       F_cm
#ifndef USE_RC
#  define days_of_feb             V_dof
#endif
#define days_of_february        F_dof
#define days_of_month           V_dom
#define holiday_flag            V_hf
#define holiday_name            V_hn
#define holiday_prefix          V_hp
#define holiday_vector          V_hv
#define julian_days             V_jd
#define julian_flag             V_jf
#define julian_vector           V_jv
#define month_list              V_ml
#define month_name              F_mn
#define month_set               V_ms
#define print_all_holidays      F_pah
#define print_calendar          F_pc
#define print_highlighted_date  F_phd
#ifdef USE_RC
#  define print_line              V_pl
#endif
#define print_single_date       F_psd
#define print_single_holiday    F_psh
#ifdef USE_RC
#  define print_two_times         V_ptt
#  define rc_use                  F_ru
#  define rc_use_flag             V_ruf
#endif
#define short_day_name          F_sdn
#define short_month_name        F_smn
#
#
#
/*
*  Type definitions
*/
typedef
  char
  Schar;
typedef
  int
  Sint;
typedef
  signed long int
  Slint;
typedef
  unsigned long int
  Ulint;
typedef
  Schar
  Bool;
typedef
  Sint
  (*Func_cmp)(const void *, const void *);
#
#
#
/*
*  Function prototypes
*/
#if __cplusplus
extern "C"
{
#endif
static Sint
my_atoi (const Schar *s);
static void
get_actual_date (void);
static void
check_command_line (      Sint   argc,
                    const Schar *argv[]);
static void
eliminate_invalid_data (void);
static void
fill_year_vector (const Sint year);
static void
print_calendar (void);
static Bool
print_single_date (Bool marker_flag);
static Bool
print_highlighted_date (      Bool   marker_flag,
                        const Schar *l_marker,
                        const Schar *r_marker);
static Sint
eval_holiday (      Sint day,
              const Sint month,
              const Sint year,
              const Sint wd,
              const Bool backwards);
static void
print_single_holiday (      Bool   init_data,
                      const Bool   detect,
                      const Schar *holiday_name,
                      const Schar *holiday_prefix,
                            Sint   day,
                            Sint   month,
                      const Sint   year,
                            Sint  *hd_elems);
static void
print_all_holidays (      Bool init_data,
                    const Bool detect);
static Sint
compare_monthname (const Schar *s);
static Sint
compare_dayname (const Schar *s);
static void
build_month_list (const Schar *argv[]);
static Sint
asc_sort (const Schar **a,
          const Schar **b);
static Sint
des_sort (const Schar **a,
          const Schar **b);
#ifdef USE_RC
static Schar
*rc_get_date (Schar *ptr_char,
              Schar *s,
              Sint  *d,
              Sint  *m,
              Sint  *y);
static Bool
rc_read_line (FILE  *fp,
              Schar *tmp_buffer,
              Sint  *line);
static void
rc_check (      Schar *tmp_buffer,
                Schar *s,
                Sint  *line,
                Sint  *rc_elems,
                Sint   day,
                Sint   ed,
          const Sint   wd);
static void
rc_use (void);
#endif
#ifndef GERMAN
static const Schar
*day_suffix (Sint day);
#endif
static const Schar
*short_day_name (const Sint day);
static const Schar
*day_name (const Sint day);
static const Schar
*short_month_name (const Sint month);
static const Schar
*month_name (const Sint month);
#ifdef USE_RC
static void
prev_date (Sint *day,
           Sint *month,
           Sint *year);
static void
next_date (Sint *day,
           Sint *month,
           Sint *year);
static Bool
valid_date (const Sint day,
            const Sint month,
            const Sint year);
#endif
static Sint
weekday_of_date (const Sint day,
                 const Sint month,
                 const Sint year);
static Sint
day_of_year (const Sint day,
             const Sint month,
             const Sint year);
static Sint
days_of_february (const Sint year);
static Sint
gauss_easter_formula (const Sint year);
#if __cplusplus
}
#endif
#
#
#
/*
*  Global variables
*/
struct
 {
   Sint month[MONTH_MAX+1];
   Sint year[MONTH_MAX+1];
 }      month_list;
#ifdef GERMAN
Sint    start_day=DAY_MIN;        /* -s<1..7|day name> */
#else /* !GERMAN */
Sint    start_day=DAY_MAX;        /* -s<1..7|day name> */
#endif /* !GERMAN */
Sint    day;
Sint    month;
Sint    year;
Sint    act_day;
Sint    act_month;
Sint    act_year;
Sint    out_rows;
Sint    out_cols;
Sint    is_tty;
Sint    is_leap_year;
Sint    holiday_vector[MONTH_MAX][MONTH_MAX];
Sint    year_vector[VEC_ELEMS];   /* standard-/julian year dates */
Sint    julian_vector[VEC_ELEMS]; /* julian year dates */
#ifdef USE_RC
Schar  *rc_buffer[RC_ELEMS_MAX];  /* stores the valid appointment text's */
#endif
Schar   tmp_name[BUFSIZ+1];       /* buffer */
Schar   s[BUFSIZ+1];              /* buffer */
Schar  *hd_buffer[HD_ELEMS_MAX];  /* stores the (internal)holiday list */
#ifdef USE_RC
Bool    rc_use_flag=FALSE;        /* -c */
Bool    rc_enable_hd_flag=FALSE;  /* [-c]e */
Bool    rc_sort_des_flag=FALSE;   /* [-c]- */
Bool    rc_julian_flag=FALSE;     /* [-j]c */
Bool    rc_tomorrow_flag=FALSE;   /* [-c]t */
Bool    rc_week_flag=FALSE;       /* [-c]w */
Bool    rc_month_flag=FALSE;      /* [-c]m */
Bool    rc_year_flag=FALSE;       /* [-c]y */
Bool    rc_backwards_flag=FALSE;  /* [-c<t|w|m|y>]- */
#endif
Bool    julian_flag=FALSE;        /* -j */
Bool    both_dates_flag=FALSE;    /* [-j]b */
Bool    holiday_flag=FALSE;       /* -f */
Bool    hd_sort_des_flag=FALSE;   /* [-f]- */
Bool    hd_julian_flag=FALSE;     /* [-j]f */
Bool    highlight_flag=TRUE;      /* -d */
Bool    license_flag=FALSE;       /* -l */
Bool    version_flag=FALSE;       /* -v */
Bool    help_flag=FALSE;          /* -? | -h */
Bool    year_flag=FALSE;          /* -r<1|2|3|4|6|12> */
Bool    ext_year=FALSE;
Bool    ext_list=FALSE;
Bool    ext_range=FALSE;
#
#
#
/*
*  Mainfunction implementation
*/
Sint
main(      Sint   argc,
     const Schar *argv[])
/*
   Perform the program :)
*/
{
   setbuf(stdout, NULL);
   is_tty = isatty(1);
   get_actual_date ();
   check_command_line (argc, argv);
   eliminate_invalid_data ();
   if (   !ext_list
       && !ext_range)
    {
      is_leap_year = (days_of_february (year) == 29);
      fill_year_vector (year);
      /*
         Get the actual dates of holidays, used for highlighting the calendar
      */
      if (   (year >= EASTER_MIN)
          && (year <= EASTER_MAX))
        print_all_holidays (FALSE, TRUE);
    }
   print_calendar ();
   if (!month_list.month[1])
    {
#ifdef USE_RC
      /*
         If not omitted, read resource file from:      actual path
         If not found, search environment variable:    %PATH (MS/PC-DOS)
                                            resp.,:    $HOME (UN*X)
      */
      if (rc_use_flag)
        rc_use ();
#endif
      if (holiday_flag)
       {
         if (   year < EASTER_MIN
             || year > EASTER_MAX)
          {
#ifdef GERMAN
            fputs("Unzul"AE"ssiges Jahr f"UE"r Ostertagsberechnung !\n", stderr);
            fprintf(stderr, "Jahr mu"SZ" im Bereich (%d..%d) sein\n",
                    EASTER_MIN, EASTER_MAX);
#else /* !GERMAN */
            fputs("Invalid year for computing easter !\n", stderr);
            fprintf(stderr, "Year must be in range (%d..%d)\n",
                    EASTER_MIN, EASTER_MAX);
#endif /* !GERMAN */
            exit(253);
          }
         print_all_holidays (FALSE, FALSE);
       }
    }

   return(0);
}
#
#
#
/*
*  Subfunction implementation
*/
static Sint
my_atoi (const Schar *s)
/*
   Converts string `s' to a numerical value
     and returns values in range 0..9999 only (invalid values are set to 0)
*/
{
   if (   *s == '-'
       || strlen(s) > 4)
     return(0);

   return(atoi(s));
}
#
#
#
static void
get_actual_date (void)
/*
   Gets the current date from the system
*/
{
   auto struct tm      *sys_date;
   auto        time_t   sys_time;


   sys_time = time(NULL);
   sys_date = localtime(&sys_time);
   act_day = sys_date->tm_mday;
   act_month = sys_date->tm_mon + 1;
   act_year = sys_date->tm_year;
   if (act_year < CENTURY)
     act_year += CENTURY;
}
#
#
#
static void
check_command_line (      Sint   argc,
                    const Schar *argv[])
/*
   Gets the arguments from the command line
*/
{
#ifdef USE_RC
   static const Schar  *usage_msg={USAGE""PRGR_NAME" [<+|-|/>{[?|h|l|v] | "
                                   "{r<n>|f[-]|j[]|s<n>|d|c[]}}]  "
                                   "[[mm] <"YEAR_LIT2">]"};
#else /* !USE_RC */
   static const Schar  *usage_msg={USAGE""PRGR_NAME" [<+|-|/>{[?|h|l|v] | "
                                   "{r<n>|f[-]|j[]|s<n>|d}}]  "
                                   "[[mm] <"YEAR_LIT2">]"};
#endif /* USE_RC */
   auto   const Schar  *option;


   strcpy(s, argv[0]);
   while (argc > 1)
    {
      option = *++argv;
      if (   *option == '+'
          || *option == '-'
          || *option == '/')
       {
         /*
            Check the command line for options
         */
         for (option++ ; *option ; option++)
          {
            switch (*option)
             {
               case '?':
               case 'h':
               case 'H':
                 help_flag = TRUE;
                 break;
               case 'l':
               case 'L':
                 license_flag = TRUE;
                 break;
               case 'v':
               case 'V':
                 version_flag = TRUE;
                 break;
               case 'f':
               case 'F':
                 holiday_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    hd_sort_des_flag = (Bool)(*option == '-');
                    while (*option)
                      option++;
                  }
                 option--;
                 break;
               case 'j':
               case 'J':
                 if (!both_dates_flag)
                   julian_flag = TRUE;
                 option++;
                 while (*option)
                  {
                    if (toupper(*option) == 'B')
                     {
                       both_dates_flag = TRUE;
                       julian_flag = FALSE;
                     }
                    else
                      if (toupper(*option) == 'F')
                       {
                         holiday_flag=hd_julian_flag = TRUE;
                         while (*(++option) == '-')
                           hd_sort_des_flag = TRUE;
                         option--;
                       }
#ifdef USE_RC
                      else
                        if (toupper(*option) == 'C')
                         {
                           rc_use_flag=rc_julian_flag = TRUE;
                           while (*(++option) == '-')
                             rc_sort_des_flag = TRUE;
                           option--;
                         }
#endif
                   option++;
                  }
                 option--;
                 break;
               case 'r':
               case 'R':
                 year_flag = TRUE;
                 option++;
                 out_rows = my_atoi (option);
                 if (   !*option
                     || out_rows > MONTH_MAX
                     || out_rows < MONTH_MIN
                     || out_rows == 5
                     || (   out_rows > 6
                         && out_rows < MONTH_MAX))
                   option--;
                 else
                   if (   out_rows < 1
                       || out_rows > 9)
                     {
                       while (*option)
                         option++;
                       option--;
                     }
                 break;
               case 's':
               case 'S' :
                 option++;
                 if (*option)
                  {
                    register Sint  i=0;


                    while (   *option
                           && (i < BUFSIZ))
                      tmp_name[i++] = *(option++);
                    tmp_name[i] = '\0';
                    start_day = my_atoi (tmp_name);
                  }
                 else
                   start_day = 0;
                 if (   !*option
                     || start_day > DAY_MAX
                     || start_day < DAY_MIN)
                   option--;
                 else
                   if (   start_day < 1
                       || start_day > 9)
                    {
                      while (*option)
                        option++;
                      option--;
                    }
                 break;
               case 'd':
               case 'D':
                 highlight_flag = FALSE;
                 break;
#ifdef USE_RC
               case 'c':
               case 'C':
                 rc_use_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    if (!rc_sort_des_flag)
                      rc_sort_des_flag = (Bool)(*option == '-');
                    while (*option == '-')
                      option++;
                  }
                 option--;
                 break;
               case 'e':
               case 'E':
                 rc_enable_hd_flag = TRUE;
                 break;
               case 't':
               case 'T':
                 rc_tomorrow_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    if (!rc_sort_des_flag)
                      rc_sort_des_flag = (Bool)(*option == '-');
                    while (*option == '-')
                      option++;
                  }
                 option--;
                 break;
               case 'w':
               case 'W':
                 if (   !rc_month_flag
                     && !rc_year_flag)
                   rc_week_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    if (!rc_backwards_flag)
                      rc_backwards_flag = (Bool)(*option == '-');
                    while (*option)
                      option++;
                  }
                 option--;
                 break;
               case 'm':
               case 'M':
                 if (   !rc_week_flag
                     && !rc_year_flag)
                   rc_month_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    if (!rc_backwards_flag)
                      rc_backwards_flag = (Bool)(*option == '-');
                    while (*option)
                      option++;
                  }
                 option--;
                 break;
               case 'y':
               case 'Y':
                 if (   !rc_week_flag
                     && !rc_month_flag)
                   rc_year_flag = TRUE;
                 option++;
                 if (*option)
                  {
                    if (!rc_backwards_flag)
                      rc_backwards_flag = (Bool)(*option == '-');
                    while (*option)
                      option++;
                  }
                 option--;
                 break;
#endif
               default:
                 s[strlen(s) - strlen(strrchr(s, *DIR_SEP)+1)] = '\0';
#ifdef GERMAN
                 fprintf(stderr, "%s%s: Unbekannte Option -- %s\n%s\n",
                         s, PRGR_NAME, *argv+1, usage_msg);
#else /* !GERMAN */
                 fprintf(stderr, "%s%s: Unknown option -- %s\n%s\n",
                         s, PRGR_NAME, *argv+1, usage_msg);
#endif /* !GERMAN */
                 exit(254);
             }
          }
         argc--;
       }
      else
        break;
    }
   if (help_flag)
    {
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(L_HM, stdout);
#endif
      fputs(PRGR_NAME, stdout);
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(R_HMARKER, stdout);
#endif
#ifdef GERMAN
      fputs(":    Erweitertes UN*X `calendar' Programm  (", stdout);
#else /* !GERMAN */
      fputs(":    Extended UN*X `calendar' program  (", stdout);
#endif /* !GERMAN */
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(L_HM, stdout);
#endif
      fputs(VERSION_NO, stdout);
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(R_HMARKER, stdout);
#endif
      fputs(")\n", stdout);
      fprintf(stdout, "\n%s\n\n", usage_msg);
#ifdef GERMAN
      fprintf(stdout,
              "-? -h = Dieser Hilfetext ; -l = Softwarelizenz ; -v = Versionsnummer\n"
              "-r<n> = Ausgabe des Jahreskalenders in <1|2|3|4|6|12> Monatsbl"OE"cken\n"
              "-f[-] = Ausgabe der Feiertagsliste (Jahr im Bereich %d...%d)\n"
              "-j[]  = Ausgabe als julianisches Datum (Modifizierer: "
#  ifdef USE_RC
              "[b [f[-] [c[-]]]])\n"
#  else /* !USE_RC */
              "[b [f[-]]])\n"
#  endif /* !USE_RC */
              "-s<n> = Starttag der Woche (Bereich: %d=%s, %d=%s...%d=%s | Wochentagsname)\n"
              "-d    = Heutigen Tag/Feiertag%s ohne Hervorhebung ausgeben\n"
#  ifdef USE_RC
              "-c[-] = Inhalt der Ressourcendatei `%s' ber"UE"cksichtigen\n"
              "        >>> Weitere Modifizierer: [e] [<t|w[-]|m[-]|y[-]>]\n"
#  endif
              "mm    = Monat im Bereich (%d...%d)"
              "        Liste:   mm["YEAR_SEP""YEAR_LIT2"]"MLIST_SEP"..."
              MLIST_SEP"mm["YEAR_SEP""YEAR_LIT2"]\n                    oder (Monatsname)"
              "    Bereich: mm["YEAR_SEP""YEAR_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""YEAR_LIT2"]\n"
              YEAR_LIT2"  = Jahr  im Bereich (%d...%d)"
              "      Liste:   "YEAR_LIT2""YLIST_SEP"..."YLIST_SEP""YEAR_LIT2"\n"
              "                                   "
              "      Bereich: "YEAR_LIT2""YRANGE_SEP""YEAR_LIT2"\n"
              "    +++ Bei zweistelliger Jahresangabe wird NICHT"
              " von %2d"YEAR_LIT1" ausgegangen +++\n\n",
              EASTER_MIN, EASTER_MAX,
              DAY_MIN, short_day_name (DAY_MIN),
              DAY_MIN+1, short_day_name (DAY_MIN+1),
              DAY_MAX, short_day_name (DAY_MAX),
#  ifdef EXT_ASCII
              "/Text",
#  else /* !EXT_ASCII */
              "",
#  endif /* !EXT_ASCII */
#  ifdef USE_RC
              PRGR_RC_NAME,
#  endif
              MONTH_MIN, MONTH_MAX,
              YEAR_MIN, YEAR_MAX,
              act_year/100);
#else /* !GERMAN */
      fprintf(stdout,
              "-? -h = This help screen ; -l = Software license ; -v = Version number\n"
              "-r<n> = Output of year calendar divided into <1|2|3|4|6|12> month block(s)\n"
              "-f[-] = Output of holiday list (year must be in range %d...%d)\n"
              "-j[]  = Output of julian dates (Modifiers: "
#  ifdef USE_RC
              "[b [f[-] [c[-]]]])\n"
#  else /* !USE_RC */
              "[b [f[-]]])\n"
#  endif /* !USE_RC */
              "-s<n> = Starting day of week (Range: %d=%s, %d=%s...%d=%s | weekday name)\n"
              "-d    = Disable highlighting of current day/holiday%s\n"
#  ifdef USE_RC
              "-c[-] = List/respect contents of resource file `%s'\n"
              "        >>> Further modifiers: [e] [<t|w[-]|m[-]|y[-]>]\n"
#  endif
              "mm    = Month in range (%d...%d)"
              "        List:  mm["YEAR_SEP""YEAR_LIT2"]"MLIST_SEP"..."
              MLIST_SEP"mm["YEAR_SEP""YEAR_LIT2"]\n                    or (month name)"
              "    Range: mm["YEAR_SEP""YEAR_LIT2"]"MRANGE_SEP"mm["YEAR_SEP""YEAR_LIT2"]\n"
              YEAR_LIT2"  = Year  in range (%d...%d)"
              "      List:  "YEAR_LIT2""YLIST_SEP"..."YLIST_SEP""YEAR_LIT2"\n"
              "                                 "
              "      Range: "YEAR_LIT2""YRANGE_SEP""YEAR_LIT2"\n"
              "      +++ If you specify two digits for the year"
              " I DON'T assume %2d"YEAR_LIT1" +++\n\n",
              EASTER_MIN, EASTER_MAX,
              DAY_MIN, short_day_name (DAY_MIN),
              DAY_MIN+1, short_day_name (DAY_MIN+1),
              DAY_MAX, short_day_name (DAY_MAX),
#  ifdef EXT_ASCII
              "/text",
#  else /* !EXT_ASCII */
              "",
#  endif /* !EXT_ASCII */
#  ifdef USE_RC
              PRGR_RC_NAME,
#  endif
              MONTH_MIN, MONTH_MAX,
              YEAR_MIN, YEAR_MAX,
              act_year/100);
#endif /* !GERMAN */
#ifdef GERMAN
      fputs("`"PRGR_NAME"' ist `freie Software'         ", stdout);
#else /* !GERMAN */
      fputs("`"PRGR_NAME"' is `free software'           ", stdout);
#endif /* !GERMAN */
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(L_HM, stdout);
#endif
      fputs("\\\\\\_''/'", stdout);
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(R_HMARKER, stdout);
#endif
#ifdef GERMAN
#  ifdef EXT_ASCII
      fputc(' ', stdout);
#  endif
      fputs("              Viel Spa"SZ" damit  :)\n", stdout);
#else /* !GERMAN */
      fputs("                      Have fun  :)\n", stdout);
#endif /* !GERMAN */
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(L_HM, stdout);
#endif
      fprintf(stdout, "----------------------------oOO    (/o-o\\) "
                      "   OOo----------------------------\n"
                      "   Thomas Esken                o  (.  \"  .)"
                      "  o   Internet :                  \n"
                      "   Im Hagenfeld 84              \\___) ~ (__"
                      "_/      <esken@uni-muenster.de>   \n"
                      "   D-48147 M\"unster; GERMANY               "
                      "      Phone : (+49) 0251 232585   \n");
#ifdef ANSISYS
      if (   is_tty
          && highlight_flag)
        fputs(R_HMARKER, stdout);
#endif
      exit(255);
    }
   strncpy(s, rcsid+5, 30);
   if (license_flag)
    {
      fprintf(stdout, "%s\n   (C)opyright 1994 Thomas Esken\n", s);
#ifdef GERMAN
      fputs("   Diese Software erhebt keinen Anspruch auf Vollst"AE"ndigkeit,\n"
            "   Verwendungsf"AE"higkeit oder Korrektheit. F"UE"r jedwede Sch"AE"den oder\n"
            "   Verluste (implizit oder explizit), die aus Nutzung oder Handhabung\n"
            "   meiner Software hervorgehen, wird grunds"AE"tzlich keine Haftung\n"
            "   "UE"bernommen. Bei Verwendung dieser Software erkl"AE"rt sich der Benutzer\n"
            "   mit dieser Vereinbarung in vollem Umfang einverstanden.\n\n"
            "   Dieses Programm ist freie Software; Sie k"OE"nnen es weitervertreiben\n"
            "   und/oder ver"AE"ndern innerhalb der Bestimmungen der `GNU General Public\n"
            "   License'; herausgegeben von der `Free Software Foundation';\n"
            "   in der Version 2 oder jeder sp"AE"teren Version und folgender Bedingung:\n\n"
            "      Es ist strengstens untersagt, diese Software in ein kommerzielles\n"
            "      Softwarepaket zu integrieren/beizuf"UE"gen (z.B. Novell's Linux Projekt),\n"
            "      sofern nicht zuvor die Erlaubnis des Autors eingeholt wurde !!\n\n"
            "   Sie sollten eine Kopie der `GNU General Public License' zusammen mit\n"
            "   diesem Programm erhalten haben; falls nicht, schreiben Sie an die:\n",
            stdout);
#else /* !GERMAN */
      fputs("   This software doesn't claim completeness, correctitude or usability.\n"
            "   On principle I will not be liable for any damages or losses (implicit\n"
            "   or explicit), which result from using or handling my software.\n"
            "   If you use this software, you agree without any exception to this\n"
            "   agreement, which binds you LEGALLY !!\n\n"
            "   This program is free software; you can redistribute it and/or modify\n"
            "   it under the terms of the `GNU General Public License' as published by\n"
            "   the `Free Software Foundation'; either version 2, or (at your option)\n"
            "   any later version and the following condition:\n\n"
            "      If not permitted by the author, it's strictly forbidden to\n"
            "      include/bundle this software in a commerical software suite\n"
            "      (e.g., Novell's Linux project) !!\n\n"
            "   You should have received a copy of the `GNU General Public License'\n"
            "   along with this program; if not, write to the:\n",
            stdout);
#endif /* !GERMAN */
      fputs("   Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n",
            stdout);
      exit(255);
    }
   if (version_flag)
    {
      register Sint  i=0;


      fprintf(stdout, "%s\n", s);
#ifdef GERMAN
      fputs("   Kompilations-Optionen:\n    ", stdout);
      fputs(" GERMAN", stdout);
      i++;
#else /* !GERMAN */
      fputs("   Compilation options:\n    ", stdout);
#endif /* !GERMAN */
#ifdef EXT_ASCII
      fputs(" EXT_ASCII", stdout);
      i++;
#endif
#ifdef ANSISYS
      fputs(" ANSISYS", stdout);
      i++;
#endif
#ifdef USE_RC
      fputs(" USE_RC", stdout);
      i++;
#endif
#if !defined(GERMAN) && defined(US_HDAY)
      fputs(" US_HDAY", stdout);
      i++;
#endif
      if (!i)
        fputs(" (NONE)", stdout);
      S_NEWLINE(stdout);
      exit(255);
    }
   /*
      Check the command line for commands
   */
   if (argc > 1)
    {
      register Sint  i;
      auto     Bool  list=FALSE;
      auto     Bool  range=FALSE;
      auto     Bool  month_set=FALSE;


      for ( ; argc > 1 ; argc--, argv++)
       {
         if (!month)
          {
            option = *argv;
            i = 0;
            while (*option)
             {
               if (   *option == *MLIST_SEP
                   || *option == *YLIST_SEP)
                 list = TRUE;
               else
                 if (   *option == *MRANGE_SEP
                     || *option == *YRANGE_SEP)
                   range = TRUE;
               s[i++] = *(option++);
             }
            s[i] = '\0';
            if (   !list
                && !range
                && !my_atoi(s))
             {
               month = compare_monthname (s);
               if (month)
                {
                  month_set = TRUE;
                  continue;
                }
             }
          }
         if (!month)
          {
            build_month_list (argv);
            if (!*month_list.month)
              month = my_atoi (*argv);
            else
              month = *month_list.month;
            if (   month < MONTH_MIN
                || month > MONTH_MAX)
             {
               year = month;
               month = 0;
               break;
             }
          }
         else
           if (!year)
            {
              if (   *month_list.year
                  && (   list
                      || range))
                year = *month_list.year;
              else
                year = my_atoi (*argv);
            }
       }
      if (   month
          && !year
          && !month_set
          && !*month_list.month)
        year = month, month = 0;
    }
#ifdef ANSISYS
   if (!is_tty)
     highlight_flag = FALSE;
#endif
}
#
#
#
static void
eliminate_invalid_data (void)
/*
   Eliminates invalid command line argument values
*/
{
   if (   !month
       && !year)
    {
      month = act_month;
      year = act_year;
    }
   else
     if (   year < YEAR_MIN
         || year > YEAR_MAX)
      {
        if (   month
            && year)
          month = act_month;
        year = act_year;
      }
   if (   year_flag
       && month)
     month = 0;
   if (   month
       && !*month_list.month)
     *month_list.month = month;
   if (julian_flag)
     out_cols = J_OUT_COLS;
   else
     if (both_dates_flag)
       out_cols = B_OUT_COLS;
     else
       out_cols = S_OUT_COLS;
   switch (out_rows)
    {
      case 1:
        out_cols = MONTH_MAX;
        break;
      case 2:
        out_cols = 6;
        break;
      case 3:
        out_cols = 4;
        break;
      case 4:
        out_cols = 3;
        break;
      case 6:
        out_cols = 2;
        break;
      case 12:
        out_cols = MONTH_MIN;
        break;
      default:
        if (julian_flag)
          out_rows = J_OUT_ROWS;
        else
          if (both_dates_flag)
            out_rows = B_OUT_ROWS;
          else
            out_rows = S_OUT_ROWS;
    }
   /*
      Check for delivered weekday-name
   */
   if (   !start_day
       && *tmp_name)
     start_day = compare_dayname (tmp_name);
   if (   start_day > DAY_MAX
       || start_day < DAY_MIN)
#ifdef GERMAN
     start_day = DAY_MIN;
#else /* !GERMAN */
     start_day = DAY_MAX;
#endif /* !GERMAN */
}
#
#
#
static void
fill_year_vector (const Sint year)
/*
   Builds the standard year vector and the julian year vector
     according to given `year'
*/
{
#ifndef USE_RC
   register Sint  days_of_feb=days_of_february (year);
#endif
   register Sint  i=weekday_of_date (DAY_MIN, MONTH_MIN, year);
   register Sint  count;
   register Sint  d;
   register Sint  m;


   /*
      First, detect starting day of the year
   */
   i=day = SYEAR(i, start_day);
   d=count = 0;
   m = MONTH_MIN;
   /*
      Then, fill the year_vector
   */
   LOOP
    {
      d++;
      count++;
#ifdef USE_RC
      if (!valid_date (d, m, year))
#else /* !USE_RC */
      if (   d > 31
          || (   (d > 30)
              && (   m == 4
                  || m == 6
                  || m == 9
                  || m == 11))
          || (   (d > days_of_feb)
              && (m == 2)))
#endif /* !USE_RC */
       {
         if (m < MONTH_MAX)
          {
            d = DAY_MIN;
            i = m * VEC_BLOCK + day;
            m++;
          }
         else
           break;
       }
      if (   (year == GREG_YEAR)
          && (m == GREG_MONTH)
          && (   (d >= GREG_F_DAY)
              && (d <= GREG_L_DAY)))
        i--;
      else
       {
         day++;
         if (julian_flag)
           year_vector[i-1] = count;
         else
           year_vector[i-1] = d;
         if (both_dates_flag)
           julian_vector[i-1] = count;
       }
      i++;
      if (day > DAY_MAX)
        day = DAY_MIN;
    }
}
#
#
#
static void
print_calendar (void)
/*
   Prints one ore more single month-/year calendar(s)
*/
{
   auto           Slint  amount=0L;
   auto           Slint  count;
   register       Sint   tmp_ad=act_day;
   register       Sint   i=0;
   register       Sint   d;
   register       Sint   m;
   register       Sint   hday;
   register       Sint   hmonth;
   static   const Sint   scale1[]={9, 12};
   static   const Sint   scale2[]={13, 19};
#ifndef ANSISYS
   auto           Bool   is_marked=FALSE;
#endif
   auto           Bool   marker_flag=FALSE;
   auto           Bool   backwards=FALSE;


   if (   !ext_list
       && !ext_range
       && julian_flag)
     act_day = day_of_year (act_day, act_month, act_year);
   if (!ext_range)
     for ( ; month_list.month[i] ; i++)
      {
        if (!month_list.year[i])
          month_list.year[i] = act_year;
        amount++;
      }
   else
    {
      if (!ext_year)
       {
         if (!*month_list.year)
           *month_list.year = act_year;
         if (!month_list.year[1])
           month_list.year[1] = act_year;
         backwards = (Bool)(*month_list.year > month_list.year[1]);
         if (backwards)
           amount = (((*month_list.year - 1L) - month_list.year[1]) * MONTH_MAX)
                      + *month_list.month + ((MONTH_MAX - month_list.month[1]) + 1L);
         else
           amount = (((month_list.year[1] - 1L) - *month_list.year) * MONTH_MAX)
                      + month_list.month[1] + ((MONTH_MAX - *month_list.month) + 1L);
         month = *month_list.month;
         year = *month_list.year;
       }
      else
       {
         backwards = (Bool)(*month_list.month > month_list.month[1]);
         if (backwards)
           amount = (*month_list.month - month_list.month[1]) + 1L;
         else
           amount = (month_list.month[1] - *month_list.month) + 1L;
         year = *month_list.month;
       }
    }
   if (!amount)
     amount++;
   for (count=0L ; count < amount ; count++)
    {
      if (   !ext_list
          && !ext_range)
       {
         if (!ext_year)
           month = month_list.month[(Sint)count];
#ifdef USE_RC
         if (   count
             && (year >= EASTER_MIN)
             && (year <= EASTER_MAX))
           print_all_holidays (TRUE, TRUE);
#endif
       }
      else
       {
         d = 0;
         if (ext_list)
          {
            if (!ext_year)
             {
               month = month_list.month[(Sint)count];
               if (   count
                   && (year == month_list.year[(Sint)count]))
                 d = year;
               else
                 year = month_list.year[(Sint)count];
             }
            else
             {
               month = 0;
               if (   count
                   && (year == month_list.month[(Sint)count]))
                 d = year;
               else
                 year = month_list.month[(Sint)count];
             }
          }
         else
           if (   ext_range
               && count)
            {
              if (!ext_year)
               {
                 d = year;
                 if (backwards)
                  {
                    month--;
                    if (month < MONTH_MIN)
                      month = MONTH_MAX, year--;
                  }
                 else
                  {
                    month++;
                    if (month > MONTH_MAX)
                      month = MONTH_MIN, year++;
                  }
               }
              else
               {
                 month = 0;
                 if (backwards)
                   year--;
                 else
                   year++;
               }
            }
           else
             if (ext_year)
               month = 0;
         if (d != year)
          {
            is_leap_year = (days_of_february (year) == 29);
            for (i=0 ; i < VEC_ELEMS ; i++)
             {
               year_vector[i] = 0;
               if (both_dates_flag)
                 julian_vector[i] = 0;
             }
            fill_year_vector (year);
            if (   (year >= EASTER_MIN)
                && (year <= EASTER_MAX))
              print_all_holidays (TRUE, TRUE);
            else
              for (i=0 ; i < MONTH_MAX ; i++)
                holiday_vector[i][0] = 0;
            if (julian_flag)
              act_day = day_of_year (tmp_ad, act_month, act_year);
          }
         else
           if (   (year >= EASTER_MIN)
               && (year <= EASTER_MAX))
             print_all_holidays (TRUE, TRUE);
       }
      if (   !ext_year
          && (   month
              || ext_list
              || ext_range))
       {
         fprintf(stdout, "\n%s %04d\n\n", month_name (month), year);
         for (i=1 ; i <= MONTH_ROWS ; i++)
          {
#ifdef GERMAN
            fprintf(stdout, "%-11s", day_name (SDAY(i, start_day)));
#else /* !GERMAN */
            fprintf(stdout, "%-10s", day_name (SDAY(i, start_day)));
#endif /* !GERMAN */
            for (d=1 ; d <= MONTH_COLS ; d++)
             {
               day = (  (month - 1) * VEC_BLOCK - 1)
                      + (d * MONTH_ROWS - MONTH_COLS) + (i - 1);
               if (   highlight_flag
                   && (year_vector[day] == act_day)
                   && (month == act_month)
                   && (year == act_year))
#ifndef ANSISYS
                {
                  if (is_marked)
                    marker_flag = print_highlighted_date (marker_flag, "", R_MARKER);
                  else
                   {
#endif
                     marker_flag = print_highlighted_date (marker_flag, L_MARKER, R_MARKER);
#ifndef ANSISYS
                     is_marked = TRUE;
                   }
                }
#endif
               else
                {
                  hday = 0;
                  if (   year_vector[day]
                      && *holiday_vector[month-1])
                   {
                     register Sint  k;


                     for (k=0 ; holiday_vector[month-1][k] ; k++)
                       if (holiday_vector[month-1][k] == year_vector[day])
                        {
                          hday = holiday_vector[month-1][k];
                          break;
                        }
                   }
                  if (   hday
                      && highlight_flag)
#ifndef ANSISYS
                   {
                     if (is_marked)
                       marker_flag = print_highlighted_date (marker_flag, "", R_HMARKER);
                     else
                      {
#endif
                        marker_flag = print_highlighted_date (marker_flag, L_HMARKER, R_HMARKER);
#ifndef ANSISYS
                        is_marked = TRUE;
                      }
                   }
#endif
                  else
                   {
                     marker_flag = print_single_date (marker_flag);
#ifndef ANSISYS
                     is_marked = FALSE;
#endif
                   }
                }
             }
            S_NEWLINE(stdout);
#ifndef ANSISYS
            marker_flag = FALSE;
#endif
          }
#ifdef USE_RC
         if (   rc_use_flag
             && (   ext_list
                 || ext_range
                 || amount > 1))
          {
            if (   (month == act_month)
                && (year == act_year))
             {
               act_year--;
               rc_use ();
               act_year++;
             }
            else
              rc_use ();
          }
#endif
       }
      else
       {
         if (both_dates_flag)
           fprintf(stdout, "\n\n%*s%04d\n\n\n", 24*out_cols, "", year);
         else
           fprintf(stdout, "\n\n%*s%04d\n\n\n",
                   scale1[(Sint)julian_flag]*out_cols, "", year);
         for (m=0 ; m < out_rows ; m++)
          {
            if (both_dates_flag)
              for (i=1 ; i <= out_cols ; i++)
                fprintf(stdout, "     %-43s", month_name (m*out_cols+i));
            else
              for (i=1 ; i <= out_cols ; i++)
                fprintf(stdout, "     %-*s",
                        scale2[(Sint)julian_flag], month_name (m*out_cols+i));
            D_NEWLINE(stdout);
            for (i=1 ; i <= MONTH_ROWS ; i++)
             {
               fprintf(stdout, "%-4s", short_day_name (SDAY(i, start_day)));
               for (d=1 ; d <= MONTH_COLS * out_cols ; d++)
                {
                  day = (  (m * out_cols) * VEC_BLOCK - 1)
                         + (d * MONTH_ROWS - MONTH_COLS) + (i - 1);
                  hmonth = (m * out_cols) + ((d-1) / MONTH_COLS) + 1;
                  if (   highlight_flag
                      && (year_vector[day] == act_day)
                      && (hmonth == act_month)
                      && (year == act_year))
#ifndef ANSISYS
                   {
                     if (is_marked)
                       marker_flag = print_highlighted_date (marker_flag, "", R_MARKER);
                     else
                      {
#endif
                        marker_flag = print_highlighted_date (marker_flag, L_MARKER, R_MARKER);
#ifndef ANSISYS
                        is_marked = TRUE;
                      }
                   }
#endif
                  else
                   {
                     hday = 0;
                     if (   year_vector[day]
                         && *holiday_vector[hmonth-1])
                      {
                        register Sint  k;


                        for (k=0 ; holiday_vector[hmonth-1][k] ; k++)
                          if (holiday_vector[hmonth-1][k] == year_vector[day])
                           {
                             hday = holiday_vector[hmonth-1][k];
                             break;
                           }
                      }
                     if (   hday
                         && highlight_flag)
#ifndef ANSISYS
                      {
                        if (is_marked)
                          marker_flag = print_highlighted_date (marker_flag, "", R_HMARKER);
                        else
                         {
#endif
                           marker_flag = print_highlighted_date (marker_flag, L_HMARKER, R_HMARKER);
#ifndef ANSISYS
                           is_marked = TRUE;
                         }
                      }
#endif
                     else
                      {
                        marker_flag = print_single_date (marker_flag);
#ifndef ANSISYS
                        is_marked = FALSE;
#endif
                      }
                   }
                }
               S_NEWLINE(stdout);
#ifndef ANSISYS
               marker_flag = FALSE;
#endif
             }
            if (m < out_rows-1)
              D_NEWLINE(stdout);
          }
#ifdef USE_RC
         if (   rc_use_flag
             && (   ext_list
                 || ext_range))
           rc_use ();
#endif
         if (   ext_year
             && holiday_flag
             && (year >= EASTER_MIN)
             && (year <= EASTER_MAX))
           print_all_holidays (FALSE, FALSE);
       }
    }
   if (julian_flag)
     act_day = tmp_ad;
}
#
#
#
static Bool
print_single_date (Bool marker_flag)
/*
   Like the function name says
*/
{
   if (julian_flag)
    {
      if (year_vector[day])
       {
         if (marker_flag)
          {
            fprintf(stdout, "%3d", year_vector[day]);
            marker_flag = FALSE;
          }
         else
           fprintf(stdout, "%4d", year_vector[day]);
       }
      else
       {
         if (marker_flag)
          {
            fputs("   ", stdout);
            marker_flag = FALSE;
          }
         else
           fputs("    ", stdout);
       }
    }
   else
    {
      if (year_vector[day])
       {
         if (marker_flag)
          {
            if (both_dates_flag)
              fprintf(stdout, "%2d(%3d)", year_vector[day], julian_vector[day]);
            else
              fprintf(stdout, "%2d", year_vector[day]);
            marker_flag = FALSE;
          }
         else
          {
            if (both_dates_flag)
              fprintf(stdout, "%3d(%3d)", year_vector[day], julian_vector[day]);
            else
              fprintf(stdout, "%3d", year_vector[day]);
          }
       }
      else
       {
         if (marker_flag)
          {
            if (both_dates_flag)
              fputs("       ", stdout);
            else
              fputs("  ", stdout);
            marker_flag = FALSE;
          }
         else
          {
            if (both_dates_flag)
              fputs("        ", stdout);
            else
              fputs("   ", stdout);
          }
       }
    }

   return(marker_flag);
}
#
#
#
static Bool
print_highlighted_date (      Bool   marker_flag,
                        const Schar *l_marker,
                        const Schar *r_marker)
/*
   Like the function name says
*/
{
   if (julian_flag)
     fprintf(stdout, "%s%3d%s", l_marker, year_vector[day], r_marker);
   else
    {
      if (both_dates_flag)
        fprintf(stdout, "%s%2d(%3d)%s",
                l_marker, year_vector[day], julian_vector[day], r_marker);
      else
        fprintf(stdout, "%s%2d%s", l_marker, year_vector[day], r_marker);
    }
#ifndef ANSISYS
   marker_flag = TRUE;
#endif

   return(marker_flag);
}
#
#
#
static void
print_single_holiday (      Bool   init_data,
                      const Bool   detect,
                      const Schar *holiday_name,
                      const Schar *holiday_prefix,
                            Sint   day,
                            Sint   month,
                      const Sint   year,
                            Sint  *hd_elems)
/*
   Generates a single holiday date in formatted manner
     and stores the result into global `hd_buffer'.
     If `holiday_prefix' starts with a `*' (ASTERISK) character, this holiday
     is not stored into global `holiday_vector' and not highlighted.
*/
{
   register Sint  i;
   register Sint  hd;
   static   Sint  hcount[MONTH_MAX];


   if (!month)
    {
      if (day-is_leap_year > 59)
       {
         month = (Sint)((63 + day - is_leap_year) / 30.61) - 1;
         day = (Sint)(63 + day - is_leap_year - abs((Sint)((month + 1) * 30.61)));
       }
      else
       {
         month = (Sint)((428 + day) / 30.61) - 13;
         day = (Sint)(428 + day - abs((Sint)((month + 13) * 30.61)));
       }
    }
   hd = day_of_year (day, month, year);
   if (   holiday_flag
#ifdef USE_RC
       || rc_enable_hd_flag
#endif
      )
    {
      register Sint  len=(hd_julian_flag&&!both_dates_flag)?3:2;
      register Sint  d=day;


      i = hd - day_of_year (act_day, act_month, act_year);
      if (hd_julian_flag&&!both_dates_flag)
        d = hd;
      strcpy(tmp_name, holiday_name);
      if (strlen(tmp_name) >= LEN_HD_NAME)
        tmp_name[LEN_HD_NAME-1] = '\0';
      sprintf(s, "%04d%02d%02d%-*s  %-1s  ",
                 year, month, day, LEN_HD_NAME-1, tmp_name, holiday_prefix);
      strcpy(tmp_name, s);
#ifdef GERMAN
      sprintf(s, "ist %2s, der ", short_day_name (weekday_of_date (day, month, year)));
      strcat(tmp_name, s);
      if (   !i
          && (year == act_year))
       {
#  ifdef ANSISYS
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, "%s%2d(%3d)%s ", L_MARKER, d, hd, R_MARKER);
         else
           sprintf(s, "%s%*d%s ", L_MARKER, len, d, R_MARKER);
#  else /* !ANSISYS */
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, "%s%2d(%3d)%s", L_MARKER, d, hd, R_MARKER);
         else
           sprintf(s, "%s%*d%s", L_MARKER, len, d, R_MARKER);
#  endif /* !ANSISYS */
       }
      else
       {
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, " %2d(%3d) ", d, hd);
         else
           sprintf(s, " %*d ", len, d);
       }
      strcat(tmp_name, s);
      if (   i
          && (year == act_year))
        sprintf(s, "%s %04d  >>>  %+4d Tag%s",
                   (hd_julian_flag&&!both_dates_flag)
                   ? "Tag"
                   : short_month_name (month),
                   year, i,
                   (abs(i) == 1)
                   ? ""
                   : "e");
      else
        sprintf(s, "%s %04d",
                   (hd_julian_flag&&!both_dates_flag)
                   ? "Tag"
                   : short_month_name (month),
                   year);
#else /* !GERMAN */
      sprintf(s, "is %2s, %s%s", short_day_name (weekday_of_date (day, month, year)),
                 (hd_julian_flag&&!both_dates_flag)
                 ? ""
                 : short_month_name (month),
                 (hd_julian_flag&&!both_dates_flag)
                 ? ""
                 : " ");
      strcat(tmp_name, s);
      if (   !i
          && (year == act_year))
       {
#  ifdef ANSISYS
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, "%s%2d%s(%3d)%s ", L_MARKER, d, day_suffix (d), hd, R_MARKER);
         else
           sprintf(s, "%s%*d%s%s ", L_MARKER, len, d, day_suffix (d), R_MARKER);
#  else /* !ANSISYS */
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, "%s%2d%s(%3d)%s", L_MARKER, d, day_suffix (d), hd, R_MARKER);
         else
           sprintf(s, "%s%*d%s%s", L_MARKER, len, d, day_suffix (d), R_MARKER);
#  endif /* !ANSISYS */
       }
      else
       {
         if (   both_dates_flag
             && hd_julian_flag)
           sprintf(s, " %2d%s(%3d) ", d, day_suffix (d), hd);
         else
           sprintf(s, " %*d%s ", len, d, day_suffix (d));
       }
      strcat(tmp_name, s);
      if (   i
          && (year == act_year))
        sprintf(s, "%s%04d  >>>  %+4d day%s",
                   (hd_julian_flag&&!both_dates_flag)
                   ? "day "
                   : "",
                   year, i,
                   (abs(i) == 1)
                   ? ""
                   : "s");
      else
        sprintf(s, "%s%04d",
                   (hd_julian_flag&&!both_dates_flag)
                   ? "day "
                   : "",
                   year);
#endif /* !GERMAN */
      strcat(tmp_name, s);
      if (*hd_elems < HD_ELEMS_MAX)
       {
         hd_buffer[*hd_elems] = (Schar *)(malloc(strlen(tmp_name)+1));
         if (hd_buffer[*hd_elems] == NULL)
          {
#ifdef GERMAN
            fprintf(stderr, "`%s' Zeile %d: malloc() hat versagt.\n",
                    __FILE__, __LINE__);
#else /* !GERMAN */
            fprintf(stderr, "`%s' line %d: malloc() fails.\n",
                    __FILE__, __LINE__);
#endif /* !GERMAN */
            exit(252);
          }
         else
           strcpy(hd_buffer[(*hd_elems)++], tmp_name);
       }
    }
   if (init_data)
     for (i=0 ; i < MONTH_MAX ; i++)
       hcount[i] = 0;
   if (   detect
       && (*holiday_prefix != '*'))
     holiday_vector[month-1][hcount[month-1]++] =
       (julian_flag)
       ? hd
       : day;
}
#
#
#
static Sint
eval_holiday (      Sint day,
              const Sint month,
              const Sint year,
              const Sint wd,
              const Bool forward)
/*
   Detects a holiday which is like:
     this <holiday> is at <weekday> at <number> week of <number> month
   and returns the evaluated weekday (1..7)
*/
{
   LOOP
    {
      if (weekday_of_date (day, month, year) == wd)
        break;
      else
        (forward)
        ? day++
        : day--;
    }

   return(day);
}
#
#
#
static void
print_all_holidays (      Bool init_data,
                    const Bool detect)
/*
   Prints all generated holidays (global `hc_buffer') in a sorted manner
*/
{
   register Sint  easter=gauss_easter_formula (year);
   register Sint  i;
   register Sint  j;
   register Sint  day;
   auto     Sint  hd_elems=0;


#ifdef GERMAN
   if (!detect)
     fprintf(stdout, "\nDas Jahr %04d ist %sEIN Schaltjahr\n", year,
             (is_leap_year)
             ? ""
             : "K");
#else /* !GERMAN */
   if (!detect)
     fprintf(stdout, "\nThe year %04d is %s leap year\n", year,
             (is_leap_year)
             ? "A"
             : "NO");
#endif /* !GERMAN */
   if (   init_data
       || detect)
    {
      if (init_data)
        for (i=0 ; i < MONTH_MAX ; i++)
          for (j=0 ; j < MONTH_MAX ; j++)
            holiday_vector[i][j] = 0;
#ifdef GERMAN
      print_single_holiday (init_data, detect, "Neujahr",
                            "", 1, 1, year, &hd_elems);
      if (init_data)
        init_data = FALSE;
      print_single_holiday (init_data, detect, "St. Valentinstag",
                            "*", 14, 2, year, &hd_elems);
      print_single_holiday (init_data, detect, "Rosenmontag",
                            "*", easter-48, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Aschermittwoch",
                            "*", easter-46, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Palmsonntag",
                            "*", easter-7, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Karfreitag",
                            "", easter-2, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Ostersonntag",
                            "", easter, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Ostermontag",
                            "", easter+1, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Tag der Arbeit",
                            "#", 1, 5, year, &hd_elems);
      day = eval_holiday (1, 5, year, 7, TRUE);
      if (day_of_year (day, 5, year) != easter+49)
        day += 7;
      print_single_holiday (init_data, detect, "Muttertag",
                            "*", day, 5, year, &hd_elems);
      print_single_holiday (init_data, detect, "Christi Himmelfahrt",
                            "#", easter+39, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Pfingstsonntag",
                            "", easter+49, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Pfingstmontag",
                            "", easter+50, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Fronleichnam",
                            "#", easter+60, 0, year, &hd_elems);
      day = eval_holiday (1, 6, year, 7, TRUE);
      print_single_holiday (init_data, detect, "Vatertag",
                            "*", day+14, 6, year, &hd_elems);
      print_single_holiday (init_data, detect, "Mari"AE" Himmelfahrt",
                            "*", 15, 8, year, &hd_elems);
      print_single_holiday (init_data, detect, "Allerheiligen",
                            "#", 1, 11, year, &hd_elems);
      day = weekday_of_date (1, 11, year);
      day = (day < 3)
            ? 18 - day
            : 25 - day;
      print_single_holiday (init_data, detect, "Bu"SZ"- und Bettag",
                            "", day, 11, year, &hd_elems);
      print_single_holiday (init_data, detect, "Heiligabend",
                            "#", 24, 12, year, &hd_elems);
      print_single_holiday (init_data, detect, "1'ter Weihnachtstag",
                            "", 25, 12, year, &hd_elems);
      print_single_holiday (init_data, detect, "2'ter Weihnachtstag",
                            "", 26, 12, year, &hd_elems);
      print_single_holiday (init_data ,detect, "Silvester",
                            "*", 31, 12, year, &hd_elems);
#else /* !GERMAN */
      print_single_holiday (init_data, detect, "New Year's Day",
                            "", 1, 1, year, &hd_elems);
      if (init_data)
        init_data = FALSE;
      print_single_holiday (init_data, detect, "Ash Wednesday",
                            "*", easter-46, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Palm Sunday",
                            "*", easter-7, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Good Friday",
                            "", easter-2, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Easter Sunday",
                            "", easter, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Easter Monday",
                            "", easter+1, 0, year, &hd_elems);
      day = eval_holiday (1, 5, year, 7, TRUE);
      if (day_of_year (day, 5, year) != easter+49)
        day += 7;
      print_single_holiday (init_data, detect, "Mother's Day",
                            "*", day, 5, year, &hd_elems);
      print_single_holiday (init_data, detect, "Whitsunday",
                            "", easter+49, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Whit Monday",
                            "", easter+50, 0, year, &hd_elems);
      print_single_holiday (init_data, detect, "Feast of Corpus Christi",
                            "#", easter+60, 0, year, &hd_elems);
      day = eval_holiday (1, 6, year, 7, TRUE);
      print_single_holiday (init_data, detect, "Father's Day",
                            "*", day+14, 6, year, &hd_elems);
      print_single_holiday (init_data, detect, "All Saints' Day",
                            "", 1, 11, year, &hd_elems);
      print_single_holiday (init_data, detect, "Christmas Eve",
                            "#", 24, 12, year, &hd_elems);
      print_single_holiday (init_data, detect, "1'st Christmas Day",
                            "", 25, 12, year, &hd_elems);
      print_single_holiday (init_data, detect, "2'nd Christmas Day",
                            "", 26, 12, year, &hd_elems);
      print_single_holiday (init_data, detect, "Sylvester",
                            "*", 31, 12, year, &hd_elems);
#  ifdef US_HDAY
      day = eval_holiday (1, 1, year, 1, TRUE);
      print_single_holiday (init_data, detect, "Martin L. King's Day",
                            "*", day+14, 1, year, &hd_elems);
      print_single_holiday (init_data, detect, "St. Valentine's Day",
                            "*", 14, 2, year, &hd_elems);
      day = eval_holiday (1, 2, year, 1, TRUE);
      print_single_holiday (init_data, detect, "President's Day",
                            "#", day+14, 2, year, &hd_elems);
      print_single_holiday (init_data, detect, "St. Patrick's Day",
                            "#", 17, 3, year, &hd_elems);
      print_single_holiday (init_data, detect, "All Fool's Day",
                            "*", 1, 4, year, &hd_elems);
      day = eval_holiday (1, 5, year, 6, TRUE);
      print_single_holiday (init_data, detect, "Armed Force's Day",
                            "*", day+14, 5, year, &hd_elems);
      day = eval_holiday (31, 5, year, 1, FALSE);
      print_single_holiday (init_data, detect, "Memorial Day",
                            "#", day, 5, year, &hd_elems);
      print_single_holiday (init_data, detect, "Flag Day",
                            "*", 14, 6, year, &hd_elems);
      print_single_holiday (init_data, detect, "Independence Day",
                            "#", 4, 7, year, &hd_elems);
      day = eval_holiday (1, 9, year, 1, TRUE);
      print_single_holiday (init_data, detect, "Labour Day",
                            "#", day, 9, year, &hd_elems);
      day = eval_holiday (1, 9, year, 5, TRUE);
      print_single_holiday (init_data, detect, "American Indian Day",
                            "*", day+21, 9, year, &hd_elems);
      day = eval_holiday (1, 10, year, 1, TRUE);
      print_single_holiday (init_data, detect, "Columbus Day",
                            "*", day+7, 10, year, &hd_elems);
      print_single_holiday (init_data, detect, "Halloween",
                            "#", 31, 10, year, &hd_elems);
      day = eval_holiday (1, 11, year, 2, TRUE);
      if (day == 1)
        day += 7;
      print_single_holiday (init_data, detect, "Election Day",
                            "#", day, 11, year, &hd_elems);
      print_single_holiday (init_data, detect, "Veteran's Day",
                            "*", 11, 11, year, &hd_elems);
      day = eval_holiday (1, 11, year, 4, TRUE);
      print_single_holiday (init_data, detect, "Thanksgiving",
                            "#", day+21, 11, year, &hd_elems);
#  endif
#endif /* !GERMAN */
    }
   if (   hd_elems
       && holiday_flag)
    {
      if (hd_elems > 1)
       {
         if (hd_sort_des_flag)
           qsort((void **)hd_buffer, hd_elems, sizeof *hd_buffer, (Func_cmp)des_sort);
         else
           qsort((void **)hd_buffer, hd_elems, sizeof *hd_buffer, (Func_cmp)asc_sort);
       }
    }
   else
     if (!detect)
      {
        i = 0;
        while (   (hd_buffer[i] != NULL)
               && (i < HD_ELEMS_MAX))
         {
           fprintf(stdout, "%s\n", (*(hd_buffer+i)+8));
           free(hd_buffer[i]);
           hd_buffer[i++] = NULL;
         }
      }
}
#
#
#
static Sint
compare_monthname (const Schar *s)
/*
   Compares delivered month name `s' with the built-in monthnames
     and returns: 1..12 == monthname 1..12 found ; 0 otherwise
*/
{
   register       Sint    len=strlen(s);
   register       Sint    i;
   register       Sint    j;
   auto     const Schar  *ptr_char;


   if (len)
     for (i=MONTH_MIN ; i <= MONTH_MAX ; i++)
      {
        ptr_char = month_name (i);
        j = 0;
        while (   *(ptr_char + j)
               && s[j])
          if (toupper(*(ptr_char + j)) == toupper(s[j]))
            j++;
          else
            break;
        if (   j == len
            || !*(ptr_char + j))
          return(i);
      }

   return(0);
}
#
#
#
static Sint
compare_dayname (const Schar *s)
/*
   Compares delivered day name `s' with the built-in daynames
     and returns: 1..7 == dayname 1..7 found ; 0 otherwise
*/
{
   register       Sint    len=strlen(s);
   register       Sint    i;
   register       Sint    j;
   auto     const Schar  *ptr_char;


   if (len)
     for (i=DAY_MIN ; i <= DAY_MAX ; i++)
      {
        ptr_char = day_name (i);
        j = 0;
        while (   *(ptr_char + j)
               && s[j])
          if (toupper(*(ptr_char + j)) == toupper(s[j]))
            j++;
          else
            break;
        if (   j == len
            || !*(ptr_char + j))
          return(i);
      }

   return(0);
}
#
#
#
static void
build_month_list (const Schar *argv[])
/*
   If more than a single month/year is wanted, fill the global
     data structure `month_list'; used in print_calendar();
     according the values found in the command line
*/
{
   register       Sint    i;
   register       Sint    j;
   auto     const Schar  *option;
   auto           Bool    list=FALSE;
   auto           Bool    range=FALSE;
   auto           Bool    year_sep_found;


   option = *argv;
   for ( ; *option && !list && !range; option++)
     if (   *option == *MLIST_SEP
         || *option == *YLIST_SEP)
      {
        list = TRUE;
        if (*option == *YLIST_SEP)
          ext_list=ext_year = TRUE;
      }
     else
       if (   *option == *MRANGE_SEP
           || *option == *YRANGE_SEP)
        {
          range = TRUE;
          if (*option == *YRANGE_SEP)
            ext_range=ext_year = TRUE;
        }
   if (   list
       || range)
    {
      i = 0;
      option = *argv;
      while (   *option
             && (i < MONTH_MAX))
       {
         year_sep_found = FALSE;
         j = 0;
         while (   *option
                && !year_sep_found
                && (   (   list
                        && (   (*option != *MLIST_SEP)
                            && (*option != *YLIST_SEP)))
                    || (   range
                        && (   (*option != *MRANGE_SEP)
                            && (*option != *YRANGE_SEP)))))
           year_sep_found = (Bool)((s[j++]=*option++) == *YEAR_SEP);
         if (year_sep_found)
           s[j-1] = '\0';
         else
           s[j] = '\0';
         j = my_atoi (s);
         if (ext_year)
          {
            if (j)
              month_list.month[i++] = j;
            else
              if (list)
                month_list.month[i++] = act_year;
            if (year_sep_found)
             {
               year_sep_found = FALSE;
               while (*option == *YEAR_SEP)
                 option++;
               while (   *option
                      && (   (   list
                              && (*option != *YLIST_SEP))
                          || (   range
                              && (*option != *YRANGE_SEP))))
                 option++;
             }
          }
         else
          {
            if (   (j >= MONTH_MIN)
                && (j <= MONTH_MAX))
              month_list.month[i++] = j;
            else
             {
               j = compare_monthname (s);
               if (j)
                 month_list.month[i++] = j;
             }
          }
         if (year_sep_found)
          {
            if (j)
             {
               j = 0;
               while (*option == *YEAR_SEP)
                 option++;
               while (   *option
                      && (   (   list
                              && (*option != *MLIST_SEP))
                          || (   range
                              && (*option != *MRANGE_SEP))))
                 s[j++] = *option++;
               s[j] = '\0';
               j = my_atoi (s);
               if (   (j >= YEAR_MIN)
                   && (j <= YEAR_MAX)
                   && (j != act_year))
                {
                  month_list.year[i-1] = j;
                  if (   list
                      && !ext_range)
                    ext_list = TRUE;
                  else
                    if (   range
                        && !ext_list)
                      ext_range = TRUE;
                }
             }
            else
              while (   *option
                     && (   (   list
                             && (*option != *MLIST_SEP))
                         || (   range
                             && (*option != *MRANGE_SEP))))
                option++;
          }
         while (   *option == *MLIST_SEP
                || *option == *MRANGE_SEP
                || *option == *YLIST_SEP
                || *option == *YRANGE_SEP)
           option++;
       }
      if (   range
          && !ext_range)
       {
         register Sint  k;


         j = *month_list.month;
         k = month_list.month[1];
         i = 0;
         while (month_list.month[i])
           month_list.month[i++] = 0;
         if (   !j
             && !k)
           *month_list.month = act_month;
         else
          {
            if (!j)
              j = MONTH_MIN;
            if (!k)
              k = MONTH_MAX;
            i = 0;
            if (j > k)
              for ( ; j >= k ; i++, j--)
                month_list.month[i] = j;
            else
              for ( ; j <= k ; i++, j++)
                month_list.month[i] = j;
          }
       }
      if (   !month_list.month[1]
          && (   ext_list
              || ext_range
              || ext_year))
       {
         ext_list=ext_range=ext_year = FALSE;
         *month_list.month = act_month;
         *month_list.year = act_year;
       }
    }
}
#
#
#
static Sint
asc_sort (const Schar **a,
          const Schar **b)
/*
   The (q)sort compare function; ascending order
*/
{
   return(strcmp(*a, *b));
}
#
#
#
static Sint
des_sort (const Schar **a,
          const Schar **b)
/*
   The (q)sort compare function; descending order
*/
{
   return(strcmp(*b, *a));
}
#
#
#
#ifdef USE_RC
static Schar
*rc_get_date (Schar *ptr_char,
              Schar *s,
              Sint  *d,
              Sint  *m,
              Sint  *y)
/*
   Converts a textual/string `date' to a numerical date
*/
{
   register Sint   i;
   static   Schar  str[5];


   for (i=0 ; i < 4 ; i++)
     str[i] = *ptr_char++;
   str[i] = '\0';
   *y = my_atoi (str);
   for (i=0 ; i < 2 ; i++)
     str[i] = *ptr_char++;
   str[i] = '\0';
   *m = my_atoi (str);
   for (i=0 ; i < 2 ; i++)
     str[i] = *ptr_char++;
   str[i] = '\0';
   *d = my_atoi (str);
   strcpy(s, str);

   return(ptr_char);
}
#
#
#
static Bool
rc_read_line (FILE  *fp,
              Schar *tmp_buffer,
              Sint  *line)
/*
   Reads a textline of the delivered (resource-)file into `tmp_buffer'
*/
{
   register Sint    i=0;
   register Sint    j=1;
   register Sint    ch;
   auto     Schar  *ptr_char;
   auto     Bool    is_error=FALSE;
   auto     Bool    is_remark=FALSE;


   (*line)++;
   ptr_char = tmp_buffer;
   if ((ch=fgetc(fp)) != EOF)
    {
      while (   (ch != RC_REM_CHAR)
             && (ch != EOF)
             && !isalnum(ch))
        ch=fgetc(fp);
      if (ch == EOF)
        return(FALSE);
      else
        if (ch == RC_REM_CHAR)
          is_remark = TRUE;
        else
          *ptr_char++ = (Schar)ch;
      while (   (ch=fgetc(fp)) != EOF
             && (ch != '\n'))
        if (!is_remark)
         {
           i++;
           if (   (i < 6)
               && !isdigit(ch))
             is_error = TRUE;
           if (j++ < BUFSIZ)
             *ptr_char++ = (Schar)ch;
         }
      *ptr_char = '\0';
    }
   else
     return(FALSE);
   if (is_error)
    {
#  ifdef GERMAN
      fprintf(stderr, "Unzul"AE"ssiger Datumseintrag in `%s'\nZeile %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  else /* !GERMAN */
      fprintf(stderr, "Invalid date entry in `%s'\nLine %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  endif /* !GERMAN */
      exit(251);
    }

   return(TRUE);
}
#
#
#
static void
rc_check (      Schar *tmp_buffer,
                Schar *s,
                Sint  *line,
                Sint  *rc_elems,
                Sint   day,
                Sint   ed,
          const Sint   wd)
/*
   Checks whether a single line of resource file resp.,
     (internal)holidaymust be printed
*/
{
   register Sint    i;
   register Sint    save_year=0;
   register Sint    print_two_times;
   auto     Sint    d;
   auto     Sint    m;
   auto     Sint    y;
   auto     Sint    dd;
   auto     Sint    mm;
   auto     Sint    yy;
   auto     Schar  *ptr_char;
   auto     Bool    print_line;
   auto     Bool    is_weekday_mode;
   auto     Bool    is_valid_date;


   ptr_char = rc_get_date (tmp_buffer, s, &d, &m, &y);
   if (m > MONTH_MAX)
    {
#  ifdef GERMAN
      fprintf(stderr, "Ung"UE"ltiger Monat in `%s'\nZeile %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  else /* !GERMAN */
      fprintf(stderr, "Invalid month in `%s'\nLine %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  endif /* !GERMAN */
      exit(250);
    }
   is_weekday_mode = FALSE;
   d = compare_dayname (s);
   if (d)
     is_weekday_mode = TRUE;
   else
     d = my_atoi (s);
   if (   !month
       || year != act_year
       || (   (month != act_month)
           && (year == act_year)))
    {
      if (   m
          && d)
        is_valid_date = valid_date (d, m, (y) ? y : year);
      else
        is_valid_date = TRUE;
    }
   else
     is_valid_date = valid_date (d, (m) ? m : month, (y) ? y : year);
   if (!is_valid_date)
    {
#  ifdef GERMAN
      fprintf(stderr, "Ung"UE"ltiger Tag in `%s'\nZeile %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  else /* !GERMAN */
      fprintf(stderr, "Invalid day in `%s'\nLine %d: %s\n",
              PRGR_RC_NAME, *line, tmp_buffer);
#  endif /* !GERMAN */
      exit(249);
    }
   /*
      Check if current line must be printed
   */
   print_line = FALSE;
   print_two_times = 1;
   if (   !month
       || year != act_year
       || (   (month != act_month)
           && (year == act_year)))
    {
      if (   !is_weekday_mode
          && (   !y
              || y == year)
          && m
          && d)
       {
         if (month)
          {
            if (m == month)
              print_line = TRUE;
          }
         else
           print_line = TRUE;
       }
    }
   else
    {
      if (   (   rc_week_flag
              || rc_month_flag
              || rc_year_flag)
          && (   !y
              || y == year
              || (   rc_week_flag
                  && rc_backwards_flag
                  && (y == year-1))
              || (   rc_week_flag
                  && !rc_backwards_flag
                  && (y == year+1))))
       {
         register Sint  td;


         if (   m
             && d)
          {
            if (day < 1)
              if (   !y
                  && (m != month)
                  && rc_week_flag
                  && rc_backwards_flag)
                y = year - 1;
            if (ed > 365+is_leap_year)
              if (   !y
                  && (m != month)
                  && rc_week_flag
                  && !rc_backwards_flag)
                y = year + 1;
            if (!y)
              y = year;
          }
         if (   (   rc_week_flag
                 && is_weekday_mode)
             || (   !is_weekday_mode
                 && (   y
                     || m
                     || d)))
          {
            /*
               Respect short day name entry yyyymm## ...   (##==short dayname)
            */
            if (   rc_week_flag
                && is_weekday_mode)
             {
               register Sint   j=0;
               static   struct {
                                 Schar day[DAY_MAX];
                                 Schar dst[DAY_MAX];
                               } wday_list;
               static   Bool   fill_wday_list=FALSE;


               if (!fill_wday_list)
                {
                  if (rc_backwards_flag)
                   {
                     if (wd != start_day)
                      {
                        i = wd - 1;
                        LOOP
                         {
                           if (i < DAY_MIN)
                             i = DAY_MAX;
                           wday_list.day[i-1] = (Schar)i;
                           wday_list.dst[i-1] = (Schar)++j;
                           if (i == start_day)
                             break;
                           i--;
                         }
                      }
                   }
                  else
                   {
                     i = wd;
                     LOOP
                      {
                        wday_list.day[i-1] = (Schar)i;
                        wday_list.dst[i-1] = (Schar)j++;
                        i++;
                        if (i > DAY_MAX)
                          i = DAY_MIN;
                        if (i == start_day)
                          break;
                      }
                   }
                  fill_wday_list = TRUE;
                }
               if (wday_list.day[d-1])
                {
                  dd = act_day;
                  mm = month;
                  yy = year;
                  if (rc_backwards_flag)
                    for (i=0 ; i < wday_list.dst[d-1] ; i++)
                      prev_date (&dd, &mm, &yy);
                  else
                    for (i=0 ; i < wday_list.dst[d-1] ; i++)
                      next_date (&dd, &mm, &yy);
                  if (   (   !m
                          || m == mm)
                      && (   !y
                          || y == yy))
                    d = dd, m = mm, y = yy;
                  else
                    y = -1;
                }
               else
                 y = -1;
             }
            if (   rc_week_flag
                && (   day < 1
                    || ed > 365+is_leap_year))
             {
               if (   rc_backwards_flag
                   && (y < year))
                {
                  i = (days_of_february (y) == 29);
                  ed = 365 + i;
                  day = ed + day;
                  td = day_of_year (d, m, y) + i;
                  if (   (td <= ed)
                      && (td >= day))
                   {
                     save_year = year;
                     year = y;
                     print_line = TRUE;
                   }
                }
               else
                 if (   !rc_backwards_flag
                     && (y > year))
                  {
                    td = day_of_year (d, m, y) + 365 + is_leap_year;
                    if (   (td < ed)
                        && (td >= day))
                     {
                       save_year = year;
                       year = y;
                       print_line = TRUE;
                     }
                  }
                 else
                  {
                    if (   d
                        && m)
                     {
                       td = day_of_year (d, m, y);
                       if (   (td >= day)
                           && (td < ed))
                         print_line = TRUE;
                     }
                  }
             }
            else
              if (   !y
                  || y == year)
               {
                 if (   (   rc_year_flag
                         || (   rc_week_flag
                             && rc_backwards_flag))
                     && (   !m
                         || !d))
                   ;   /* !! */
                 else
                  {
                    if (!m)
                      m = month;
                    if (!y)
                      y = year;
                    td = day_of_year (d, m, y);
                    if (   (td >= day)
                        && (td < ed))
                      print_line = TRUE;
                  }
               }
          }
       }
      else
       {
         dd = act_day;
         mm = month;
         yy = year;
         if (is_weekday_mode)
          {
            auto Bool  is_next_date=FALSE;


            if (rc_tomorrow_flag)
              next_date (&dd, &mm, &yy);
            is_next_date = (Bool)(d == weekday_of_date (dd, mm, yy));
            if (   (   !y
                    || y == year)
                && (   !m
                    || m == month)
                && (   d == weekday_of_date (act_day, month, year)
                    || is_next_date))
             {
               if (is_next_date)
                 m = mm, d = dd;
               else
                 m = month, d = act_day;
               print_line = TRUE;
             }
          }
         else
          {
            if (rc_tomorrow_flag)
              next_date (&dd, &mm, &yy);
            if (   (   !y
                    || y == year)
                && (   !m
                    || m == month)
                && (   !d
                    || d == act_day
                    || (   (d == dd)
                        && (mm == month))))
             {
               if (   rc_tomorrow_flag
                   && !d
                   && (   !m
                       || mm == month))
                 print_two_times = 2;
               if (!m)
                 m = month;
               if (!d)
                 d = act_day;
               print_line = TRUE;
             }
          }
       }
    }
   /*
      Avoid incorrect assignment in case mentioned appointment occured
        during the missing period in month of gregorian reformation
   */
   if (   print_line
       && (year == GREG_YEAR)
       && (m == GREG_MONTH)
       && (   (d >= GREG_F_DAY)
           && (d <= GREG_L_DAY)))
     print_line = FALSE;
   /*
      Put current line into `rc_buffer'
   */
   if (   print_line
       && (*rc_elems < RC_ELEMS_MAX-print_two_times+1))
    {
      register Sint  j=0;
      register Sint  k=0;
      auto     Bool  is_b=FALSE;


      while (isspace(*ptr_char))
        ptr_char++;
      while (   *(ptr_char + j)
             && (*(ptr_char + j) != RC_FOR_CHAR))
       {
         s[j] = *(ptr_char + j);
         k = ++j;
       }
      if (*(ptr_char + j++))
       {
         /*
            Check for %byyyy and %yyyyy macros
         */
         is_b = (Bool)(toupper(*(ptr_char + j)) == 'B');
         if (   is_b
             || toupper(*(ptr_char + j)) == 'Y')
          {
            auto   Slint  diff=0L;
            static Schar  str[8];
            auto   Schar  ok=TRUE;


            j++;
            i = 0;
            while (   *(ptr_char + j) == '-'
                   || isdigit(*(ptr_char + j)))
             {
               if (i < 4)
                 str[i++] = *(ptr_char + j);
               j++;
             }
            str[i] = '\0';
            i = my_atoi (str);
            if (i)
             {
               if (is_b)
                 diff = (Slint)(year - i);
               else
                 diff = (Slint)(i - year);
               if (   is_b
                   && (diff < 1L))
                 ok = FALSE;
               if (ok)
                {
                  sprintf(str, "%ld", diff);
                  i = 0;
                  while (str[i])
                    s[k++] = str[i++];
#  ifndef GERMAN
                  if (is_b)
                   {
                     sprintf(str, "%s", day_suffix ((Sint)diff));
                     i = 0;
                     while (str[i])
                       s[k++] = str[i++];
                   }
#  endif
                }
               else
                 if (   (*(ptr_char + j) == ' ')
                     && (s[k-1] == ' '))
                   k--;
             }
            else
              if (   (*(ptr_char + j) == ' ')
                  && (s[k-1] == ' '))
                k--;
            while (*(ptr_char + j))
              s[k++] = *(ptr_char + j++);
            s[k] = '\0';
            strcpy(tmp_buffer, s);
            ptr_char = tmp_buffer;
          }
       }
      i = year;
      do
       {
         sprintf(s, "%04d%02d%02d%s", year, m, d, ptr_char);
         rc_buffer[*rc_elems] = (Schar *)(malloc(strlen(s)+1));
         if (rc_buffer[*rc_elems] == NULL)
          {
#  ifdef GERMAN
            fprintf(stderr, "`%s' Zeile %d: malloc() hat versagt.\n",
                    __FILE__, __LINE__);
#  else /* !GERMAN */
            fprintf(stderr, "`%s' line %d: malloc() fails.\n",
                    __FILE__, __LINE__);
#  endif /* !GERMAN */
            exit(252);
          }
         else
           strcpy(rc_buffer[(*rc_elems)++], s);
         next_date (&d, &m, &year);
       } while (--print_two_times); /* I don't like the GNU-coding scheme for do-while's */
      year = i;
    }
   if (save_year)
     year = save_year;
}
#
#
#
static void
rc_use (void)
/*
   Processes the resource file and prints the valid appointments found
   resp.,  prints valid appointments of (internal)holiday list
*/
{
   auto     FILE   *fp;
   register Sint    wd=weekday_of_date (act_day, act_month, act_year);
   register Sint    ed;
   register Sint    i;
   auto     Sint    line=0;
   auto     Sint    rc_elems=0;
   static   Schar  *ptr_env;
   auto     Schar  *tmp_buffer=(Schar *)malloc(BUFSIZ+1);
   auto     Schar  *ptr_char;


   if (tmp_buffer == NULL)
    {
#  ifdef GERMAN
      fprintf(stderr, "`%s' Zeile %d: malloc() hat versagt.\n",
              __FILE__, __LINE__);
#  else /* !GERMAN */
      fprintf(stderr, "`%s' line %d: malloc() fails.\n",
              __FILE__, __LINE__);
#  endif /* !GERMAN */
      exit(252);
    }
   fp = fopen(PRGR_RC_NAME, "r");
   if (fp == NULL)
    {
#  ifdef ATARI
      *tmp_buffer = '\0';
      *ptr_env = '\0';
#  else /* !ATARI */
      ptr_env = (Schar *)getenv(HOME_PATH);
      if (ptr_env != NULL)
#  endif /* !ATARI */
       {
#  ifdef MSDOS
         auto Bool  ok=FALSE;


         strcpy(tmp_buffer, ptr_env);
         while (   !ok
                && (fp == NULL))
          {
            ok = (Bool)((ptr_char=strstr(tmp_buffer, PATH_SEP)) == NULL);
            i = strlen(tmp_buffer) - strlen(ptr_char);
            strcpy(s, tmp_buffer);
            s[i] = '\0';
            ptr_char = strrchr(s, *DIR_SEP);
            if (strlen(ptr_char) > 1)
              strcat(s, DIR_SEP);
            strcat(s, PRGR_RC_NAME);
            strcpy(tmp_buffer, tmp_buffer+i+1);
            if (!*tmp_buffer)
              ok = TRUE;
            fp = fopen(s, "r");
          }
#  else /* !MSDOS */
         strcpy(tmp_buffer, ptr_env);
         strcat(tmp_buffer, DIR_SEP);
         strcat(tmp_buffer, PRGR_RC_NAME);
         fp = fopen(tmp_buffer, "r");
#  endif /* !MSDOS */
       }
    }
   ed=day = day_of_year (act_day, act_month, act_year);
   if (   rc_week_flag
       || rc_month_flag
       || rc_year_flag)
    {
      if (rc_week_flag)
       {
         if (rc_backwards_flag)
           ed -= DAY_MAX;
         ed += SDAY(DAY_MAX-wd+1, start_day);
       }
      else
        if (rc_month_flag)
         {
           if (rc_backwards_flag)
             ed = day_of_year (1, act_month, act_year);
           else
            {
              if (act_month < MONTH_MAX)
                ed = day_of_year (1, act_month+1, act_year);
              else
                ed = 365 + is_leap_year + 1;
            }
         }
        else
         {
           if (rc_backwards_flag)
             ed = 1;
           else
             ed = 365 + is_leap_year + 1;
         }
      /*
         Swap
      */
      if (rc_backwards_flag)
        day ^= ed ^= day ^= ed;
    }
   /*
      Now include the (internal)holidays, which are valid appointments,
        into `rc_buffer'
   */
   if (rc_enable_hd_flag)
     while (   (hd_buffer[line] != NULL)
            && (line < HD_ELEMS_MAX))
      {
        strcpy(tmp_buffer, hd_buffer[line]);
        i = LEN_HD_NAME + 7;
        tmp_buffer[i] = '\0';
        i--;
        while (   i
               && isspace(tmp_buffer[i]))
          tmp_buffer[i--] = '\0';
        if (   (i > 7)
            && (rc_elems < RC_ELEMS_MAX))
          rc_check (tmp_buffer, s, &line, &rc_elems, day, ed, wd);
        if (!holiday_flag)
         {
           free(hd_buffer[line]);
           hd_buffer[line] = NULL;
         }
        line++;
      }
   /*
      Now read and check contents of resource file
        and include valid appointments into `rc_buffer'
   */
   if (fp != NULL)
    {
      line = 0;
      while (   (rc_elems < RC_ELEMS_MAX)
             && rc_read_line (fp, tmp_buffer, &line))
        if (*tmp_buffer)
          rc_check (tmp_buffer, s, &line, &rc_elems, day, ed, wd);
    }
   /*
      Now print the valid resource file items in sorted order
   */
   if (rc_elems)
    {
      register Sint  len=(rc_julian_flag&&!both_dates_flag)?3:2;
      register Sint  j;
      register Sint  d;


      if (rc_elems > 1)
       {
         if (rc_sort_des_flag)
           qsort((void **)rc_buffer, rc_elems, sizeof *rc_buffer, (Func_cmp)des_sort);
         else
           qsort((void **)rc_buffer, rc_elems, sizeof *rc_buffer, (Func_cmp)asc_sort);
       }
      S_NEWLINE(stdout);
      for (line=0 ; line < rc_elems ; line++)
       {
         ptr_char = rc_get_date (rc_buffer[line], s, &day, &month, &year);
         d = day;
         if (rc_julian_flag)
           d = day_of_year (day, month, year);
         j=wd = 0;
         j += fprintf(stdout, "%s, ",
                      short_day_name (weekday_of_date (day, month, year)));
#  ifdef GERMAN
         if (   highlight_flag
             && (year == act_year)
             && (month == act_month)
             && (day == act_day))
          {
            j += 2;
#    ifdef ANSISYS
            if (   both_dates_flag
                && rc_julian_flag)
             {
               fprintf(stdout, "%s%2d(%3d)%s ", L_MARKER, day, d, R_MARKER);
               j += 7;
             }
            else
             {
               fprintf(stdout, "%s%*d%s ", L_MARKER, len, d, R_MARKER);
               j += len;
             }
#    else /* !ANSISYS */
            if (   both_dates_flag
                && rc_julian_flag)
             {
               fprintf(stdout, "%s%2d(%3d)%s", L_MARKER, day, d, R_MARKER);
               j += 7;
             }
            else
             {
               fprintf(stdout, "%s%*d%s", L_MARKER, len, d, R_MARKER);
               j += len;
             }
#    endif /* !ANSISYS */
          }
         else
          {
            if (   highlight_flag
                && *holiday_vector[month-1])
              for (i=0 ; holiday_vector[month-1][i] ; i++)
                if (holiday_vector[month-1][i] == ((both_dates_flag)?day:d))
                 {
                   wd = day;
                   break;
                 }
            if (wd)
             {
               j += 2;
#    ifdef ANSISYS
               if (   both_dates_flag
                   && rc_julian_flag)
                {
                  fprintf(stdout, "%s%2d(%3d)%s ", L_HMARKER, day, d, R_HMARKER);
                  j += 7;
                }
               else
                {
                  fprintf(stdout, "%s%*d%s ", L_HMARKER, len, d, R_HMARKER);
                  j += len;
                }
#    else /* !ANSISYS */
               if (   both_dates_flag
                   && rc_julian_flag)
                {
                  fprintf(stdout, "%s%2d(%3d)%s", L_HMARKER, day, d, R_HMARKER);
                  j += 7;
                }
               else
                {
                  fprintf(stdout, "%s%*d%s", L_HMARKER, len, d, R_HMARKER);
                  j += len;
                }
#    endif /* !ANSISYS */
             }
            else
             {
               if (   both_dates_flag
                   && rc_julian_flag)
                 j += fprintf(stdout, " %2d(%3d) ", day, d);
               else
                 j += fprintf(stdout, " %*d ", len, d);
             }
          }
         j += fprintf(stdout, "%s %04d: ",
                      (rc_julian_flag&&!both_dates_flag)
                      ? "Tag"
                      : short_month_name (month), year);
#  else /* !GERMAN */
         j += fprintf(stdout, "%s%s",
                      (rc_julian_flag&&!both_dates_flag)
                      ? ""
                      : short_month_name (month),
                      (rc_julian_flag&&!both_dates_flag)
                      ? ""
                      : " ");
         if (   highlight_flag
             && (year == act_year)
             && (month == act_month)
             && (day == act_day))
          {
            j += 5;
#    ifdef ANSISYS
            if (   both_dates_flag
                && rc_julian_flag)
             {
               fprintf(stdout, "%s%2d%s(%3d)%s ",
                       L_MARKER, day, day_suffix (day), d, R_MARKER);
               j += 7;
             }
            else
             {
               fprintf(stdout,"%s%*d%s%s ",
                       L_MARKER, len, d, day_suffix (d), R_MARKER);
               j += len;
             }
#    else /* !ANSISYS */
            if (   both_dates_flag
                && rc_julian_flag)
             {
               fprintf(stdout, "%s%2d%s(%3d)%s",
                       L_MARKER, day, day_suffix (day), d, R_MARKER);
               j += 7;
             }
            else
             {
               fprintf(stdout, "%s%*d%s%s",
                       L_MARKER, len, d, day_suffix (d), R_MARKER);
               j += len;
             }
#    endif /* !ANSISYS */
          }
         else
          {
            if (   highlight_flag
                && *holiday_vector[month-1])
              for (i=0 ; holiday_vector[month-1][i] ; i++)
                if (holiday_vector[month-1][i] == ((both_dates_flag)?day:d))
                 {
                   wd = day;
                   break;
                 }
            if (wd)
             {
               j += 5;
#    ifdef ANSISYS
               if (   both_dates_flag
                   && rc_julian_flag)
                {
                  fprintf(stdout, "%s%2d%s(%3d)%s ",
                          L_HMARKER, day, day_suffix (day), d, R_HMARKER);
                  j += 7;
                }
               else
                {
                  fprintf(stdout, "%s%*d%s%s ",
                          L_HMARKER, len, d, day_suffix (d), R_HMARKER);
                  j += len;
                }
#    else /* !ANSISYS */
               if (   both_dates_flag
                   && rc_julian_flag)
                {
                  fprintf(stdout, "%s%2d%s(%3d)%s",
                          L_HMARKER, day, day_suffix (day), d, R_HMARKER);
                  j += 7;
                }
               else
                {
                  fprintf(stdout, "%s%*d%s%s",
                          L_HMARKER, len, d, day_suffix (d), R_HMARKER);
                  j += len;
                }
#    endif /* !ANSISYS */
             }
            else
             {
               if (   both_dates_flag
                   && rc_julian_flag)
                 j += fprintf(stdout, " %2d%s(%3d) ", day, day_suffix (day), d);
               else
                 j += fprintf(stdout, " %*d%s ", len, d, day_suffix (d));
             }
          }
         j += fprintf(stdout,"%s%04d: ",
                      (rc_julian_flag&&!both_dates_flag)
                      ? "day "
                      : "", year);
#  endif /* !GERMAN */
         /*
            Print appointment text now
         */
         while (*ptr_char)
          {
            if (*ptr_char == RC_NL_CHAR)
             {
               S_NEWLINE(stdout);
               for (i=0 ; i < j ; i++)
                 fputc(' ', stdout);
             }
            else
              fputc(*ptr_char, stdout);
            ptr_char++;
          }
         S_NEWLINE(stdout);
         free(rc_buffer[line]);
         rc_buffer[line] = NULL;
       }
      if (fp != NULL)
        fclose(fp);
    }
   free(tmp_buffer);
}
#endif /* USE_RC */
#
#
#
#ifndef GERMAN
static const Schar
*day_suffix (Sint day)
/*
   Returns the ordinal suffix (st, nd, rd or th) which is
     added to a single day number using the format %-3s
*/
{
   static   const Schar  *suffix[]={"'th", "'st", "'nd", "'rd"};
   register       Sint    i=0;


/*
   Necessary for numbers >999

   if (day > 10000)
     day %= 10000;
   if (day > 1000)
     day %= 1000;
*/
   if (day > 100)
     day %= 100;
   if (   day < 11
       || day > 13)
     i = day % 10;
   if (i > 3)
     i = 0;

   return(suffix[i]);
}
#endif /* !GERMAN */
#
#
#
static const Schar
*short_day_name (const Sint day)
/*
   Returns the short name of the day using the format %-2s
*/
{
#ifdef GERMAN
   static const Schar  *name[]={
                                 "ung"UE"ltiger Tag",
                                 "Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"
                               };
#else /* !GERMAN */
   static const Schar  *name[]={
                                 "invalid day",
                                 "Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"
                               };
#endif /* !GERMAN */


   return((   day < DAY_MIN
           || day > DAY_MAX)
          ? name[0]
          : name[day]);
}
#
#
#
static const Schar
*day_name (const Sint day)
/*
   Returns the whole name of the day
*/
{
#ifdef GERMAN
   static const Schar  *name[]={
                                 "ung"UE"ltiger Tag",
                                 "Montag", "Dienstag", "Mittwoch", "Donnerstag",
                                 "Freitag","Samstag", "Sonntag"
                               };
#else /* !GERMAN */
   static const Schar  *name[]={
                                 "invalid day",
                                 "Monday", "Tuesday", "Wednesday", "Thursday",
                                 "Friday", "Saturday", "Sunday"
                               };
#endif /* !GERMAN */


   return((   day < DAY_MIN
           || day > DAY_MAX)
          ? name[0]
          : name[day]);
}
#
#
#
static const Schar
*short_month_name (const Sint month)
/*
   Returns the whole name of the month using the format %-3s
*/
{
#ifdef GERMAN
   static const Schar  *name[]={
                                 "ung"UE"ltiger Monat",
                                 "Jan", "Feb",
#  ifdef EXT_ASCII
                                 "M"AE"r",
#  else /* !EXT_ASCII */
                                 "M"AE,
#  endif /* !EXT_ASCII */
                                 "Apr", "Mai", "Jun", "Jul", "Aug",
                                 "Sep", "Okt", "Nov", "Dez"
                               };
#else /* !GERMAN */
   static const Schar  *name[]={
                                 "invalid month",
                                 "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
                               };
#endif /* !GERMAN */


   return((   month < MONTH_MIN
           || month > MONTH_MAX)
          ? name[0]
          : name[month]);
}
#
#
#
static const Schar
*month_name (const Sint month)
/*
   Returns the whole name of the month
*/
{
#ifdef GERMAN
   static const Schar  *name[]={
                                 "ung"UE"ltiger Monat",
                                 "Januar", "Februar", "M"AE"rz", "April", "Mai",
                                 "Juni", "Juli", "August", "September",
                                 "Oktober", "November", "Dezember"
                               };
#else /* !GERMAN */
   static const Schar  *name[]={
                                 "invalid month",
                                 "January", "February", "March", "April", "May",
                                 "June", "July", "August", "September",
                                 "October", "November", "December"
                               };
#endif /* !GERMAN */


   return((   month < MONTH_MIN
           || month > MONTH_MAX)
          ? name[0]
          : name[month]);
}
#
#
#
#ifdef USE_RC
static void
prev_date (Sint *day,
           Sint *month,
           Sint *year)
/*
   Sets a given date to yesterdays date
*/
{
   (*day)--;
   if (   !*day
       || !valid_date (*day, *month, *year))
    {
      (*month)--;
      if (*month < MONTH_MIN)
        *month = MONTH_MAX, (*year)--;
      *day = 31;
      while (!valid_date (*day, *month, *year))
        (*day)--;
    }
}
#
#
#
static void
next_date (Sint *day,
           Sint *month,
           Sint *year)
/*
   Sets a given date to tomorrows date
*/
{
   (*day)++;
   if (!valid_date (*day, *month, *year))
    {
      *day = 1;
      if (*month == MONTH_MAX)
        *month = 1, (*year)++;
      else
        (*month)++;
    }
}
#
#
#
static Bool
valid_date (const Sint day,
            const Sint month,
            const Sint year)
/*
   Checks whether a delivered date is valid
*/
{
   if (   day < 0
       || day > 31
       || month < MONTH_MIN
       || month > MONTH_MAX
       || (   (day > 30)
           && (   month == 4
               || month == 6
               || month == 9
               || month == 11))
       || (   (day > days_of_february (year))
           && (month == 2)))
     return(FALSE);

   return(TRUE);
}
#endif /* USE_RC */
#
#
#
static Sint
weekday_of_date (const Sint day,
                 const Sint month,
                 const Sint year)
/*
   Computes the weekday of a gregorian/julian date
     and returns 1..7 ; 1==mo, 2==tu...7==su
*/
{
   if (year > GREG_YEAR)
    {
      register Sint  yearfact=year+(month-14)/12;


      yearfact = ((13 * (month + 10 - (month + 10) / 13 * 12) - 1) / 5
                   + day + 77 + ((5 * (yearfact % 100)) >> 2)
                   + yearfact / 400 - ((yearfact / 100) << 1)) % 7;
      return((yearfact)
             ? abs(yearfact)
             : 7);
    }
   else
    {
      auto           Ulint  julian_days;
      register       Sint   i;
      static   const Sint   dvec[]={
                                     31, 28, 31, 30, 31, 30,
                                     31, 31, 30, 31, 30, 31
                                   };


      julian_days = (Ulint)((year - 1) * 365UL + ((year - 1) >> 2));
      if (   (days_of_february (year) == 29)
          && (  (   (month == 2)
                 && (day == 29))
              || month > 2))
        julian_days++;
      for (i=1 ; i < month ; i++)
        julian_days += (Ulint)(dvec[i-1]);
      if (year == GREG_YEAR)
        if (   month > GREG_MONTH
            || (   (month == GREG_MONTH)
                && (day > GREG_L_DAY)))
          julian_days -= (Ulint)(GREG_L_DAY-GREG_F_DAY+1);
      julian_days += day;
      julian_days %= 7;

      return((julian_days > 2)
             ? (Sint)(julian_days - 2)
             : (Sint)(julian_days + 5));
    }
}
#
#
#
static Sint
day_of_year (const Sint day,
             const Sint month,
             const Sint year)
/*
   Computes the day of the year of a delivered date
*/
{
   static const Sint  mvec[]={
                                 0,  31,  59,  90, 120, 151,
                               181, 212, 243, 273, 304, 334
                             };


   if (month < 3)
     return(mvec[month-1]+day);

   return(mvec[month-1]+day+(days_of_february (year) == 29));
}
#
#
#
static Sint
days_of_february (const Sint year)
/*
   Computes the number of days in february and returns them
*/
 {
   return((year > GREG_YEAR)
          ? (year & 3)
            ? 28
            : (   year % 100
               || !(year % 400))
              ? 29
              : 28
          : (year & 3)
            ? 28
            : 29);
}
#
#
#
static Sint
gauss_easter_formula (const Sint year)
/*
   Computes the day of easter sunday in a gregorian year
     using gauss's easter formular
*/
{
   register Sint  i;
   register Sint  j;
   register Sint  a;
   register Sint  b;
   register Sint  d;
   register Sint  m;


   i = year / 100 - year / 400 + 4;
   j = i - year / 300 + 11;
   a = (((year % 19) * 19) + j) % 30;
   b = ((((year & 3) << 1) + (year << 2) + (6 * a) + i) % 7) + a - 9;
   if (b < 1)
    {
      d = 31 + b;
      m = 3;
    }
   else
    {
      if (   (b == 26)
          || (   (a == 28)
              && (b == 25)
              && ((11*(j+1)%30) < 19)))
        b -= 7;
      d = b;
      m = 4;
    }

   return(day_of_year (d, m, year));
}
