/************************************************************************
				TETRIX
************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <mem.h>
#include <time.h>
#include <alloc.h>
#include "getkey.h"
#include "sound_fx.h"

#pragma inline

#define MOVEVRAM  Mcopy(vram,ver_ram);

#define BYTE unsigned char
#define WORD unsigned int


void init_game(void);
void Background(int);
int Game(int);
void Hall_of_Fame(void);
void Make_Score_board(void);
void Ready(void);
void BBBonus(void);
void bonus_bar(void);
void Clear(BYTE *,BYTE );
void mode ( int );
void pset ( int,int,char);
void SetPal ( BYTE *, int, int );
void LineDec ( int , int, FILE * );
int ldPCX (char *);
void Get_image(int,int,int,int,BYTE *);
void Put_image(int,int,int,int,BYTE *);
void brightCtrl(BYTE,int,BYTE *,BYTE *,BYTE *,int);
void getrgb(BYTE,int,BYTE *,BYTE *,BYTE *b);
void Fade_in(void);
void Fade_out_half(void);
void Fade_out(void);
void Error(char *);
void setOldKBDInt(void);
void Mcopy(BYTE far *,BYTE far *);
void Makearray(int x ,int y,int num,char *data);
void Settile(void);
int checkLine(int li);
int checkTop(void);
void Dead(void);
void nextBlock(char *data,int num);
int Choose_Level(void);
void gotodos(void);
void Show_score(void);
void Show_line(void);
void Show_line_level(int My);
int Test(int,int,char *);
void Hall_of_Fame(void);

typedef struct {
	char manufacturer;
	char version;
	char encoding;
	char bpp;
	int xmin,ymin;
	int xmax,ymax;
	int hres;
	int vres;
	char palette[48];
	char reserved;
	char color_planes;
	int bpl;
	int palette_type;
	char fill[58];
} PCXHDR;



char *block[7][4]={
	{"42220","13330","42220","13330"},
	{"24340","13230","24340","13230"},
	{"42320","31210","42320","31210"},
	{"423120","132430","421320","134230"},
	{"24430","13320","42210","31140"},
	{"42230","31120","24410","13340"},
	{"2340","2340","2340","2340"} };


BYTE far *vram=(BYTE far *)0xa0000000L;
BYTE far *ver_ram;                    /* virtual vram   */
BYTE far *ver_ram_1;
BYTE Pal[768];
BYTE R[256],G[256],B[256];             /* temporary palette */
BYTE *shape[13];                        /* block shape 1-6 */
BYTE *wall[4];
BYTE *Number[10];
BYTE *AlphaB[30];
BYTE *AlphaP[30];
BYTE *Bak_[2];
BYTE *Box[4];
BYTE *Back_lucky[2];
BYTE *inver_block[2];
BYTE *hammer;
BYTE *B_bonus[2];


BYTE High_score_name[5][10]={{ 6, 0,12, 4,29,29,29,29,29,29},
			     {29,29,29,29,18, 2, 7,14,14,11},
			     { 6, 0,12, 4,29,29,29,29,29,29},
			     {29,29,29,29,18, 2, 7,14,14,11},
			     { 6, 0,12, 4,29,29,29,29,29,29}};

unsigned long High_score_score[5]={123456,12345,1234,123,12};


BYTE ver_array[260],array[260];
BYTE a_array[260]={
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,
	10,10,10,10,10,10,10,10,10,10,10,10,10};


int str[114]={2, 7,14,14,18, 4,26,26,26,           //  -  choose...
	     22, 0,17,12,29,29,20,15,27,           //  -  warm   up!
	     29,16,20, 8, 2,10,24,27,29,           //  -  quicky!
	     29,20,15,29,29, 3,14,22,13,           //  -  up  down
	     18,14,12, 4,29,12,14,17, 4,           //  -  some   more
	     10, 4, 4,15,29, 2,14,14,11,           //  -  keep   cool
	      7,20,17,17,24,29,20,15,27,           //  -  hurry  up!
	     24,14,20,29, 6,14, 3,29,28,           //  -  you god?
	      6,14,29,19,14,29, 3,14,18,           //  -  go to dos
	      7, 0,11,11,29,14, 5,29, 5, 0,12, 4}; //  -  hall of fame


BYTE UP[13]={5,7,5,5,5,5,5,5,5,5,5,5,5};

int arrx,arry;
int rotate=0;
int rnd1,rnd2;
WORD line=0;

struct {
	  BYTE Repeat;
	  BYTE Rotat;
	  BYTE UpDown;
	  BYTE Rock;
	  BYTE Inverse;
	  unsigned long Score;
	  unsigned long score_one;
       }L[7]={{35, 0, 0, 0, 0, 300, 20},
	      {30, 0, 0, 0, 0, 700, 40},
	      {25, 0, 8, 0, 0,1100, 60},
	      {20, 8, 6, 4, 0,1600, 80},
	      {20, 5, 6, 5,12,2100,100},
	      {18, 3, 8, 6, 8,2600,120},
	      {16, 3, 5, 7, 6,3100,140}};


int _Rotate=0;
int _UpDown=0;
int _Rock=0;
int _Inverse=0;
BYTE ROtate_mem[19];

unsigned long MyScore=0l;
BYTE MyLevel;
WORD MyLine;
BYTE bonus;

int level_up_line;


/*******************************************************************
			MAIN SORCE..............TETRIX..................
********************************************************************/

void main()
{
 int CHoose,i,levelUP=99;
 setNewKBDInt();

 init_game();

 while(1)
 {
 if(levelUP==99){  bonus=0;
		   ldPCX("_back3.pcx");
		   MOVEVRAM
		   CHoose=Choose_Level();
		 }
 levelUP=0;
 if(CHoose==8) gotodos();

 memcpy(array,a_array,260);

 Background(CHoose-1);
 bonus_bar();
 Ready();
 levelUP=Game(CHoose-1);
 level_up_line=0;

 if(++CHoose>7)CHoose=1;
 }
}
/*******************************************************
		INIT_GAME .......TETRIX...........
*******************************************************/
void init_game(void)
{
  int i,j,k,tempR,tempG,tempB;
  bonus=0;

  mode(0x13);
  if(!(ver_ram=(BYTE far *)malloc(64000L)))
	Error("Error : Could not allocate memmory");

  if(!ldPCX("_back3.pcx"))
	Error("Error : Could not open font PCX file...");

  SetPal(Pal,0,256);
  getrgb(0,256,R,G,B);
  brightCtrl(0,256,R,G,B,0);
  MOVEVRAM
  Fade_in();

  _KBHIT=0;

  while(!_KBHIT)
  {
	 outportb(0x3c8,0);

	  tempR=R[0xb0];
	  tempG=G[0xb0];
	  tempB=B[0xb0];

	  for(k=0;k<15;k++)
	 {
	  R[0xb0+k]=R[0xb0+k+1];
	  G[0xb0+k]=G[0xb0+k+1];
	  B[0xb0+k]=B[0xb0+k+1];
	 }
	  R[0xbf]=tempR;
	  G[0xbf]=tempG;
	  B[0xbf]=tempB;

	 for(i=0;i<256;i++)
	 {
		 if(i!=255)for(k=0;k<1000;k++);

		 outportb(0x3c9,R[i]);
		 outportb(0x3c9,G[i]);
		 outportb(0x3c9,B[i]);
	 }
  }

  if(!ldPCX("block.pcx"))
	  Error("Error : Could not open block PCX file ....");

  for(i=0;i<9;i++)                   /*  Block * 9  ---shape[9]  */
  {
	shape[i]=(BYTE *)malloc(10*9);
	Get_image(i*10,0,10,9,shape[i]);
  }

  for(i=9;i<13;i++)
  {
	shape[i]=(BYTE *)malloc(10*9);
	Get_image((i-9)*10,10,10,9,shape[i]);
  }

  for(i=0;i<4;i++){                 /* wall *4   ----wall[4]  */
  wall[i]=(BYTE *)malloc(13*11);
  Get_image(90+i*13,0,13,11,wall[i]);
  }
  for(i=0;i<10;i++){                  /*   number *10  ----Number[10]  */
  Number[i]=(BYTE *)malloc(10*9);
  Get_image(i*10,29,10,9,Number[i]);
  }

  for(i=0;i<2;i++){                  /*   back board *2  ----Bak_[2]  */
  Bak_[i]=(BYTE *)malloc(12*127);
  Get_image(120+i*12,73,12,127,Bak_[i]);
  }

  Box[0]=(BYTE *)malloc(157*1);       /*   BOX  horizontal ----Box_[0]  */
  Get_image(127,66,157,1,Box[0]);
  Box[1]=(BYTE *)malloc(1*11);        /*   BOX   vertical ----Box_[1]  */
  Get_image(188,77,1,11,Box[1]);

  Box[2]=(BYTE *)malloc(157*1);       /*   BOX  horizontal ----Box_[2]  */
  Get_image(127,67,157,1,Box[2]);
  Box[3]=(BYTE *)malloc(1*11);        /*   BOX   vertical ----Box_[3]  */
  Get_image(189,77,1,11,Box[3]);


	j=0;
  for(k=0;k<3;k++)
	 for(i=0;i<10;i++){           /*   alphabet -purple *30  --- */
		AlphaP[j]=(BYTE *)malloc(10*9);
		Get_image(i*10,77+k*9,10,9,AlphaP[j++]);
	 }


	j=0;
  for(k=0;k<3;k++)
	 for(i=0;i<10;i++){           /*   alphabet -BLUE *30  --- */
		AlphaB[j]=(BYTE *)malloc(10*9);
		Get_image(i*10,48+k*9,10,9,AlphaB[j++]);
	 }

  for(i=0;i<2;i++){                   // Background for lucky number///
	Back_lucky[i]=(BYTE *)malloc(86*5);
	Get_image(112,26+i*5,86,5,Back_lucky[i]);
  }

  inver_block[0]=(BYTE *)malloc(65*9);
	Get_image(120,40,65,9,inver_block[0]);

  inver_block[1]=(BYTE *)malloc(65*9);
	Get_image(159,54,65,9,inver_block[1]);

  hammer=(BYTE *)malloc(130*14);
	Get_image(152,1,130,14,hammer);

  B_bonus[0]=(BYTE *)malloc(9*11);
	Get_image(223,21,9,11,B_bonus[0]);

  B_bonus[1]=(BYTE *)malloc(9*11);
	Get_image(234,21,9,11,B_bonus[1]);
}

/***********************************************************
		BACKGROUND...........TETIX...........
***********************************************************/
void Background(int lvl)
{
  BYTE i,j;
  int *a;
  BYTE rock[4][52]={{7,7,7,7,7,7,1,7,7,7,7,7,7,
		     7,7,7,7,7,2,2,2,7,7,7,7,7,
		     7,7,7,7,3,3,3,3,3,7,7,7,7,
		     7,7,7,4,4,4,4,4,4,4,7,7,7},
		    {7,7,1,1,1,7,7,7,1,1,1,7,7,
		     7,1,1,1,7,7,7,7,7,1,1,1,7,
		     1,1,7,7,7,7,7,7,7,7,7,1,1,
		     1,7,7,7,7,7,7,7,7,7,7,7,1},
		    {2,7,2,7,2,7,2,7,2,7,2,7,2,
		     7,2,7,2,7,2,7,2,7,2,7,2,7,
		     7,7,1,7,7,7,7,7,7,7,1,7,7,
		     7,7,1,7,7,7,7,7,7,7,1,7,7},
		    {7,7,1,7,7,1,7,7,1,7,7,7,7,
		     7,7,7,5,7,5,7,7,7,7,5,7,7,
		     7,6,7,7,7,7,7,6,7,7,7,6,7,
		     7,7,7,4,7,4,7,7,7,4,7,7,7}};
  a=str+lvl*9+9;

  if(L[lvl].Rock)
	 memcpy(array+195,rock[lvl-3],52L);

  if(!ldPCX("back.pcx")) Error("Error : not found PCX file...");

  for(j=0;j<9;j++)
	Put_image(15+j*10,170,10,9,AlphaB[*a++]);

  Show_score();
  Show_line();
  Show_line_level(0);

  randomize();
  rnd1=rand()%7;
  nextBlock(block[rnd1][0],rnd1);

  Settile();
  brightCtrl(0,256,R,G,B,0);
  MOVEVRAM
  Fade_in();
  SetPal(Pal,0,256);
  getrgb(0,256,R,G,B);
}
/****************************************************************
		GAME ............TETRIX................
****************************************************************/
int Game(int lv)
{
  int quitgame=1,i,j,k;
  BYTE INver=0;
  BYTE ttest=1;
  BYTE temp_bonus=0;

  arrx=6;
  arry=1;

  _Inverse=0;

  rnd2=rand()%7;

  INver=(L[lv].Inverse && (_Inverse>L[lv].Inverse));

 while(quitgame)
 {
  if(arry==1)
  {
	 nextBlock(block[rnd2][0],rnd2);
	if(Test(arrx,arry,block[rnd1][rotate]))
	 {
	  Dead();
	  if(MyScore>High_score_score[4])Make_Score_board();
	  Hall_of_Fame();
	  return 99;
	 }

  MyScore+=L[lv].score_one;
  Show_score();
  }

	for(i=0;i<L[lv].Repeat;i+=3)
	{
		if(INver)
		{
		 if(_KE[_LFARR]){
				 _KE[_LFARR]=0;
				 i--;
				 arrx++;
				 arrx-=Test(arrx,arry,block[rnd1][rotate]);
				}
		 if(_KE[_RGARR]){
				 _KE[_RGARR]=0;
				 i--;
				 arrx--;
				 arrx+=Test(arrx,arry,block[rnd1][rotate]);
				 }

		}
		 else
		 {
		  INver=0;
		  if(_KE[_LFARR]){
				 _KE[_LFARR]=0;
				 i--;
				 arrx--;
				 arrx+=Test(arrx,arry,block[rnd1][rotate]);
				}




		  if(_KE[_RGARR]){
				  _KE[_RGARR]=0;
				  i--;
				  arrx++;
				  arrx-=Test(arrx,arry,block[rnd1][rotate]);
				 }
		 }

		 if(_KE[_B]){ _KE[_B]=0;
						  if(bonus) BBBonus();
						}
		 if(_KE[_SPACE])
		 {
			 _KE[_SPACE]=0;
			 while(!Test(arrx,arry+1,block[rnd1][rotate]))
			 {
			  Makearray(arrx,++arry,rnd1,block[rnd1][rotate]);
			  Makearray(arrx,arry,7,block[rnd1][rotate]);
			 }
			  Makearray(arrx,arry,rnd1,block[rnd1][rotate]);
			  Settile();
			  MOVEVRAM
			  ttest=0;
			  break;
		 }
		if(_KE[_DWARR])
		{
		 _KE[_DWARR]=0;
		 arry++;
		 arry-=Test(arrx,arry,block[rnd1][rotate]);
		 S_Down();
		}

		 if(_KE[_UPARR])
		{
		 _KE[_UPARR]=0;
		 rotate++;
		 if(rotate>3)rotate=0;
		 rotate-=(Test(arrx,arry,block[rnd1][rotate]));
		 if(rotate<0)rotate=3;
		}

		 if(_KE[_ESC]) return 99;

		 Makearray(arrx,arry,rnd1,block[rnd1][rotate]);
		 Settile();
		 MOVEVRAM
		 Makearray(arrx,arry,7,block[rnd1][rotate]);

		ttest=1;
	}


		if(ttest)
		{

		  if(!Test(arrx,arry+1,block[rnd1][rotate]))/* Can down ? */
		  {

			S_Down();
			Makearray(arrx,++arry,rnd1,block[rnd1][rotate]);
			Settile();
			MOVEVRAM
			Makearray(arrx,arry,7,block[rnd1][rotate]);
		  }
		  else{
			Makearray(arrx,arry,rnd1,block[rnd1][rotate]);
			ttest=0;
		       }

		}

		if(!ttest)
		{
			S_Fall();
			Settile();
			MOVEVRAM

		  rnd1=rnd2;
		  rnd2=rand()%7;
		  rotate=0;
		  arrx=6;
		  arry=1;

		  memcpy(ver_array,array,247L);

		 for(j=0;j<19;j++)
		 {
		   if(checkLine(j))
		    {
		     MyLine++;
		     MyScore+=L[lv].Score;
		     Show_score();
		     Show_line();

		     level_up_line++;
		     Show_line_level(level_up_line);

		     if(INver){INver=0;
			  Put_image(158,4,65,9,inver_block[1]);
		    }
		     memcpy(array,ver_array,247L);
		     memcpy(ver_array+13,array,j*13L);
		     memset(ver_array,7,13L);
		     memcpy(array,ver_array,247L);

		     temp_bonus++;
		}
	       }
	       if(temp_bonus>2){
				bonus++;
				if(bonus<8)bonus_bar();
				 else bonus--;
			       }
		 temp_bonus=0;

		 if(level_up_line>14){
					Settile();
					MOVEVRAM
					return 1;
				      }

		  if(L[lv].Rotat &&(++_Rotate==L[lv].Rotat))
		  {
			  _Rotate=0;

			  for(i=0;i<19;i++)
				ROtate_mem[i]=*(array+i*13);

			  for(i=0;i<19;i++)
				 for(j=0;j<12;j++)
					 *(array+i*13+j)=*(array+i*13+j+1);

			  for(i=0;i<19;i++)
				  *(array+i*13+12)=ROtate_mem[i];

			  SoundEffect(60,300);
			  SoundEffect(200,80);
			  for(i=300;i<10;i-=10)
				 SoundEffect(5000-i,10);

			  for(i=300;i<400;i+=10)
				 SoundEffect(i,10);

			  Settile();
			  MOVEVRAM
		  }

		  if(L[lv].UpDown &&(++_UpDown==L[lv].UpDown))
		  {
		    _UpDown=0;
		    memcpy(ver_array,array,247L);
		    memcpy(array,ver_array+13,234L);
		    memcpy(array+234,UP,13);
		    for(i=10;i<110;i+=5) SoundEffect(i*10,20);
		    for(i=550;i<810;i+=5) SoundEffect(i,10);
		    Settile();
		    MOVEVRAM
		  }


		  INver=(L[lv].Inverse && (++_Inverse>L[lv].Inverse));

		 if(_Inverse==(L[lv].Inverse+1))
		 {
		    Put_image(158,4,65, 9,inver_block[0]);
		    Settile();
		    MOVEVRAM
		    for(i=0;i<5;i++)
			SoundEffect(30+i*10,50);

		    Put_image(158,4,65, 9,inver_block[1]);
		    Settile();
		    MOVEVRAM
		    SoundEffect(60,400);

		    Put_image(158,4,65, 9,inver_block[0]);
		    Settile();
		    MOVEVRAM
		    for(i=0;i<5;i++)
		     SoundEffect(200+i*3,10);

		    Put_image(158,4,65, 9,inver_block[1]);
		    Settile();
		    MOVEVRAM
		    Put_image(158,4,65, 9,inver_block[0]);
		   }
		}
  }
  return 0;
}
/**************************************************************
	 sub function for GAME
**************************************************************/
void Hall_of_Fame(void)
{
  int i,j;
  BYTE temp[5][8];

  if(!(ver_ram_1=(BYTE far *)malloc(64000L)))
	Error("Error : Could not allocate memmory ver_ram_1");

  Mcopy(ver_ram_1,ver_ram);
  Fade_out();

  ldPCX("hall.pcx");

  for(i=0;i<5;i++)
	for(j=0;j<10;j++)
	 Put_image(47+j*11,62+i*26,10,9,AlphaB[High_score_name[i][j]]);

  for(i=0;i<5;i++)
  sprintf(temp[i],"%07ld",(long)High_score_score[i]);

  for(i=0;i<5;i++)
	for(j=0;j<7;j++)
	 Put_image(175+j*11,62+i*26,10,9,Number[*(temp[i]+j)-48]);

  MOVEVRAM

  Fade_in();

  KBDWAIT

  Mcopy(ver_ram,ver_ram_1);

  farfree(ver_ram_1);
}

void Make_Score_board(void)
{
 int i,j,k=0;
 int x,y,ox,oy,cho,choose=0,nx=85;

 BYTE name[10];
 unsigned long temp_score;
 BYTE *temp=name;

 for(i=0;i<110;i+=2)
 {
  Put_image(150-i,30,12,127,Bak_[0]);
  Put_image(162+i,30,12,127,Bak_[1]);

    if(i%2)
    {
      SoundEffect(20+i*5,5);
      MOVEVRAM
    }
 }

 for(i=0;i<3;i++)
	for(j=0;j<10;j++)
	Put_image(87+j*15,50+i*20,10,9,AlphaP[k++]);

  x=ox=85,y=oy=49,cho=1;

 for(i=0;i<10;i++)
 {
  while(!choose)
  {
		Put_image(x,y,14,1,Box[0]);
		Put_image(x,y+10,14,1,Box[0]);
		Put_image(x,y,1,11,Box[1]);
		Put_image(x+14,y,1,11,Box[1]);
		 ox=x;
		 oy=y;

		MOVEVRAM

	  if(_KE[_DWARR])
			{ _KE[_DWARR]=0;
			 y+=20;
			 cho+=10;
			 if(y>89){ y-=20; cho-=10; }
			}

	 if(_KE[_UPARR])
			{ _KE[_UPARR]=0;
			 y-=20;
			 cho-=10;
			 if(y<49){ y+=20; cho+=10; }
			}

	  if(_KE[_RGARR])
			{ _KE[_RGARR]=0;
			 x+=15;
			 cho++;
			 if(x>222){ x-=15; cho--; }
			}

	 if(_KE[_LFARR])
			{ _KE[_LFARR]=0;
			 x-=15;
			 cho--;
			 if(x<85){ x+=15; cho++; }
			}

	  if(_KE[_ESC]) return;

	  if(_KE[_SPACE])
			{ _KE[_SPACE]=0;
				choose=cho;
			}

		Put_image(ox,oy,14,1,Box[2]);
		Put_image(ox,oy+10,14,1,Box[2]);
		Put_image(ox,oy,1,11,Box[3]);
		Put_image(ox+14,oy,1,11,Box[3]);
		MOVEVRAM
	}
	choose=0;
	nx+=12;

	for(k=0;k<10;k++)
	 SoundEffect(3100-k*100-(cho*60),10);

	Put_image(nx,120,10,9,AlphaB[cho-1]);

	MOVEVRAM
	*temp++=cho-1;
 }
	delay(500);

  for(i=0;i<10;i++)
	  High_score_name[4][i]=name[i];

  High_score_score[4]=MyScore;

 for(i=0;i<4;i++)
  for(j=i+1;j<5;j++)
	if(High_score_score[i]<High_score_score[j])
	{
		 temp_score=High_score_score[i];
		 High_score_score[i]=High_score_score[j];
		 High_score_score[j]=temp_score;

		 for(k=0;k<10;k++)
		 {
		  name[k]=*(High_score_name[i]+k);
		  *(High_score_name[i]+k)= *(High_score_name[j]+k);
		  *(High_score_name[j]+k)= name[k];
		 }
	 }
}

void Ready(void)
{
 int i;
 int CE=162;

 BYTE ss[6]={17,4,0,3,24,28};
 BYTE dd[10]={7,8,19,0,10,4,24,27};

 for(i=0;i<40;i+=2)
 {
   Put_image(CE,80-i,86,5,Back_lucky[0]);
   Put_image(CE,80+i,86,5,Back_lucky[1]);
 }

 for(i=0;i<6;i++)
  Put_image(CE+5+i*10,60,10,9,AlphaB[ss[i]]);

 _KBHIT=0;
 while(!_KBHIT)
 {
  for(i=0;i<8;i++)
	{
	 Put_image(CE+3+i*10,100,10,9,AlphaP[dd[i]]);
	 MOVEVRAM
	}

	for(i=0;i<10;i++)SoundEffect(600-i*10,10);

  for(i=0;i<8;i++)
   {
	Put_image(CE+3+i*10,100,10,9,AlphaB[dd[i]]);
	MOVEVRAM
   }
}
}
void BBBonus(void)
{
 int i,j=0;
 bonus--;

 for(i=0;i<128;i+=2)
 {
  Put_image(140,15+i,130,14,hammer);
  if(++j%2){ SoundEffect(420-i*2,10); MOVEVRAM}
 }

 memset(array,7,208);

  j=0;
 for(i=0;i<128;i++)
 {
  Put_image(140,144-i,130,14,hammer);
  if(++j%2){ SoundEffect(1000-i*10,5); MOVEVRAM}
 }

 bonus_bar();

 rnd1=rnd2;
 rnd2=rand()%7;
 rotate=0;
 arrx=6;
 arry=1;

 nextBlock(block[rnd2][0],rnd2);

 memcpy(ver_array,array,247L);
}

void bonus_bar(void)
{
 int i;


 for(i=0;i<bonus+1;i++)
  Put_image(272,22+i*13,9,11,B_bonus[1]);

 for(i=0;i<bonus;i++)
	Put_image(272,22+i*13,9,11,B_bonus[0]);
}
/******************************************************************
 load PCX file.....
 Put_image...
 Get_image...   etc...
*******************************************************************/
void pset ( int x,int y,char co)
{
	*(ver_ram+x+y*320) = co;
}

void mode (int mode)
{
	asm mov ax,mode;
	asm int 0x10;
}

void SetPal ( BYTE *p , int s, int cn )
{
	int i;
	while (!(inp(0x3da) & 8));
	for (i=0; i<cn; i++,s++)
	{
		outportb(0x3c8,s);
		outportb(0x3c9,(*p++)>>2 );
		outportb(0x3c9,(*p++)>>2 );
		outportb(0x3c9,(*p++)>>2 );
	}
}

int ldPCX ( char *name)
{
	FILE *fp;
	PCXHDR hdr;
	int xl,yl,y;
	if ( (fp=fopen(name,"rb"))!=NULL )
	{
		fread (&hdr,1,sizeof(PCXHDR),fp);

		xl = (hdr.xmax-hdr.xmin)+1;
		yl = (hdr.ymax-hdr.ymin)+1;

		for ( y=0; y<yl; y++ )
			LineDec ( xl,y,fp );

		fgetc(fp);
		fread (Pal,1,768,fp);
		fclose(fp);
		return 1;
	}
	return 0;
}

void LineDec ( int xl, int y, FILE *fp )
{
	int x=0,cnt;
	BYTE d;

	while ( x < xl ){
			 d=fgetc(fp);
			 if ( ( d & 0xc0 ) == 0xc0 )
			    {
				cnt = d & 0x3f;
				d = fgetc(fp);
				while ( cnt-- ) pset(x++,y,d);
			    }
			 else pset(x,y,d),x++;
			}
}
void getrgb(BYTE s,int n,BYTE *r,BYTE *g,BYTE *b)
{
	int i ;

	outportb(0x3c7,s) ;
	for ( i=0 ; i<n ; i++ )
	{
	  r[i]= inportb(0x3c9)   ;
	  g[i]= inportb(0x3c9)   ;
	  b[i]= inportb(0x3c9)   ;
	}
}
void brightCtrl(s,n,r,g,b,factor)
BYTE s,*r,*g,*b;
int n,factor ;
{
	int i;
	outportb(0x3c8,s) ;

	for ( i=0 ; i<n ; i++ )
	{

		outportb(0x3c9,(r[i] * factor)/100) ;
		outportb(0x3c9,(g[i] * factor)/100) ;
		outportb(0x3c9,(b[i] * factor)/100) ;
	}
}

void Fade_in()
{
	int i=0;
	for (; i<=100 ; i++ )
	{
		 while (!(inp(0x3da) & 8));
		 brightCtrl(0,256,R,G,B,i);
	}
}



void Fade_out_half(void)   // fade out from 0x20 to 0xff
{

  int i,j,k;
	for (i=100; i>=45 ; i-- )
	 {
		while (!(inp(0x3da) & 8));
		outportb(0x3c8,0);

		 for (j=0 ; j<256 ; j++ )
		 {
			k=i;
			if(j<32)k=100;

			outportb(0x3c9,(R[j] * k)/100) ;
			outportb(0x3c9,(G[j] * k)/100) ;
			outportb(0x3c9,(B[j] * k)/100) ;
		 }
	 }
}
void Fade_out()
{
	int i=100;
	for (; i>=0 ; i-- )
	 {
		while (!(inp(0x3da) & 8));
	  brightCtrl(0,256,R,G,B,i) ;
	 }
}
void Get_image(int xx,int yy, int xl,int yl,BYTE *image)
{
	asm{
	push ds
	push es

	lds  si,ver_ram
	add  si,xx
	mov  ax,yy
	xchg ah,al
	add  si,ax
	shr  ax,2
	add  si,ax

	les di,image
	mov cx,yl
	mov dx,xl
	mov bx,320
	sub bx,dx
		}
 LP1:
	asm{
	push cx
	mov  cx,dx
	rep  movsb
	pop  cx
	add  si,bx
	loop LP1

	pop es
	pop ds
		}
}
void Put_image(int xx,int yy,int xl,int yl,BYTE *image)
{
	asm{
	push ds
	push es

	les  di,ver_ram
	add  di,xx
	mov  ax,yy
	xchg ah,al
	add  di,ax
	shr  ax,2
	add  di,ax

	lds si,image
	mov cx,yl
	mov dx,xl
	mov bx,320
	sub bx,dx
		}
 LP:
	asm{
	push cx
	mov  cx,dx
	rep  movsb
	pop  cx
	add  di,bx
	loop LP

	pop es
	pop ds
		}
}
void Mcopy(BYTE far * dest,BYTE far *src)
{
  asm{
		push ds
		lds si,src
		les di,dest
		mov cx,32000
		rep movsw
		pop ds
	  }
}


void Clear(BYTE * con,BYTE color)
{
 asm{
	 les di,con
	 mov ax,color
	 mov ah,al
	 mov cx,32000
	 rep stosw
	}
}

void Error(char *a)
{
	mode(3);
	clrscr();
	printf("%s\n",a);
	setOldKBDInt();
	exit(1);
}
/********************************************************
	SUB_FUNCTION FOR MAIN.C   ----------  TETRIX
********************************************************/



void Makearray(int x ,int y,int num,char *data)
{
	 *(array+y*13+x)=num;

	 while(*data!='0')
	 {
		 if(*data=='1')y--;
	 else if(*data=='2')x++;
		else if(*data=='3')y++;
		  else x--;

		 *(array+y*13+x)=num;
		 data++;

	 }
}
void Settile(void)
{
 int i,j;

 for(i=0;i<13;i++)
  for(j=0;j<19;j++)
   Put_image(140+i*10,14+j*9,10,9,shape[*(array+j*13+i)]);
}

int Test(int x,int y,char *data)
{
  if (*(array+y*13+x)!=7) return 1;

	 while(*data!='0')
	 {
	   if(*data=='1')y--;
	     else if(*data=='2')x++;
		else if(*data=='3')y++;
		  else x--;
	   if(x<0) return 1;
	   if(x>12) return 1;

	   if(*(array+y*13+x)!=7) return 1;
		 data++;
	 }

	 return 0;
}


int checkLine(int li)
{
  int i;

  for(i=0;i<13;i++)
    if(*(array+li*13+i)==7) return 0;



  for(i=0;i<13;i++)
	*(array+li*13+i)=7;
	Settile();
	MOVEVRAM
	S_clr_line1();

  for(i=0;i<13;i++)
	*(array+li*13+i)=9;
	Settile();
	MOVEVRAM
	S_clr_line2();

  for(i=0;i<13;i++)
	*(array+li*13+i)=10;
	Settile();
	MOVEVRAM

	S_clr_line3();

  for(i=0;i<13;i++)
	*(array+li*13+i)=11;
	Settile();
	MOVEVRAM
  S_clr_line4();


  for(i=0;i<13;i++)
  *(array+li*13+i)=12;
  Settile();
  MOVEVRAM


  _UpDown=0;
  _Rotate=0;
  _Inverse=0;
  return 1;
}

int checkTop(void)
{
 int i;
 for(i=0;i<13;i++)
 {
  if(*(array+i)!=7) return 1;
 }
 return 0;
}

void Dead(void)
{
 int i,j;


 for(j=18;j>-1;j--)
 {
  for(i=0;i<13;i++)
	if(*(array+j*13+i)!=7) *(array+j*13+i)=8;
  S_Down();
  Settile();
  MOVEVRAM
 }
}


void nextBlock(char *data,int num)
{
	 int x,y;

	 for(x=0;x<4;x++)
	  for(y=0;y<3;y++)
		 Put_image(40+x*10,18+y*9,10,9,shape[7]);
	 x=55;
	 y=23;

	 if(num==0){ x=50; y=27; }
	 if(num==6){ x=50; y=23; }



	 Put_image(x,y,10,9,shape[num]);

	 while(*data!='0')
	 {
	     if(*data=='1')y-=9;
		 else if(*data=='2')x+=10;
		      else if(*data=='3')y+=9;
			  else x-=10;

	      Put_image(x,y,10,9,shape[num]);
	      data++;
	 }
}







void gotodos(void)
{
 mode(3);
 clrscr();
 printf("Hope to enjoy my program ..............\n");
 printf("\n\n\n\n Recreated by Kim Hongseok.....\n");
 printf("\n\n Thanks to  Go Deoksin .....\n");
 printf("            and Game School 2nd Everyone\n\n\n\n\n\n\n\n\n\n\n\n\n");

 setOldKBDInt();
 exit(1);
}


int Choose_Level(void)
{

  int i,j;
  int *a=str;
  int choose=0,x=80,y=70,xo,yo,cho=1;


  MyLevel=1;
  MyScore=0l;
  MyLine=0;


  Fade_out_half();


  Mcopy(ver_ram,vram);


	 for(i=0;i<110;i++)
	 {
	  Put_image(148-i,50,12,127,Bak_[0]);
	  Put_image(160+i,50,12,127,Bak_[1]);
	  if(!(i%3))
	  {
	   SoundEffect(3000-i*100,5);
	   MOVEVRAM
	  }
	 }

	for(i=0;i<9;i++)   //choose...
	 Put_image(100+i*13,60,10,9,AlphaB[*a++]);

	for(j=0;j<7;j++)    // warm up! --you God ?
	 for(i=0;i<9;i++)
		Put_image(120+i*9,71+j*10,10,9,AlphaP[*a++]);

	for(i=0;i<9;i++)  //go to dos
	  Put_image(117+i*9,141,10,9,AlphaB[*a++]);

	for(i=0;i<12;i++)  //hall of fame
	  Put_image(105+i*9,151,10,9,AlphaB[*a++]);


  for(i=1;i<8;i++)
  {
    Put_image(90,61+i*10,10,9,Number[i]);
    Put_image(99,61+i*10,10,9,AlphaP[26]);
  }
  MOVEVRAM

  while(!choose)
  {
	Put_image(x,y,157,1,Box[0]);
	Put_image(x,y+10,157,1,Box[0]);
	Put_image(x,y,1,11,Box[1]);
	Put_image(x+157,y,1,11,Box[1]);
	 xo=x;
	 yo=y;

	MOVEVRAM

     if(_KE[_DWARR])
		       { _KE[_DWARR]=0;
			 y+=10;
			 cho++;
			 if(y>150){ y=70; cho=1; }
			}

     if(_KE[_UPARR])
			{ _KE[_UPARR]=0;
			 y-=10;
			 cho--;
			 if(y<70){ y=150; cho=9; }
			}

     if(_KE[_SPACE])
			{ _KE[_SPACE]=0;
			  choose=cho;
			  if(choose==9)
			  {
			   choose=0;
			   Put_image(xo,yo,157,1,Box[2]);
			   Put_image(xo,yo+10,157,1,Box[2]);
			   Put_image(xo,yo,1,11,Box[3]);
			   Put_image(xo+157,yo,1,11,Box[3]);
			   Hall_of_Fame();
			   MOVEVRAM
			   Fade_out_half();
			   xo=x=80;
			   yo=y=70;
			   cho=1;
			  }
			}

     Put_image(xo,yo,157,1,Box[2]);
     Put_image(xo,yo+10,157,1,Box[2]);
     Put_image(xo,yo,1,11,Box[3]);
     Put_image(xo+157,yo,1,11,Box[3]);

     MOVEVRAM

    }
  return choose;
}
void Show_score(void)
{
 int i;
 char s[9]={0,};

 sprintf(s,"%08ld",MyScore);

  for(i=0;i<8;i++)
	Put_image(19+i*10,130,10,9,Number[*(s+i)-48]);
}

void Show_line(void)
{
 int i;
 char s[5]={0,};

 sprintf(s,"%04d",MyLine);

  for(i=0;i<4;i++)
	Put_image(40+i*10,95,10,9,Number[*(s+i)-48]);
}
void Show_line_level(int My)
{
  int i;
  char s[3]={0,};

  sprintf(s,"%02d",My);

  for(i=0;i<2;i++)
	Put_image(50+i*10,71,10,9,Number[*(s+i)-48]);
}
