Welcome to DB2/2 V1.2.0!

Please refer to the publication, DB2/2 OS2/2 What's New Version 1.2,
for a description of changes between DB2/2 V1.0 and DB2/2 V1.2.

To begin, select an action from the pull-down menu.

CAUTION: If an existing version of ES 1.0 Database Manager or DB2/2 is
executing it should be stopped before you install DB2/2 V1.2.

CAUTION: If you are planning to use DDCS/2 V2 with this version
of DB2/2 on the same machine, you MUST use DDCS/2 V2.2.0.  Otherwise,
unpredictable results will occur.  DDCS/2 V2.0.1 or earlier versions of DDCS/2
are not compatible with this version of DB2/2 (V1.2.0.).

CAUTION: For client/server platforms, you should install the same
version of DB2/2 on all workstations.  In this case, it is V1.2.0.

If you are migrating from a previous version of database manager (ES 1.0
Database Manager or earlier), it is recommended that you backup your
databases before performing the DB2/2 V1.2 installation. No support is
provided for reverse migration.

If your migration to DB2/2 includes installing the base operating system,
moving to OS/2 2.0 or 2.1, or formatting your fixed disk you should record
the value of parameters in your present database manager configuration file
before proceeding with the installation.
Use this record to verify that the parameters in the DB2/2 database manager
configuration file are adequate for your specific application environment.

It is recommended that you backup migrated databases immediately after
they have been migrated.

If you are migrating 16-bit applications to 32-bit, we strongly recommend
you first read Appendix A, Migrating Applications in the Programming
Reference.

You can browse the README file here or print it; the file is on
diskette 1 and is called README.SQL.


The topics have been grouped in five categories.
What you'll find in this README file:

INSTALLATION
> Installing without a mouse - Key assignments
> "Not enough space" messages during Install
> DB2/2 Server and Communications Manager
> CID Install
> Remove function of the installation program
> Restoring a previous version of DBM (from installation backup)
> CAUTION: Using ES 1.0 REINST and ESCFG after installing DB2/2
> CAUTION: Install LOGO disappears

CONFIGURATION
> Running DOS or Windows clients on an OS/2 workstation
> SQLTRC for workstations not using NetBIOS
> Tuning NetBIOS Resources
> Shared memory required by each database
> DB2/2 Configuration Considerations for a DDCS/2 Multi-User Gateway

PROGRAMMING NOTES
> Exception Handling with C Set/2
> Stack Size for DB2/2 Applications (C Set/2)
> SQL INCLUDE Depth when Precompiling C or FORTRAN Programs
> WATCOM FORTRAN problem
> Signal Handler
> 16-bit Application Migration

ADMINISTRATION/GENERAL
> Importing IXF exported files
> Notes about Backing Up a Database
> Archiving Log Files Using the Sample User Exits
> Performance Considerations
> Migrating databases in an inconsistent state
> Restriction for the Creation of Databases

DOCUMENTATION UPDATES
> Online Command Reference
> DB2/2 Guide
> Programming Guide
> Programming Reference
> SQL Reference
> Guide
   Support for Down Level Clients (SQLLOO)
   Communications Session ID Considerations (SQLQMF)
> Messages and Problem Determination Guide

/**

INSTALLATION



===> Installing without a mouse - Key assignments

If you are installing DB2/2 without a mouse, help for key sequences is
available in WINDOW KEYS under "key assignments" in the OS/2 Master Help Index.


===> "Not enough space" messages during Install

 If you do not have much free space on your boot disk, one of the following
 messages may be displayed before install begins:

 DBI0016E: There is not enough space to perform the install request.
           C(*)
 DBI0104W: There may not be enough space to perform the install request.
           C(*)

 (*) - where C is the boot drive.

 The install program requires at least 2MB of free disk space on the
 boot drive in order for install to complete.  If you don't have UPM
 installed, an additional 0.8MB is required on the boot drive.   If
 you don't have FFST installed, add 0.5MB to the space requirement.

 You can cause temporary files to be created on another drive by
 specifying a command line parameter.  This will reduce the boot drive
 free space requirement by about 1.4MB.  To create temporary files on
 drive x, specify "/TMP:x" as a parameter on the DBINST command.

 In addition to these files, space on the boot drive may be used to
 recover from certain error conditions.  Approximately 1.4MB is needed
 for this purpose.  If you don't have enough space to handle error
 recovery, warning message DBI0104W will be displayed.   You can continue
 with the install despite the warning, but you may find that install fails
 at a later point.


===> DB2/2 Server and Communications Manager

 When installing a Server workstation, the installation program adds
 APPC DEFINE_TP entries to the active Communications Manager NDF file,
 if APPC is present on the workstation.
 If you install Communications Manager after DB2/2, rerun the DB2/2
 installation program (DBINST) as follows: DBINST /A
 The /A parameter causes the installation program to load, update the
 NDF file, and immediately exit.

 After the DEFINE_TP statements have been added, the configuration
 needs to be verified by Communications Manager.  This can be done
 from the command line.  The command to use depends on which version
 of Communications Manager you are working with.

 If you installed Extended Services 1.0 Communications Manager
 after installing DB2/2, you should enter the following from
 the OS/2 command line:

       APPNV <config_name>

 where <config_name> is the name of your active Communications
 Manager configuration.  Shutdown your machine and reboot to
 use the new configuration.

 If you installed Communications Manager/2 1.0 after installing
 DB2/2, you should enter the following from the OS/2 command line:

       CMVERIFY <config_name>

 where <config_name> is the name of your active Communications
 Manager configuration.  Shut down your machine and reboot to
 use the new configuration.


===> CID Install

 1) Change the directory structure where the product diskettes are copied
    for CID installs. To keep all DB2/2 related code in one subdirectory
    it is recommended you use the following convention:

      \CID\IMG\DB2\DB2SU
      \CID\IMG\DB2\DB2CS
      \CID\IMG\DB2\DB2CE

    instead of
      \CID\IMG\DB2SU
      \CID\IMG\DB2CS
      \CID\IMG\DB2CE
    as documented in the installation guide.

 2) During a CID install, the DBWorkstationName keyword is not
    necessary. However, when startdbm is issued, the Workstation
    name is required. You should issue
    "dbm update database manager configuration using nname xxx"
    where xxx is the workstation name.


===> Remove function of the installation program

 After using the REMOVE function of the DB2/2 Install program, you should
 reboot the workstation.  This will ensure that files that were in use at the
 time the removal was performed are deleted from the workstation.


===> Restoring a previous version of DBM (from installation backup)

 Install program's "Restore system from backup" function:

 Before restoring a previous version of DBM, it is recommended that
 you remove DB2/2.  Also, note that the restore function only restores
 files, not Desktop entries.  You will have to manually recreate the
 folder and program items for the previous version of DBM.

 - Locked file processing
 When restoring over an existing system, some files may be in use.
 These files will be restored, the next time the workstation is rebooted,
 by a device driver which is added to the CONFIG.SYS file.
 Therefore, it is recommended that you reboot the workstation before
 trying to use the restored system.


===> CAUTION: Using ES 1.0 REINST and ESCFG after installing DB2/2

 Do not use ES 1.0 REINST to perform operations that may affect the
 database manager after DB2/2 has been installed on a workstation.
 Also, be careful when using ES 1.0 ESCFG to create a basic configuration
 file on a workstation which has DB2/2 installed.   You may inadvertently
 replace DB2/2 with ES 1.0 DBM and unexpected results may occur.


===> CAUTION: Install LOGO disappears

 If the INSTALL LOGO flashes and the install program aborts after you
 type DBINST, you should configure your LOGO setting to NONE in the
 OS/2 SYSTEM SETUP.


/**

CONFIGURATION


===> Running DOS or Windows clients on an OS/2 workstation


 If you run a DOS or Windows client enabler on an OS/2 workstation, the
 DOS workstation name in the DBDRQLIB.CFG file must be different from the
 OS/2 workstation name in the DB2/2 configuration file.
 Each must be unique.


 If SQLLOGN2 or STARTDRQ fails, check that NetBIOS has adequate resources
 (to perform an add name to the NetBIOS name table), and check that NetBIOS
 is running properly.

 Note that if you are running a DOS or WINDOWS client enabler under
 OS/2, in order to use NetBIOS you must execute SETUPVDD
 (located in the IBMCOM directory).  This will add the necessary physical
 and virtual device drivers statements in your CONFIG.SYS to allow your
 DOS and WINDOWS programs to access the NetBIOS communications interface.
 This assumes that NetBIOS support has been installed and configured for
 the OS/2 environment prior to the execution of SETUPVDD.


===> SQLTRC for workstations not using NetBIOS

 If DB2/2 is installed on a workstation and NOT configured for NetBIOS and
 the DB2/2 "nname" configuration parameter has not been specified, SQLTRC
 may not continue to record DBM events after a STARTDBM command is issued.

 This is due to a non-fatal system error which occurs when DB2/2 attempts
 to initialize default NetBIOS resources when a STARTDBM command is being
 processed.  Depending on the SQLTRC command parameters, trace event logging
 may be halted after this non-fatal error occurs.

 This is working correctly as designed, and you should take appropriate steps
 necessary if you want additional DBM events to be traced after a STARTDBM in
 the case where NetBIOS is not configured.

 The workarounds include:
 1)  Issue SQLTRC ON command AFTER you issue the STARTDBM command.
 2)  When issuing the SQLTRC ON command, ensure that you increase the
     maximum system errors parameter (-e) to accommodate the non-fatal
     NetBIOS initialization errors at STARTDBM processing.
 3)  Install NetBIOS support (LAPS) and configure the DB2/2 "nname"
     parameter.


===> Tuning NetBIOS Resources

 If you are using the NetBIOS protocol with DB2/2, it is highly
 recommended that you refer to "Migrating Workstations to NetBIOS"
 in "Appendix A.  Migrating From Previous Releases" in the DB2/2 Guide.
 Note the usage of the SQLNETB and SQLNADPT tuning parameters.


===> Shared Memory required by each database

 DB2/2 allocates contiguous shared memory space based on the size specified
 for DB Heap, buffer pages, and lock list.

 When the first connection is established to a database, DB2/2 reserves
 shared memory objects depending on the following database configuration
 parameters:

 Database Heap Size  :  dheap    (64K segments)
 Buffer Page Size    :  buffpage (4K pages)
 Locklist            :  locklist (4K pages)

 The number of 64K segments required is derived from the following
 formula:

 Contiguous shared memory = (dbheap * 2) +
  (in 64K segments)         ((buffpage + 15) / 16) +
                            ((locklist + 15) / 16) + 3

 If the shared memory object is not available, DB2/2
 will return SQL1084C, "Database Manager segments cannot be allocated",
 indicating that sufficient memory is not available to process
 the connection.  If possible, decrease the amount of linear address
 space required by reducing the above configuration parameters,
 and attempt to connect to the database again.

 Due to memory fragmentation, it may be necessary to restart the
 operating system and DB2/2, and connect to the database
 before starting other applications on the system.

 If the problem persists, refer to the Messages and Problem
 Determination for other possible causes and actions.


===> DB2/2 Configuration Considerations for a DDCS/2 Multi-User Gateway

 Care must be taken when setting the NUMRC parameter in the database
 manager configuration on a DDCS/2 Multi-User Gateway machine.
 For DDCS/2 machines, NUMRC should NOT be set to the maximum number of
 expected remote clients, as with a normal server.

 Instead, NUMRC on the DDCS/2 machine should be set to
                        A + 2B + C
  where A = maximum number of local sessions to the host
        B = maximum number of remote sessions to the host
        C = maximum number of remote sessions to a database
            which is located on the DDCS/2 machine.

 This is because the DDCS/2 machine will require one communication heap
 for its connection to each remote client, and a second communication
 heap for the corresponding connection to the host.
 If you encounter SQLCODE -930 (insufficient communication heap) when
 trying to connect to the host via DDCS/2, the problem is more likely
 the NUMRC setting than the more obvious COMHEAPSZ setting.

/**

PROGRAMMING NOTES


===>  Exception Handling with C Set/2

 DB2/2 will not see any exceptions that occur while executing in the
 user's application code.
 If the user's application is built with C Set/2 Version 1, the potential
 exists for DB2/2 to commit transactions during abnormal termination if
 the following conditions are satisfied :

 i)  The C Set/2 exception handler is installed to handle
     exceptions in the user's application code.
 ii) A fatal exception occurs in the user's application code.

 The C Set/2 exception handler when processing the fatal exception
 masks the fatal termination code from the DB2/2 exit list function.
 This results in DB2/2 issuing a commit to terminate the current
 logical unit of work as opposed to rolling back the unit of work.

 There are two ways to avoid this problem:

 1) Register an exception handler via DosSetExceptionHandler to handle
    application exceptions.  This handler should explicitly issue a
    ROLLBACK or COMMIT. If you are running a multi-threaded program,
    only one of the threads should issue a ROLLBACK or COMMIT when
    there is an exception.

 2) Compile your C Set/2 application with the /Rn option.  C Set/2 will
    not register an exception handler with OS/2.  DB2/2 will be able
    to detect the exceptions.  However, if you use the /Rn option, your
    application is restricted to the C Set/2 subsystem runtime functions
    that are documented in the C Set/2 User's Guide.

 When there is a severe exception, such as access violation, a trap file
 will be generated under \SQLLIB directory. The trap file contains
 the instruction address where the problem occurred, the loading
 addresses of DB2/2 DLLs, and a snapshot of the stack content.
 The filename extension for these files is TRP.



===> Stack Size for DB2/2 Applications (C Set/2)

 The recommended minimum stack size is 32K for 32 bit OS/2 applications.
 If there are nested function calls in the applications, a larger stack
 size may be required.


===> SQL INCLUDE Depth when Precompiling C or FORTRAN Programs

 When precompiling C or FORTRAN host language programs on a DB2/2 client,
 the nesting depth of EXEC SQL INCLUDE files is currently limited by
 operating system resources.
 In practice, ten levels of nesting are possible, depending on what
 precompile options are in effect.
 If necessary, you may:
  1) Restructure the application program to nest SQL source files less
     deeply
  2) Precompile the application on the server, where the resource limits
     are much higher.


===> WATCOM FORTRAN problem

  There is a problem with the WATCOM F77/386 (32-bit) and F77 (16-bit) FORTRAN
  compilers which affects applications compiled with default optimization.
  WATCOM will be providing a fix in patch level 9.01f of both compilers.
  The problem occurs when character data is EQUIVALENCEd to non-character
  data (as when the SQL CONNECT TO statement is used.)  The workaround with
  earlier versions of the compiler is to disable optimization using the
  /OD flag.


===> Installing Signal Handlers

  If you are writing DB2/2 applications, it is strongly recommended that
  the application install the DB2/2 signal handler - the signal handler
  API is documented in the Programming Programming Reference, Chapter 1
  (APIs), pg 71.  Additionally, the Programming Guide (Chapter 1, Intro
  to DBM Programming, pp 8-12) illustrate working examples of C, COBOL,
  FORTRAN, and REXX applications that have installed the signal handler.


===> 16-bit Application Migration

 Existing 16-bit database applications can be migrated to the 32-bit DB2/2
 environment by simply re-binding each application to every database
 it uses.   Note the "Performance Considerations" section in this README
 file regarding 16-bit application performance.

 New (or modified) 16-bit OS/2 applications when compiled and linked
 must link to the SQLDYN16.LIB library (as the default SQL_DYN.LIB is
 now 32-bit).   See "Appendix A.  Migrating Applications" in the DB2/2
 Programming Reference, as well as "Linking" in Chapter 2 of the DB2/2
 Programming Guide, for more information.

/**

ADMINISTRATION/GENERAL


===> Importing IXF exported files

 Note that in IXF-importing an IXF-exported file with indexes in the
 same database using the CREATE option, the index file for the new table
 will not be created because the index object name already exists for
 the old table.

 For example:
 Consider table A1 with index I1_A1; exporting table A1 using the
 IXF option will contain the table definition and the associated index
 definition as well.  If you were to import this IXF file into another
 database using the CREATE option, a new table (with a name you can
 specify) will be created, and a new index with the name I1_A1 (same
 name as the original index for table A1) will be created also.
 However, IXF-importing (using CREATE - new table name is NEW_A1) to the
 SAME database will create the table but will NOT create the index since
 the index (I1_A1) already exists.   There is no option in the IMPORT
 command to allow you to provide an index name (as you do for a table),
 so the index file will obviously not be created.


===> Notes about Backing Up a Database

 When performing a CHANGES only backup:

 - You must use the same medium that was used for the most recent full
   backup.  For example:
   -- If your most recent full backup was put on drive D:, subsequent
      CHANGES only backups must also be put on drive D:
   -- If your most recent full backup was put on diskette, when you
      start subsequent CHANGES only backups, you must start by putting
      the first diskette of the full backup into the diskette drive.

 - You cannot call the user exit function (which also means that you
   cannot do a CHANGES only backup to tape).

 - You cannot back up a database enabled for roll-forward recovery.



===> Archiving Log Files Using the Sample User Exits

 If you use the sample user exits to archive the database log files
 you should be aware of the following potential problem.

 The log files are first copied to a staging area (temporary directory)
 before being copied to tape; if there is insufficient space, on the
 staging drive, the procedure will appear to "hang".  Free up space on
 the staging drive and processing will resume.


===> Performance Considerations

 User applications running in 16-bit mode should be converted to 32-bit
 to gain performance improvements on the OS/2 32-bit platform.
 DB2/2 utilities (for example: EXPORT) and user applications with
 floating-point manipulations will run faster on hardware that has
 a math co-processor (for example: 80387) installed.


===> Migrating databases in an inconsistent state

 Migration of databases in an inconsistent (i.e. crashed) state
 should not be attempted, as the results are unpredictable.  There are
 two different scenarios:

 1) The database is in a crashed state before issuing the migration
   request for the first time.

 2) The database crashed during migration, and you are reissuing the
   migration request.

 In either case, the migration may run to successful completion but
 the result is a corrupted database.  This result occurs when you
 migrate a database which started out in an inconsistent state.

 You are advised to do the following:

 1) Back up all your databases prior to installing DB2/2.  This is the
    same advice given in the past for installing new releases of the
    Database Manager, but is restated here as it pertains directly
    to this situation.  The backup will not be allowed for an
    inconsistent database, so successful completion of the backup
    means that both the live database and the backed up database are
    consistent.

 2) Install DB2/2.  If some time has elapsed between the time you
    backed up your databases and now, you may want to verify that
    none of your databases have since been used and left in a
    crashed state.  You can verify this by issuing a START USING
    DATABASE for each database.

 3) Migrate each database that is an ES 1.0 or earlier Database Manager
    database.  If the migration crashes, drop the database
    and restore it from your backup.  The restore will automatically
    migrate the database for you.  If the restore fails, reissue the
    restore request.

    By following these steps, you will ensure that your migrated database
    is consistent.



===> Restriction for the Creation of Databases

 DB2/2 does not support the creation of databases on LAN redirected
 drives.

/**

DOCUMENTATION Updates


===> DATABASE 2 OS/2 What's New Version 1.2

pg.25
  PKUNZIP is an OS/2 facility that can only be used in an OS/2
  environment.  Once you have completed the "cd" and "pkunzip" commands,
  you will need to copy files to the DOS environment before using the
  the files in point 2.

===> Online Command Reference

 In the Online Command Reference, the syntax diagram for the IMPORT command
 is incorrect.
 The line "---Messages msgfile---------select statement---|"
 should be removed.  It is not valid for the IMPORT command.  Refer to the
 hardcopy Command Reference for the correct syntax.


 In the DB2/2 Online Command Reference, the example for the MIGRATE
 command in the DBM Command Line Processor Commands section should read:
  DBM MIGRATE DATABASE SALES
 The password is no longer required.


===> DB2/2 Guide

pg. 96
  numrc (Estimated number of remote connections) depicts the maximum
  number of concurrent connections. When the number of connections reaches
  its maximum value, additional connections from remote workstation will
  result in an error.

pg. 262

  Descriptions of SQLxxxxx.EIX file should state "Damaged INX file ...",
  not "Damaged IDX file ...".


===> Programming Guide

pg. 7 Sample Programs

The instructions to expand the sample files are stated incorrectly.

From the root directory where SQLLIB resides, issue the following
command:

    PKUNZIP -d a:\samples.zip


pg. 139
  The bldmscsr.cmd file in SAMPLES.ZIP is correct.
  The bldmscsr.cmd file listed in the manual is wrong; the correct
  file is as follows:

  sqlprep %1.sqc %2 /p /b
  cl /c /Alfu /Zp /Lp /W3 /DSQL16TO32 %DEBUG% %1.c
  link /NOD /COD %1.obj,%1.dll,,sqldyn16+llibcdll+doscalls,%1.def;


===> Programming Reference

pg. 71
  The notes for INSTALL SIGNAL HANDLER should state:

  If an application has no signal handler installed and a <CTRL-C>
  or <CTRL-BREAK> is issued against the application, then one of the
  following occurs (depending on whether the application is local
  or remote):

    For a LOCAL application that is executing in the APPLICATION
    code (and not in the DB2/2 engine), that application is
    terminated.

    For a LOCAL application that is executing in the DB2/2 ENGINE,
    the database is marked as being in an inconsistent state.  As
    a result, that application and all other applications connected
    to the database are also terminated.

    For a REMOTE application (executing in the APPLICATION code,
    since the ENGINE resides on a remote server), that application
    is terminated.

  If the application is built with C Set/2, then refer to the
  notes on "Exception Handling with C Set/2".  Also, refer to the
  notes on "Installing Signal Handlers".

pg. 119
  The description for the STRUCT_ID field for the SQL_DIR_ENTRY
  data structure should read:
    "Structure identifier, which must be initialized to SQL_DCS_STR_ID."

pg. 120
  The description for the STRUCT_ID field for the SQL_NODE_STRUCT
  data structure should read:
    "Structure identifier, which must be initialized to SQL_NODE_STR_ID."

Pg. 123
  The description for the CUR_REQS field for the SQLEUSRSTAT
  data structure should read:
    "Number of SQL calls made since start of last transaction"

  The description for the TRANS_STATE field for the SQLEUSRSTAT
  data structure should read:
       "Transaction state. Possible values are:
           SQL_TRANS_STATE_STARTED ('S')
           SQL_TRANS_STATE_READ ('R')
           SQL_TRANS_STATE_CHANGED ('C')"

  The description for the LOCK_STATE field for the SQLEUSRSTAT
  data structure should read:
       "Transaction state. Possible values are:
              "SQL_LOCK_WAIT ('W')
               SQL_LOCK_NOWAIT ('N')"

pg. 147
  Figure 4 shows a syntax diagram which indicates the COMPUTATIONAL
  phrases are optional; they are not.

  The correct syntax diagram should show the stack containing the
  COMPUTATIONAL phrases connected to the main path, since this is
  a required choice.

pg. 341
  The following calling convention rule no longer applies and should
  be ignored:
   'Pass all other parameters by far address (full segment and offset)'.


===> SQL Reference

  The connection states are discussed in the CONNECT statement on
  page 128 of the SQL Reference.  To clarify the transition between
  implicitly connectable, and unconnectable and connected:

    When in an implicitly connectable state, an SQL statement other
    than CONNECT TO, CONNECT RESET, COMMIT, or ROLLBACK results in
    a transition to an unconnectable and connected state.
    A CONNECT TO, COMMIT, or ROLLBACK from an implicitly connectable
    state results in a transition to a connectable and connected state.


===> Guide

> Support for Down Level Clients (SQLLOO)

 The following highlights changes to Appendix A, 'Migrating from Previous
 Releases' in the DB2/2 Guide.  The complete text of the section on
 'Support for Down Level Clients' is shown below with changes marked
 with a '|' in the left margin.

    Down level database clients can access a DB2/2 database server using
 |  the APPC, NetBIOS or SQLLOO protocols currently supported in the
 |  database client products.  These down level clients include
 |  OS/2, DOS, and DOS Windows clients supported by Extended Services.

    Notes:
 |  1. It may be necessary to configure the NETWORK ID (or NETWORK NAME)
 |     of the SQLLOO clients in order for them to communicate with a
 |     DB2/2 Server which has ES 1.0 Communications Manager installed.
 |     Sessions can fail otherwise.   Sessions fail because EE 1.3
 |     did NOT require the NETWORK ID to be defined, whereas ES 1.0
 |     Communications Manager requires it.   The NETWORK ID should
 |     correspond between these two environments.   Many examples use
 |     "APPN" as the NETWORK ID.
 |
 |     It should also be noted that if you plan on reconfiguring your
 |     EE 1.3 SQLLOO clients for APPC, then you should uniquely define
 |     each client's local LU name.   Depending on how you configure
 |     the APPC connection to a DB2/2 Server with ES 1.0 CM, this may
 |     be important.   EE 1.3 did not require unique LU names whereas
 |     ES 1.0 Communications Manager requires unique LU names.  If an
 |     EE 1.3 client attempts to communicate to a DB2/2 Server with
 |     ES 1.0 Communications Manager installed and configured for APPC,
 |     and unique LU names have not been used, this may cause duplicate
 |     name errors to occur and alerts to be sent on the network.

 |  2. If your workstation was an EE 1.3 or Extended Services database
 |     server and provided SQLLOO support and if you no longer have any
 |     database clients which use the SQLLOO protocol, remove the
       following statement from the CONFIG.SYS file:

          DEVICE=X:\CMLIB\RDSLANDD.SYS

 |  3. To support Extended Edition Version 1.3 database clients using
 |     the SQLLOO protocol, you must be using the Communications Manager
 |     component of Extended Services on your DB2/2 Server.




> Communications Session ID Considerations (SQLQMF)

 In Chapter 10, 'Utilities for Moving Data' in the DB2/2 Guide, the first
 sentence in the section 'Communications Session ID Considerations'
 incorrectly states that a host ASCII terminal emulation session may be
 used to transfer data exported with QMF.  This sentence should read:

 "You can use any host 3270 terminal emulation session to transfer data
  exported with QMF."

/**

===> Messages and Problem Determination Guide

DBI0109W

   Message:  Help is unavailable.

     Cause:  The DB2/2 installation program help file is missing.

    Action:  Proceed without help or restore the help file (DBINST.HLP)
             from diskette 1 to the fixed disk directory from which the
             installation program is executing.


DBI0122W

   Message:  In order to install Query Manager, you must have the
             'Query Manager Distributed Feature' diskette.
             Do you want to continue?

     Cause: You selected to install the 'Query Manager Distributed Feature'.

    Action: Select Yes to continue if you have the
            'Query Manager Distributed Feature' diskettes or a copy of the
            distributed feature files in your source directory if you are
            installing from a hard disk; otherwise select No to return to
            the dialog and undo your selection.


DBM1013E

   Message:  Missing an optional keyword or value after the USING keyword.

     Cause:  A configuration keyword was specified without a value
             or the keyword and value were not separated by a space.

             The command cannot be processed.

     Action: Correct the error and issue the command again.


QRW2125N

   Message:  One or more foreign keys including "X" are duplicates
             of existing foreign keys and have not been created.

     Cause:  Database error.  See SQL0541.


QRW2272W

   Message:  A communication error "X" occurred while sending or receiving data
             from the remote database.  The database has been disconnected.

     Cause:  Database error.  See SQL30080N


SQL0013N

   Message:  An empty delimited identifier is not valid.

     Cause:  During precompilation, a cursor or statement name,
             specified as an empty string, was found.
             This is not valid.  The statement cannot be processed.

     Action: Provide a valid cursor or statement name.


SQL0107N

   Message:  The name "<name>" is too long.  The maximum
             length is "<length>".

     Cause:  The name returned as "<name>" is too long.  The maximum length
             permitted for names of that type is indicated by "<length>".

             The names for columns, tables, views, and indexes can be
             a maximum length of 18 bytes.  (This does not include any escape
             characters, if present.)

             A maximum of 18 bytes is permitted for a table, view or plan
             qualifier (authorization ID), plan name, or constraint name.

             Host variable names must not exceed 30 bytes in length.

             For the SQL CONNECT statement, an application server name of up to
             18 characters in length will be accepted at precompilation time.
             However, at runtime, an application server name which is greater
             than 8 characters in length will cause an error.

             The statement cannot be processed.

     Action: Choose a shorter name or correct the spelling of the object name.

      sqlcode:  -107
      sqlstate:  54003


SQL0332N

   Message:  There is no available conversion for the source
             code page %1 to the target code page %2.

     Cause:  No conversion of data is supported from the source code page to
             the target code page. This error can occur under two conditions:

               - An error has occurred executing an SQL statement.
                 The data cannot be processed by the Database Manager.
               - An error has occurred when trying to import or export
                 a WSF file. The import or export will fail.

     Action: Verify that both the source and target code page are supported
             by DB2/2. For DB2/2 code page support, check the Guide to DB2/2.

             If you are using Distributed Data Connection Services (DDCS),
             check the Guide to DDCS.  You must use code pages for which
             conversion tables are provided.  If possible, change the
             non-supported code page(s) to one of the documented pairs.

             If you are already using code pages for which conversion tables
             are supplied and are not doing an import or export,
             please contact your system programmer.


SQL0992C

   Message:  The release number of the precompiled program
             is not valid.

      Cause: The release number of the precompiled program (package)
             is not compatible with the release number of the installed
             version of DB2/2.

             The precompiled program (package) cannot be used with
             the current version of DB2/2.  The command cannot be processed.

     Action: Use only programs that are precompiled with a
             compatible release level of DB2/2.


SQL1009N

   Message:  The command is not valid.

     Cause:  The command is not supported when issued on a client-only
             workstation or against remote databases.  Examples of such
             commands include CREATE DATABASE or ROLLFORWARD DATABASE,
             respectively.

             The command cannot be processed.

     Action: Possible solutions include:

               - Issue the specified command from a non client-only workstation
                 or from the workstation where the database resides.
               - Verify that the database is catalogued correctly.
               - Issue a different command.


SQL1032N

   Message:  No STARTDBM command was issued.

     Cause:  The STARTDBM command has not been processed.
             It must be processed before a STOPDBM, any SQL statement,
             or utility can be issued.

             The command cannot be processed.

     Action: Issue a STARTDBM command and resubmit the current command.

      sqlcode:  -1032
      sqlstate:  57033


SQL1065W

   Message:  The database was created, but an error occurred on one or
             more bind files in list "<list name>".

             The following files were not bound: "<list>".

     Cause:  One or more utilities were not bound to the database.
             The list file ("<list name>") contains a list of
             the bind files.

             The numbers in "<list>" indicate the
             relative positions of the unbound files in the list file.

             The listed utility bind files are not bound to the newly
             created database.

     Action: The user may bind the indicated utilities to the database.
             The format option must not be used on the binder call.



SQL1325N

   Message:  The remote database environment does not support
             the command.

     Cause: An attempt has been made to issue a DB2 workstation
            database specific command against a host database through
            DDCS.  The following commands generate this error when
            issued against a DB2 for MVS*, DB2/400*, or SQL/DS* database:
             OPSTAT (Collect Operational Status)
             DARI (Database Application Remote Interface)
             RPC (Call a Procedure at the Server)
             GETAA (Get Administrative Authorizations)
             GETTA (Get Table Authorizations)
             PREREORG (Prepare to Reorganize Table)
             REORG  (Call Reorganize Function)
             RQSVPT/ENSVPT/RLBSVPT (Subtransaction Requests)
             RUNSTATS (Run Statistics)
             Compound SQL.

            As well, the following commands generate this error in
            with incorrect options:
             IMPORT (Import table) The filetype must be IXF, commitcount
             must be 0, and the first word in the tcolstrg must be
             INSERT.
             EXPORT (Export table) The filetype must be IXF.

            The command cannot be processed.


     Action: Do not attempt to issue this command against a host
             database through DDCS.

  This error will also occur if you are using DDCS/2 in a Client/Server
  environment and have the Single-User version of DDCS/2 installed
  instead of the Multi-User Gateway version.  Install DDCS/2 Multi-User
  Gateway and then try the operation again.


SQL1327N

   Message:  An implicit connection attempt failed. %1 is
             not a valid database name.

     Cause:  An attempt to perform an implicit connection failed.  The syntax
             of the database alias name specified by the SQLDBDFT environment
             variable is not valid.  The database name must contain 1 to 8
             bytes and all the characters must be from the Database Services
             base character set.  The command cannot be processed.

     Action: Correct the database alias name specified by the SQLDBDFT
             environment variable and resubmit your command.  If you do not
             want an implicit connection to be performed, remove the SQLDBDFT
             environment variable.


SQL1328N

   Message:  An implicit connection attempt failed.  The database alias name
             or database name %1 was not found in the local database directory.

     Cause:  An attempt to perform an implicit connection failed.  The database
             name specified by the SQLDBDFT environment variable does not name
             an existing database.  The database could not be found in the
             database directory.

             The command cannot be processed.

    Action:  Correct the database alias name specified by the SQLDBDFT
             environment variable and resubmit your command.  If you do not
             want an implicit connection to be performed, remove the SQLDBDFT
             environment variable.


SQL3013N

Message:  The length of the filetmod is out of the acceptable range.
            It should be greater than or equal to zero and less
            than or equal to 8000.

   Cause:  The filetmod specified is outside the acceptable range
            (greater than or equal to zero and less than or equal
            8000).

            The command cannot be processed.

   Action:  Examine the filetmod pointer and the structure it
            points to.

            Resubmit the command with a valid filetmod.


SQL30074N

     Message:  "<reply identifier>".  Reply is not supported.

       Cause:  The client received a reply it does not
               recognize.

               The current environment command or SQL statement
               cannot be processed successfully, nor can any
               subsequent commands or SQL statements.

               The current transaction is rolled back and the
               application is disconnected from the remote
               database.  The statement cannot be processed.

      Action:  Record the message number (SQLCODE) and
               the reply identifier.

               Record all error information from the SQLCA,
               if possible.  Attempt to connect to the remote
               database and rerun the application.

               If the problem continues, at the operating system
               command prompt type SQLTRC ON -L 0X100000.  Recreate
               the database problem, then at the command prompt
               type SQLTRC DUMP filename.

               To turn trace off, type SQLTRC OFF.

               Contact your service coordinator with the
               following information:

                 - Environment:  Application using Remote Data
                   Services to a non-OS/2 database.
                 - Required information.

                       - Problem description
                       - SQLCODE and reply identifier
                       - SQLCA contents
                       - Trace file.


SQL5011N

   Message:  The entry in the database manager configuration
             file for the number of databases allowed to be active on the
             same system at the same time is not in the valid range.

     Cause:  The value for the number of databases allowed to be active on the
             same system at the same time must be between 1 and 8.

             The requested change is not made.

     Action: Resubmit the command with a valid value for
             the number of databases allowed to be active on the same
             system at the same time.

/** ===> end of file < ===
