/*
 *  Program: extract -- a Portable Game Notation (PGN) extractor.
 *  Copyright (C) 1994 David Barnes
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  David Barnes may be contacted as D.J.Barnes@ukc.ac.uk
 *
 */

	/* Type definitions required by multiple files. */

	/* Permit lists of strings, e.g. lists of comments,
	 * list of NAGs, etc.
	 */
typedef struct string_list {
    char *str;
    struct string_list *next;
} StringList;

/* The following function is used for linking list items together. */
StringList *SaveStringListItem(StringList *list,const char *str);

#define MAX_MOVE_LEN 15

typedef struct variation{
    struct move *moves;
    struct variation *next;
} Variation;

	/* Retain the text of a move and any associated 
	 * NAGs and comments.
	 */
typedef struct move{
    char move[MAX_MOVE_LEN+1];
    MoveClass class;
    Col from_col;
    Rank from_rank;
    Col to_col;
    Rank to_rank;
    StringList *Nags;
    StringList *Comment;
    /* terminating_result hold the result of the current list of moves. */
    char *terminating_result;
    Variation *Variants;
    struct move *next;
} Move;

typedef struct {
    /* Tags for this game. */
    char **tags;
    /* The hash value of the final position. */
    HashCode final_hash_value;
    /* An accumulated hash value, used to disambiguate false clashes
     * of final_hash_value.
     */
    HashCode cumulative_hash_value;
    /* The move list of the game. */
    Move *moves;
} Game;

/* This structure holds details of the program state.
 * Most of these fields are set from the program's arguments.
 */
typedef struct {
    /* Whether to check, but not write the converted output.
     * This is set with the -r flag.
     */
    Boolean check_only;
    /* Whether to print a running commentary to logfile.
     * Set to FALSE with the -s flag.
     */
    Boolean verbose;
    /* Whether to keep NAGs along with moves.
     * This is cleared with the -N flag.
     */
    Boolean keep_NAGs;
    /* Whether to keep comments along with moves.
     * This is cleared with the -C flag.
     */
    Boolean keep_comments;
    /* Whether to keep variations along with moves.
     * This is cleared with the -V flag.
     */
    Boolean keep_variations;
    /* Whether to output just the Seven Tag Roster. */
    Boolean seven_tag_roster;
    /* Whether to match permutations of textual variations or not. */
    Boolean match_permutations;
    /* Whether we are matching positional variations or not. */
    Boolean positional_variations;
    /* Whether we are using Soundex matching or not. */
    Boolean use_soundex;
    /* Whether to suppress duplicate game score. */
    Boolean suppress_duplicates;
    /* Maximum output line length.  Set with -w flag. */
    unsigned max_line_length;
    /* Current input file name. */
    char *current_input_file;
    /* Where to write the extracted games. */
    FILE *outputfile;
    /* Where to write errors and running commentary.
     * Set with the -l flag.
     */
    FILE *logfile;
    /* Where to write duplicate games. */
    FILE *duplicate_file;
} StateInfo;

/* Provide access to the global state that has been set
 * through command line arguments.
 */
extern StateInfo GlobalState;
