/*
 *  Program: extract -- a Portable Game Notation (PGN) extractor.
 *  Copyright (C) 1994 David Barnes
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  David Barnes may be contacted as D.J.Barnes@ukc.ac.uk
 *
 */

	/* Shared prototypes for the non-static functions. */
void yyerror(const char *s);
void set_bibliographic_reference(char *bibref);
void save_assessment(const char *assess);
void report_details(FILE *outfp);
void restart_lex_for_new_game(void);
void *MallocOrDie(unsigned nbytes);
void init_positional_variations(FILE *fpin);
void init_textual_variations(FILE *fpin);
Move *new_move_structure(void);
Move *decode_move(const char *move_string);
void free_move_list(Move *move_list);
char **compose_file_list(FILE *fp);
Boolean check_textual_variations(Game game_details);
int open_input(char *infile);
void register_file_list(char *files_to_be_read[]);
void read_tag_file(const char *TagFile);
void print_error_context(FILE *fp);
#ifndef yywrap
int yywrap(void);
#endif
