/********************************************************************/
/*                                                                  */
/* Cardgames for OS/2                                               */
/*                                                                  */
/* English Installation, Version 1.04                               */
/*                                                                  */
/* Copyright 1994 (C) by Felix Maschek, Hamburg                     */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation of CARDS 1.04...'
Say ''


/* Check... */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDS.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PICTURES.DLL not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSENG.HLP not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSENG.DLL not found!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Please enter the full target path for CARDS'
Say '  Default: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Can''t create target path.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Copying CARDS to ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'
Copy "CARDSNOR.HLP" Directory"\CARDSNOR.HLP" '1>NUL'
Copy "CARDSNOR.DLL" Directory"\CARDSNOR.DLL" '1>NUL'
Copy "CARDSSWE.HLP" Directory"\CARDSSWE.HLP" '1>NUL'
Copy "CARDSSWE.DLL" Directory"\CARDSSWE.DLL" '1>NUL'

Say 'Creating desktop object...'
Type = 'WPProgram'
Title = 'Cardgames'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSENG;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Desktop object was created!  Ready.'
Else             
  Say 'ERROR: Can''t create desktop object!'

Signal DONE

FAILURE:
Say 'Error while processing REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
