{                   (c) CopyRight 1993,94 by Freaker!  TuC
==============================================================================
Help about command's
------------------------------------------------------------------------------
{-} {procedure/function in TUC_TEST.PAS
{*} {procedure/function in TUC_DEMO.TPU
{/} {procedure/function of Turbo Pascal
{!} {NEEDED procedure/function of TUC_DEMO.TPU
==============================================================================
Internal procedures/functions ...
------------------------------------------------------------------------------
procedure TUC_HSCINIT;                      [NEEDED when using HSC routines !]
  Use this when you use the HSC routines (required)
procedure TUC_HSCCLOSE(fadehsc:boolean);  [CLOSE HSC ROUTINES/only if HSCINIT]
  Use this to DEinitialize the hsc routines   (true=fade music/false=no fade)
procedure TUC_PLAYHSCBACK;                       [Play HSC file in background]
  Use this to play the HSC file AFTER blockwrite !
------------------------------------------------------------------------------
procedure TUC_FADEINIT;                  [NEEDED when using FADING ROUTINES !]
  Use this when use of the FADING routines (required)
procedure TUC_FADECLOSE;              [CLOSE FADE ROUTINES  only if FADEINIT]
  Use this to DEinitialize the fading routines
Procedure TUC_FADEOUT(Speed : Integer);                      [FADE screen out]
  Fade out (delay in milliseconds)
Procedure TUC_FADEIN(Speed : Integer);                        [FADE screen in]
  Fade in (delay in milliseconds)
------------------------------------------------------------------------------
procedure TUC_FLUSHKEYBOARD;                           [Flush keyboard buffer]
  flush keyboard buffer (after readkey/keypressed for example)
function  TUC_READKEY:char;                                          [READKEY]
  READ key ,returns "char" as result
function  TUC_KEYPRESSED:boolean;                                 [KEYPRESSED]
  KEYPRESSED ,returns TRUE if pressed any key
------------------------------------------------------------------------------
PROCEDURE TUC_CURSOROFF;                                     [Turn cursor OFF]
  Turn cursor OFF
PROCEDURE TUC_CURSORON;                                       [Turn cursor ON]
  Turn cursor ON
------------------------------------------------------------------------------
procedure TUC_TSCRESET;                            [TINY SCROLLER SPEED RESET]
  RESET the speed of the TINY scroller
procedure TUC_TSC(str:string;xloc,yloc:integer;rand:boolean);  [TINY SCROLLER]
  put scroller on screen in following format:
   TUC_TSC("STRING TO SHOW",X-AXIS,Y-AXIS,TRUE/FALSE); where TRUE/FALSE is
   random color scroller or just WHITE scroller
         (or color defined with TUC_TSC_COLOR:=byte of color)
procedure tuc_ssc_init;                                   [SMOOTHSCROLL RESET]
  RESET ssc scroller (NECCESARY BEFORE STARTING THIS SCROLLER AGAIN !)
procedure tuc_ssc(txt:string;row,yax1,yax2,attr:byte);        [SMOOTHSCROLLER]
  TUC_SSC("STRING TO SHOW",X-AXIS,Y-AXIS<to start>,Y-AXIS<to end>,attribute);
------------------------------------------------------------------------------
procedure TUC_HILITE(OnOff:boolean);                            [BLINK on/off]
  HILITE characters (blink on/off)
procedure TUC_QWRITE(xx,yy:byte;str:string;fc,bc:byte);           [QUICKWRITE]
  QUICK WRITE (without CR)
procedure TUC_QWRITELN(xx,yy:byte;str:string;fc,bc:byte);       [QUICKWRITELN]
  QUICK WRITE (with CR)
   xx,yy is X-axis and Y-axis
   str is the string to write
   fc,bc are foreground color and background color
procedure TUC_SWITCHMAP;                                        [SWITCHCHRMAP]
Procedure TUC_SWITCHMAP_RESET;
==============================================================================
Costumisable parameters
------------------------------------------------------------------------------
const TUC_TSC_CHARDELAY : integer = 6;    (character delay TSC scroller in mS)
      TUC_TSC_ENDDELAY  : integer = 800;   (enddelay after TSC scroller in mS)
      TUC_TSC_COLOR     : byte    = 15;  (color of TSC scroller if non-random)
    TUC_SWITCHMAP_STATUS: boolean = false;   (switchmap status / auto updated)
}


uses crt,tuc_demo;

var key     : char;                      {needed for the "H"ilite key}
    counter : byte;                      {needed for the scroll-up}


PROCEDURE hscfile; external;
{$L m.obj}   {use BINOBJ to convert an HSC to an OBJ file by typing}
             {BINOBJ FILENAME.HSC M.OBJ HSCFILE                    }

procedure HSC_PLAYER;
begin
   tuc_hscinit;                        {initialisation of the HSC routine }
   BLOCKWRITE(fhsc, @hscfile^, {!!}14259+1{!! the size of your HSC file});
   tuc_playhscback;                    {needed to play in background      }
end;


Procedure SCROLL_DEMO1;
begin

tuc_tsc('This is an simple scroller... without random colors ...',1,10,false);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);
tuc_tsc('-------------again one .. in another color ...---------',1,10,false);
tuc_tsc_color:=random(14+1);

tuc_tsc('This is an simple scroller... with random colors ...',1,11,true);
tuc_tsc('Anywhere on the screen !     ',8,15,true);
tuc_tsc('Anywhere on the screen !     ',10,5,true);
tuc_tsc('Anywhere on the screen !     ',2,3,true);
end;

procedure SCROLL_DEMO2;
begin
tuc_tsc('With cursor off !                 ',8,15,true);
  delay(2000);
  tuc_cursoron;
tuc_tsc('With cursor back on ....          ',8,15,true);
tuc_tsc('How to wipe this line away ?      ',8,15,true);
  delay(2000);
tuc_tsc('                                  ',8,15,true);
tuc_tsc('Now it''s here .....               ',2,1,true);
tuc_tsc('                                  ',2,1,true);
tuc_tsc('Now it''s here ..... again         ',2,1,true);
tuc_tsc('                                  ',2,1,true);
tuc_tsc('See ? easy to remove line !!!     ',2,1,true);
tuc_tsc('                                  ',2,1,true);
end;

procedure SCROLL_DEMO3;
begin
tuc_tsc('And .. of course .. control speed with the parameter CHARDELAY/ENDDELAY ',8,15,true);
delay(2000);
TUC_TSC_CHARDELAY := 2;
TUC_TSC_ENDDELAY  := 2000;
tuc_tsc('This is faster scroller with delay after it ... (2ms char/2sec delay) ',1,1,true);
tuc_tscreset;
tuc_tsc('This is the normal speed ...                                          ',1,1,true);
  delay(2000);
tuc_tsc('Now switching character maps 4 times                                   ',8,15,true);
TUC_SWITCHMAP;
delay(300);
TUC_SWITCHMAP;
delay(300);
TUC_SWITCHMAP;
delay(300);
TUC_SWITCHMAP;
delay(300);
(*TUC_SWITCHMAP;
delay(300);*)
TUC_SWITCHMAP;
delay(300);
TUC_SWITCHMAP;
delay(300);
TUC_SWITCHMAP;
delay(300);
end;

procedure smooth_scroll;
var line,counter2:integer;

begin
clrscr;
randomize;
counter:=1;
line:=1;
repeat
gotoxy(1,line);
for counter:=counter+1 to 80 do write(random(255));
counter:=1;
line:=line+1;
until line=24;
tuc_ssc_init;
repeat
tuc_ssc('         This is an fine scrolly from line 2 to line 79 ... smooth ! uh ! yeah ... also this is in this unit ...   '+
        '                   ',12,2,79,$1F);
until keypressed;
end;


Procedure write_demo;
begin
   gotoxy(1,24);
write('This is an ordinary gotoxy with write ... ');
   delay(500);
tuc_qwrite(1,20,'This is quickwrite',$0E);
   delay(500);
tuc_qwrite(1,1,'Press any key to continue ... ',$0E);
end;

procedure hi_demo;
begin
TUC_HILITE(false);
tuc_qwrite(1,1,'Here is an HILITE demo ... ehehe .. yeah !        -touch tha key                ',$4F);
tuc_qwrite(1,2,'Press now "H" to turn the hi-bits on ...                              1234567890',$7E+blink);
tuc_qwrite(1,3,'     Press now "H" to turn the hi-bits on ...                         1234567890',$4F+blink);
tuc_qwrite(1,4,'          Press now "H" to turn the hi-bits on ...                    1234567890',$1F+blink);
tuc_qwrite(1,5,'               Press now "H" to turn the hi-bits on ...               1234567890',$1E+blink);
tuc_qwrite(1,6,'                    Press now "H" to turn the hi-bits on ...          1234567890',$1B+blink);
   repeat
       key:=tuc_readkey;
   until upcase(key) = 'H';
TUC_SWITCHMAP;
tuc_qwrite(1,15,'Press now any key to return to normal mode ...',$4F+blink);
TUC_HILITE(false);
textbackground(black);

tuc_tsc('And going back to NORMAL MODE ...   press a key to quit this quick demo ...',1,15,true);

   delay(2000);
   tuc_cursoron;
   TUC_HILITE(true);
end;

procedure fadeout;
begin
tuc_fadeout(10);
clrscr;
tuc_fadein(1);
writeln('That''s all folks !');
end;


{-} {procedure/function in TUC_TEST.PAS}
{*} {procedure/function in TUC_DEMO.TPU}
{/} {procedure/function of Turbo Pascal}
{!} {NEEDED procedure/function of TUC_DEMO.TPU}

begin
{-} hsc_player;
{*} tuc_fadeinit;
{/} clrscr;
{-} scroll_demo1;
{*} tuc_cursoroff;
{-} scroll_demo2;
{-} write_demo;
{*} repeat until keypressed;
{/} clrscr;
{-} scroll_demo3;
{*} TUC_TSCRESET;
{*} repeat until keypressed;
{/} clrscr;
{-} hi_demo;
{*} tuc_flushkeyboard;
{*} repeat until keypressed;
{*} tuc_flushkeyboard;
{-} smooth_scroll;
{-} fadeout;
{!} tuc_fadeclose;
{!} tuc_hscclose(true);
{!} tuc_switchmap_reset;
end.






