/*
	MEM.H

	Copyright Marc savary, Ad Lib Inc., 1988
*/

#ifdef LPTR
typedef	long	Size;
#else
typedef	unsigned Size;
#endif

#define NoErr        	0	/* no errors */
#define MemFullErr   	1      	/* memory full */
#define NilHandleErr 	2 	/* handle was NULL */
#define NilPtrErr   	3      	/* Ptr was NULL */
#define MemBlockErr 	4      	/* Illegal block for 'dispose' */
#define MemInitErr  	5      	/* Initialisation error */
#define MemBlocTooBigErr	21	/* demande d'allocation de memoire > 64K */

typedef	char		Byte;
typedef	char		SignedByte;
typedef	char *		Ptr;
typedef	Ptr *		Handle;

extern Ptr     NewPtr          ( /* Size dim */ );
extern         DisposPtr      ( /* Ptr pointer */ );
extern Size	GetPtrSize     ( /* Ptr pointer */ );
extern Handle  NewHandle       ( /* Size dim */ );
extern         DisposHandle   ( /* Handle hand */ );
extern Size	GetHandleSize  ( /* Handle hndl */ );
extern			SetHandleSize	( /* Handle hndl; Size newsize */ );
extern int		memError();

extern int memErr;


