;	CSOUND.ASM
;
; interface langage C du sound-driver resident.
;
; 87/03/18, Marc Savary, Ad Lib.
; 88/03/1,  Benoit Robitaille, Ad Lib.
;
;
	INCLUDE	VERSION.INC
	INCLUDE	CMICRO.MAC		; for Microsoft C 5.0

	INCLUDE DEFS.MAC		; equates & sound-driver version proc.



	PSEG CSOUND

	INCLUDE VERSION.MAC		; signature du sound-driver ...

;
;	unsigned GetSoundDrvVersion()
;		retourne le numero de version du sound-driver
;		charge en memoire, ou 0 si non-charge.
; 		utilise la MACRO ..
;
	DrvVersionProc _GetSoundDrvVersion




;	int SoundCall( functionNumber, arg_list)
;		int functionNumer;
;		any... arg_list
;
;	genere l'interruption au sound driver
;	avec l'address des arguments dans ES:BX,
;	et le numero de function dans SI

aaframe	STRUC
		dw	?		; old BP
		db	CPSIZE DUP (?)	; return addr
aaargs		dw	?		; function number
others		dw	?		; from this point... all other param.
aaframe	ENDS	

BEGIN _SoundCall

	penter	0			; Normal C calling format ( 0= Local variables)
	push	es

	mov	si, [bp].aaargs		; get function number
	lea	bx, [bp].others		; get pointers to others args...
	push	ss
	pop	es
	int	sound_driver_int	; call sound-driver ...

	pop	es
	pleave	0			; Restore Stack pointers ( sp, bp)
_SoundCall	ENDP




; ===================================================================
;
;	definition des fonction qui remplacent les anciens appels
;	au sound-driver en C.
;

fInitSon	equ	0
fFinSon		equ	1
fEcrTempsDebut	equ	2
fActiveSon	equ	3
fLisSonActif	equ	4
fChut		equ	5
fEcrMode	equ	6
fLisMode	equ	7
fEcrVolume	equ	8
fEcrTempo	equ	9
fEcrDiapason	equ	10
fLisDiapason	equ	11
fEcrFileAct	equ	12
fLisFileAct	equ	13
fJouePoly	equ	14
fJoueNote	equ	15
fEcrTimbre	equ	16
fEcrPitch	equ	17
fEcrTickTemps	equ	18
fSoundOn	equ	19
fSoundOff	equ	20
fSetVParam	equ	21


	ENDPS CSOUND
	end

