//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlSy.H                                          //
// Desc:   Window System Control Clases                        //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLSY_H_
#define _MWNCTLSY_H_

//-------------------------------------------------------------//

// System minimize object

class mWnCtlMinimizeButton : public mWnControl
{
   public:

      mWnCtlMinimizeButton( mRect r );
      mWnCtlMinimizeButton( );
      virtual ~mWnCtlMinimizeButton( );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
};

//-------------------------------------------------------------//

// System maximize object (also does restore operations)

class mWnCtlMaximizeButton : public mWnControl
{
   friend class mWindow;

   protected:

      int restore;   // flag set by maximize operation

   public:

      mWnCtlMaximizeButton( mRect r );
      mWnCtlMaximizeButton( );
      virtual ~mWnCtlMaximizeButton( );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
};

//-------------------------------------------------------------//

// Window title bar

class mWnCtlTitleBar : public mWnControl
{
   private:

     mRect bdrout;   // used when moving parent window
     mRect bdrin;

   public:

      mWnCtlTitleBar( mRect r, char *title, mFont *fnt );
      mWnCtlTitleBar( );
      virtual ~mWnCtlTitleBar( );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void draw( void );
      virtual void ghost( void );
};

//-------------------------------------------------------------//

// System menu object

class mWnCtlSysMenuButton : public mWnControl
{
   friend class mWindow;

   protected:

      mWnCtlBoxMenu *sysmenu;

   public:

      mWnCtlSysMenuButton( mRect r, mWnCtlBoxMenu *sysmen );
      mWnCtlSysMenuButton( );
      virtual ~mWnCtlSysMenuButton( );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      void    setsysmenu( mWnCtlBoxMenu *m )      { sysmenu = m; }
      mWnCtlBoxMenu *getsysmenu( void )           { return sysmenu; }
};

//-------------------------------------------------------------//

// a control class for window border manipulations

class mWnCtlBorder : public mWnControl
{
   protected:

     mRect   bdrout;        // used when sizing border
     mRect   bdrin;
     mPoint  lastp;         // last mouse position
     short   bdrarea;       // side or corner

   public:

      mWnCtlBorder( );
      virtual ~mWnCtlBorder( );

      virtual int   ptinctl( mPoint p );
      virtual int   ack( mEvent& evt );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual mRect extent( void );
};

//-------------------------------------------------------------//

class mWnCtlToolBar : public mWnControl
{
   public:

      int         type;

      mWnCtlToolBar( );
      mWnCtlToolBar( int typ, mRect r );
      virtual ~mWnCtlToolBar( ) { }

      mWnCtlToolBar& operator << ( mWnControl& ctl );
      mWnCtlToolBar& operator >> ( mWnControl& ctl );
};

#endif
