//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlSl.H                                          //
// Desc:   Window Controls : Sliders                           //
// Date:   February, 1994                                      //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLSL_H_
#define _MWNCTLSL_H_

// Slider class

class mWnCtlSlider : public mWnControl
{
   protected:

      mRect           area;        // boundary of slider
      mProportional   func;        // reading/position function
      mPoint          incxy;       // increase delta
      mPoint          decxy;       // decrease delta
      mPoint          lastpt;      // last point
      short           sign;        // -1 or +1
      short           nstops;      // number of slider positions

   public:

      short           type;        // DIR_VERT or DIR_HORZ

   private:

      void inithnodes( mRect r );
      void initvnodes( mRect r );

   public:

      mWnCtlSlider( mRect r, int layout, int nmarks = 0 );
      mWnCtlSlider( );
      virtual ~mWnCtlSlider( );
      void initnodes( mRect r, int layout, int nmarks );

      virtual void  move( mPoint pt );
      virtual void  resize( int dx, int dy );
      virtual mRect extent( void );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual int   ack( mEvent& evt );
      virtual int   whichnode( mPoint pt );

      void    set( int newcur );
      void    set( int mn, int cu, int mx );
      int     readabs( void ) { return func.domget(); }
      mPoint  readrel( void ) { return func.domread(); }
};

#endif
