//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlSb.H                                          //
// Desc:   Scrollbars                                          //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLSB_H_
#define _MWNCTLSB_H_

// Scroll bar base class

class mWnCtlScrollBar : public mWnControl
{
   protected:

      mRect           area;        // boundary of scroll bar
      mProportional   func;        // reading/position function
      mPoint          incxy;       // increase delta
      mPoint          decxy;       // decrease delta
      mPoint          delta;       // actual delta
      short           sign;        // -1 or +1
      short           timer_id;    // timer device ID

   public:

      short           type;    // butHORIZONTAL or butVERTICAL

   private:

      void patchborder( int dx, int dy );
      void inithnodes( mRect r, int layout );
      void initvnodes( mRect r, int layout );

   public:

      void   initnodes( mRect r, int layout );
      void   set( int newcur );
      void   set( int mn, int cu, int mx );
      int    readabs( void ) { return func.domget(); }
      mPoint readrel( void ) { return func.domread(); }

      mWnCtlScrollBar( mRect r, int layout );
      mWnCtlScrollBar( mRect r, int nxtra, int layout );
      mWnCtlScrollBar( );

      virtual ~mWnCtlScrollBar( );
      virtual void  move( mPoint pt );
      virtual void  resize( int dx, int dy );
      virtual mRect extent( void );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual int   ack( mEvent& evt );
      virtual int   whichnode( mPoint pt );
};

#endif
