//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlRg.Hpp                                        //
// Desc:   Radio Button Group                                  //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLRG_HPP_
#define _MWNCTLRG_HPP_

class mWnCtlRadioGroup : public mWnControl
{
   protected :

      mBrush  selbr;      // selected button fill
      mBrush  unselbr;    // unselected button fill
      short   nbut;       // button count
      short   cbut;       // current button
      short   mustpick;   // flag - must pick one

   public :

      mWnCtlRadioGroup( mPoint p, mFont *fnt, char *title,
                        char **lbls, int nx, int ny,
                        int wid, int hgt, int toggle );
      mWnCtlRadioGroup( mPoint p, mFont *lgfnt, mFont *smfnt,
                        char *title, char **lbls,
                        int nx, int ny, int wid, int hgt );
      mWnCtlRadioGroup( );
      virtual ~mWnCtlRadioGroup( );
      virtual void draw( void );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );

      mPoint maxtextlbl( mFont *fnt, char **lbls, int nlbls, int toggle );
      mPoint maxmathlbl( mFont *lgfnt, mFont *smfnt, char **lbls, int nlbls );
      void inittextnodes( mPoint p, mFont *fnt, char *title,
                          char **lbls, int nx, int ny,
                          int wid, int hgt, int toggle );
      void initmathnodes( mPoint p, mFont *lgfnt, mFont *smfnt,
                          char *title, char **lbls,
                          int nx, int ny, int wid, int hgt );

      void  setmustpick( int state )  { mustpick = state; }
      char  getmustpick( void )       { return mustpick; }
      short getpick( void )           { return cbut; }
      void  setpick( short pick );
      void  clearpick( void );

      mBrush getselectedbrush( void )         { return selbr; }
      mBrush getunselectedbrush( void )       { return unselbr; }
      void   setselectedbrush( mBrush& br );
      void   setunselectedbrush( mBrush& br );
};

#endif
