//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlPt.Hpp                                        //
// Desc:   "Paper Tape" control class                          //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLPT_HPP_
#define _MWNCTLPT_HPP_

class mWnCtlPaperTape : public mWnControl
{
   protected:

      mRect paper;
      int   lhgt;
      int   lmin;
      int   lmax;
      int   lcnt;
      int   ymin;
      int   ymax;
      int   mkmn;
      int   mkmx;
      int   mky;

   public:

      mWnCtlPaperTape( mRect r, int linehgt );
      virtual ~mWnCtlPaperTape( );

      virtual void draw( void );
      virtual void press( void );
      virtual void unpress( void );

      void  serate();
      void  drawroller( mRect r );
      void  drawpaper();
      void  scrollpaper( int dir );
      void  resetpaper( int redraw=1 );
      int   homepaper( int redraw=1 );
      void  resize( int newlinehgt, int redraw=1 );
      int   markpaper( void );
      mRect tapearea( void );

      int minline( void )
      {
         return lmin;
      }
      int maxline( void )
      {
         return lmax;
      }
      int curline( void )
      {
         return lmax;
      }
      int topline( void )
      {
         return lmin;
      }
      int curmark( void )
      {
         return mkmx;
      }
      int nlines( void )
      {
         return lmax - lmin + 1;
      }
      int capacity( void )
      {
         return lcnt;
      }
      int isvisible( int linenum )
      {
         return ((lmin<=linenum) && (linenum<=lmax)) ? 1 : 0;
      }
      int isfilled( void )
      {
         return ((lmax-lmin+1) == lcnt) ? 1 : 0;
      }
      mRect linebox( int linenum );
      mRect curlinebox( void );
      mRect toplinebox( void );
};

#endif
