//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlMu.H                                          //
// Desc:   Menu classes                                        //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLMU_H_
#define _MWNCTLMU_H_

//-------------------------------------------------------------//

// check mark symbols

#define SM_CHECK 1
#define MD_CHECK 2
#define LG_CHECK 3
#define XL_CHECK 4

mMaskCtlSym *check_mark( int size );

//-------------------------------------------------------------//

// base class for menus

class mWnCtlMenu : public mWnControl
{
   protected:

      int            nitems;      // number of menu items
      int            curitem;     // current focus item
      mPoint         orig_org;    // original origin if menu is moved
      mWnCtlMenu * * submenu;     // array of submenu pointers

      void sethighlight( int inode, int high );
      int  nextselectable( void );
      int  prevselectable( void );

   public:

      mWnCtlMenu( mRect r, mMenuDef *mdef );
      mWnCtlMenu( );
      virtual ~mWnCtlMenu( );

      virtual void  draw( void );
      virtual void  ghost( void );
      virtual void  erase( int clr );
      virtual void  open( void );
      virtual void  close( void );

      void         setpulldown( mWnCtlMenu * pd, int item );
      mWnCtlMenu * getpulldown( int item );
      void         setitemselectable( int item, int state );
      int          whichitem( mPoint p );
      int          whichkey( mKey& k );
      int          getcuritem( void ) { return curitem; }
      int          getnitems( void )  { return nitems; }
      int          moved( void );
};

//-------------------------------------------------------------//

// bar menu

class mWnCtlBarMenu : public mWnCtlMenu
{
   protected:

      mImageSave  *savep;

   public:

      mWnCtlBarMenu( mRect r, mFont *fnt, mMenuDef *mdef );
      mWnCtlBarMenu( );
      virtual ~mWnCtlBarMenu( );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void  resize( int dx, int dy );
      virtual void  open( void );
      virtual void  close( void );
};

//-------------------------------------------------------------//

// box menu

class mWnCtlBoxMenu : public mWnCtlMenu
{
   protected:

      mImageSave  *savep;

      void initnodes( mRect r, mFont *fnt, mMenuDef *mdef );

   public:

      mWnCtlBoxMenu( mRect r, mFont *fnt, mMenuDef *mdef );
      mWnCtlBoxMenu( mFont *fnt, mMenuDef *mdef );
      mWnCtlBoxMenu( );
      virtual ~mWnCtlBoxMenu( );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void open( void );
      virtual void close( void );
      virtual void redef( mRect r, mFont *fnt, mMenuDef *mdef );
      virtual void redef( mFont *fnt, mMenuDef *mdef );
};

#endif
