//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlMt.H                                          //
// Desc:   "Mouse Trap" control class                          //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLMT_H_
#define _MWNCTLMT_H_

// Invisible control for mouse event in a specified area

class mWnCtlMouseTrap : public mWnControl
{
   protected:

      mRect area;

   public:

      mWnCtlMouseTrap( mRect& ar ) : mWnControl( )
      {
         area = ar;
      }
      mWnCtlMouseTrap( ) : mWnControl( )
      {
      }
      virtual ~mWnCtlMouseTrap( )
      {
      }
      virtual void move( mPoint pt )
      {
         area += pt;
      }
      virtual void resize( int dx, int dy )
      {
         area.xmax += dx;
         area.ymax += dy;
      }
      virtual mRect extent( void )
      {
         return area;
      }
      virtual int ptinctl( mPoint pt )
      {
         return ((pt % area) == OUTSIDE) ? 0 : 1;
      }
      virtual int ack( mEvent& evt );
};

#endif
