//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlMf.H                                          //
// Desc:   Multi-Line Input field controls                     //
// Date:   Jun, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLMF_H_
#define _MWNCTLMF_H_

// a control class for multi-line editable fields

class mWnCtlMultiLineField : public mWnControl
{
   protected:

      mFont            *_font;      // font for field contents
      mRect             _editarea;  // active interior of field control
      mPoint            _editorg;   // positions string within editarea
      mPoint            _csrorg;    // positions cursor within editarea
      short             _ch1col;    // column of leftmost character
      short             _csrcol;    // column of cursor
      short             _csrrow;    // column of cursor
      short             _fldwid;    // width of display area in pixels
      short             _maxcols;   // maximum number of characters
      short             _maxrows;   // maximum lines for field
      short             _toprow;    // current top row in field
      short             _currow;    // current line number
      short             _nrows;     // number of rows in field
      mString         **_strings;   // Field strings

   private:

      int  update_cursor( void );
      void reposition_cursor( mPoint pt );

   public:

      mWnCtlMultiLineField( mRect r, mFont *fnt, char *lbl,
                            short nwchars, short nlines,
                            short lbljust=jLEFT );
      mWnCtlMultiLineField( );
      virtual ~mWnCtlMultiLineField( );

      void initnodes( mRect r, mFont *fnt, char *lbl,
                      short nwchars, short nlines,
                      short lbljust );
      void   reset( short home_or_end = 0 );
      void   resetarea( void );
      void   redef( short newchcnt, short newrowcnt );

      void   put( short which, char *str );
      char  *get( short which );

      void   setfont( mFont *fnt )   { _font = fnt; }
      mFont *getfont( void )         { return _font; }

      virtual int   exec( mMsg& msg );
      virtual int   ack( mEvent& evt );
      virtual mMsg& xlate( mEvent& evt );
      virtual void  draw( void );
      virtual void  ghost( void );
      virtual void  move( mPoint pt );
      virtual mRect extent( void );
};

#endif
