//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlLs.H                                          //
// Desc:   Scrollable list control                             //
// Date:   April, 1993                                         //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLLS_H_
#define _MWNCTLLS_H_

// a list box class

typedef void (*mListDrawFunc)( mRect&, short, void * );

class mWnCtlListBox : public mWnCtlScrollBar
{
   protected:

      mPoint         listorg;   // List origin
      mRect          listarea;  // Area of list
      short          nitems;    // Number of items in list
      short          curitem;   // Current item
      short          topitem;   // Top item currently displayed
      short          nslots;    // Number of slots
      short          cellh;     // Height of each cell
      void          *listdata;  // User defineable data for draw func
      mListDrawFunc  drawf;     // User drawing function

   private:

      void highlightcuritem();

   public:

      mWnCtlListBox( mRect ra, mRect rb, short nitms,
                     short ch, mListDrawFunc df,
                     int buts = butUPUP|butVERTICAL );
      mWnCtlListBox( );
      virtual ~mWnCtlListBox( );

      void           initlistnode( mRect ra );
      void           drawlist( void );
      void           scrolllist( short delta );
      void           setcuritem( short ci );
      void           setnoitem( void )            { curitem = -1; }
      short          getcuritem( void )           { return curitem; }
      mRect          getlistarea( void )          { return listarea; }

      void           setlist( short ch, short nitms, int icur=0 );

      void           setlistdata( void *ld )      { listdata = ld; }
      void          *getlistdata( void )          { return listdata; }

      virtual void   move( mPoint pt );
      virtual void   draw( void );
      virtual mMsg&  xlate( mEvent& evt );
      virtual int    ack( mEvent& evt );
      virtual int    exec( mMsg& msg );
      virtual mRect  extent( void );
};

#endif
