//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlLi.H                                          //
// Desc:   Scrollable text list control                        //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLLI_H_
#define _MWNCTLLI_H_

// a text list box class

class mWnCtlTextList : public mWnCtlScrollBar
{
   protected:

      mFont   *font;
      mPoint   listorg;
      char   **items;
      mRect    listarea;
      short    nitems;
      short    curitem;
      short    topitem;
      short    nslots;

   private:

      void highlightcuritem();

   public:

      mWnCtlTextList( mRect ra, mRect rb, mFont *fnt, char **itms,
                      short nitms, short layout = butUPUP|butVERTICAL );
      mWnCtlTextList( );
      virtual ~mWnCtlTextList( );

      void  initlistnode( mRect ra );
      void  drawlist( void );
      void  scrolllist( short delta );
      void  setcuritem( short ci );
      void  setnoitem( void )            { curitem = -1; }
      void  setfont( mFont *new_font )   { font = new_font; }
      short getcuritem( void )           { return curitem; }
      char  *getcuritemtext( void )      { return items[curitem]; }
      mFont *getfont( void )             { return font; }
      mRect  getlistarea( void )         { return listarea; }
      short  getnitems( void )           { return nitems; }
      short  getnslots( void )           { return nslots; }

      void  setlist( char **itms, int nitms, int icur=0 );

      virtual void  move( mPoint pt );
      virtual void  draw( void );
      virtual mMsg& xlate( mEvent& evt );
      virtual int   ack( mEvent& evt );
      virtual int   exec( mMsg& msg );
      virtual mRect extent( void );
};

#endif
