//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlGa.H                                          //
// Desc:   Gauges                                              //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLGA_H_
#define _MWNCTLGA_H_

class mWnCtlGauge : public mWnControl
{
   protected:

      mProportional   func;
      mPoint          incxy;     // increase delta
      mPoint          decxy;     // decrease delta
      short           sign;      // -1 or +1

   public:

      short           type;      // butHORIZONTAL or butVERTICAL

   private:

      void inithnodes( mRect r, int nmaj, int nmin );
      void initvnodes( mRect r, int nmaj, int nmin );

   protected:

      void drawdial( void );

   public:

      void initnodes( mRect r, int nmaj, int nmin, int layout );

      mWnCtlGauge( mRect r, int nmaj, int nmin, int layout );
      mWnCtlGauge( int nextra );
      mWnCtlGauge( );
      virtual ~mWnCtlGauge( );

      virtual void  draw( void );
      virtual int   whichnode( mPoint pt );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void  move( mPoint pt );

      void   set( int newcur );
      void   set( int mn, int cu, int mx );
      int    readabs( void ) { return func.domget(); }
      mPoint readrel( void ) { return func.domread(); }

};

//-------------------------------------------------------------//

class mWnCtlScrollGauge : public mWnCtlGauge
{
   protected:

      mRect     area;      // control extent
      mPoint    delta;     // actual delta
      short     timer_id;  // ID for timer

   private:

      void inithnodes( mRect rdec, mRect rinc );
      void initvnodes( mRect rdec, mRect rinc );

   public:

      void initnodes( mRect r, int nmaj, int nmin, int layout );

      mWnCtlScrollGauge( mRect r, int nmaj, int nmin, int layout );
      mWnCtlScrollGauge( );
      virtual ~mWnCtlScrollGauge( );

      virtual mRect extent( void ) { return area; }
      virtual void  move( mPoint pt );
      virtual int   whichnode( mPoint pt );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual int   ack( mEvent& evt );
};

#endif
