//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlFi.H                                          //
// Desc:   Input field controls                                //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLFI_H_
#define _MWNCTLFI_H_

void SetDefaultAutoClear( int state );
int  GetDefaultAutoClear( void );

// a control class for editable fields

class mWnCtlField : public mWnControl, public mString
{
   protected:

      mFont  *font;       // font for field contents
      char   *mask;       // format mask for field contents
      mRect   editarea;   // active interior of field control
      mPoint  editorg;    // positions string within editarea
      mPoint  csrorg;     // positions cursor within editarea
      short   ch1col;     // column of leftmost character
      short   csrcol;     // column of cursor
      short   fldwid;     // width of display area in pixels

   private:

      int  update_cursor( void );
      void reposition_cursor( mPoint pt );

   public:

      mWnCtlField( mRect r, mFont *fnt, char *lbl, int nchars,
                       int lbljust=jLEFT, char *fmtmsk=0 );
      mWnCtlField( );
      virtual ~mWnCtlField( );

      mFont * getfont( void )    { return font; }
      void setfont( mFont *fnt ) { font = fnt; }
      void reset( int home_or_end = 0 );
      void resetarea( void );
      void redef( int newchcnt );

      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void  draw( void );
      virtual void  ghost( void );
      virtual void  move( mPoint pt );
      virtual mRect extent( void );
};

#endif
