//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlCg.H                                          //
// Desc:   Check box groups                                    //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLCG_H_
#define _MWNCTLCG_H_

// a group of related check boxes

class mWnCtlCheckGroup : public mWnControl
{
   protected :

      long   checks;     // 1 bit per button
      short  nbut;       // button count
      short  cbut;       // current button
      char   exclusive;  // flag for radios
      char   mustpick;   // pick is required

   public :

      mWnCtlCheckGroup( mPoint p, mFont *fnt, char *title,
                        char **lbls, int nx, int ny, int toggle );
      mWnCtlCheckGroup( );
      virtual ~mWnCtlCheckGroup( );
      virtual void draw( void );
      virtual int  exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );

      void  initnodes( mPoint p, mFont *fnt, char *title,
                   char **lbls, int nx, int ny, int toggle );
      void  setexclusive( int state ) { exclusive = state; }
      int   getexclusive( void )      { return exclusive; }
      void  setmustpick( int state )  { mustpick = state; }
      int   getmustpick( void )       { return mustpick; }
      short getpick( void )           { return cbut; }
      long  getchecks( void )         { return checks; }
      void  setpick( int pick );
      void  setchecks( long picks );
};

#endif
