//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlCb.H                                          //
// Desc:   User drawable Combo Box                             //
// Date:   May, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLCB_H_
#define _MWNCTLCB_H_

typedef void (*mComboBoxDrawFunc)( mRect&, short, void * );

class mWnCtlComboBox : public mWnControl
{
   protected:

      mWnCtlListBox     *list;
      mImageSave        *savep;
      mRect              area;
      mPoint             org;
      void              *cbdata;
      mComboBoxDrawFunc  drawf;

   public:

      mWnCtlComboBox( mRect r, mFont *fnt, char *lbl,
                      short nitms, short ch, mComboBoxDrawFunc df,
                      short layout = butUPUP|butVERTICAL );
      mWnCtlComboBox( );
      virtual ~mWnCtlComboBox( );

      void initnodes( mRect r, mFont *fnt, char *lbl,
                      short nitms, short ch, short layout );
      void setcuritem( short ci )
         { list->setcuritem( ci ); }
      short getcuritem( void )
         { return list->getcuritem(); }
      void setlist( short nitms, short ch, int icur = 0 )
         { list->setlist( nitms, ch, icur ); }
      mWnCtlListBox *getlist( void )
         { return list; }

      void         *getcbdata( void )               { return cbdata; }
      void          setcbdata( void *cbd );

      virtual mRect extent( void ) { return area; }
      virtual void  move( mPoint pt );
      virtual void  draw( void );
      virtual mMsg& xlate( mEvent& evt );
      virtual int   exec( mMsg& msg );
};

#endif
