//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtlBk.H                                          //
// Desc:   Notebook control class                              //
// Date:   August, 1993                                        //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTLBK_H_
#define _MWNCTLBK_H_

struct mBookDef
{
   mRect     area;                // area of cover and pages
   short     cvrflag;             // Flag for cover display
   mFont    *bkfont;              // Font for tabs and title
   char     *title;               // Title for book
   mBrush    cvrbr;               // Cover brush
   mBrush    ttlbr;               // Title Brush
   short     npages;              // Total number of tabs
   char    **tabtxt;              // Text strings for the tabs
};

struct mBookCtl
{
   mWnControl *ctl;                // Pointer to control
   mBookCtl   *next;               // Pointer to next book control
   mBookCtl   *prev;               // Pointer to previous book control
};

class mWnCtlBook : public mWnControl
{
   protected :

      mBookDef  *_bookdef;      // Book control definition
      short      _nvtabs;       // Number of visible tabs
      short      _toptab;       // Current top tab
      short      _curtab;       // Current tab
      short      _tabheight;    // Height of each tab
      short      _foldxy;       // Fold (X,Y) Dimensions
      short     *_pgmarks;      // flags for marked pages
      mBookCtl **_page_ctls;    // Controls for each page

      void add_page_controls( void );
      void remove_page_controls( void );
      void draw_page_controls( void );

   public :

       mWnCtlBook( mBookDef *bd );
       mWnCtlBook( );
       virtual ~mWnCtlBook( );

       void initnodes( mBookDef *bd );

       void    coverbrush( mBrush b )    { _bookdef->cvrbr = b; }
       mBrush  coverbrush( void )        { return _bookdef->cvrbr; }
       void    titlebrush( mBrush b )    { _bookdef->ttlbr = b; }
       mBrush  titlebrush( void )        { return _bookdef->ttlbr; }

       short   foldxy( void )            { return _foldxy; }
       void    foldxy( short xy )        { _foldxy = xy; }

       int     npages( void )            { return _bookdef->npages; }
       int     toptab( void )            { return _toptab; }
       int     nvtabs( void )            { return _nvtabs; }
       int     tabheight( void )         { return _tabheight; }
       int     curtab( void )            { return _curtab; }
       void    curtab( short ct );
       int     which_tab( mPoint p );

       void    addcontrol( int page, mWnControl *ctl );

       short   pgmark( int which )       { return _pgmarks[which]; }

       virtual void  draw( void );
       virtual mMsg& xlate( mEvent& evt );
       virtual int   exec( mMsg& msg );
       virtual void  move( mPoint pt );
};

#endif
