//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWnCtl.H                                            //
// Desc:   Window Control Base Classes                         //
// Date:   Jun, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWNCTL_H_
#define _MWNCTL_H_

//-------------------------------------------------------------//

void SetWnCtlMonoColors( int style );

//-------------------------------------------------------------//

// node flags

enum mControlNodeFlags
{
   vSELECTABLE = 0x0001,      // node can be processed
   vCHECKABLE  = 0x0002,      // node can be checked
   vGHOSTABLE  = 0x0004,      // node can be ghosted
   vSELECTED   = 0x0010,      // node is selected
   vCHECKED    = 0x0020,      // node is checked
   vGHOSTED    = 0x0040,      // node is ghosted
   vPASSIVE    = 0x0100,      // node is visual only
   vNOFILL     = 0x0200,      // don't fill interior on draws
};

#define DEFAULT_BUTTON_FLAGS  ( vSELECTABLE )
#define DEFAULT_CHKBUT_FLAGS  ( vSELECTABLE | vCHECKABLE )
#define DEFAULT_MENU_FLAGS    ( vSELECTABLE | vGHOSTABLE )
#define DEFAULT_KNOB_FLAGS    ( vSELECTABLE )

// control flags

enum mControlStatusFlags
{
   xACTIVE     = 0x0001,
   xFOCUS      = 0x0002,
   xMODAL      = 0x0004,
   xIMMEDIATE  = 0x0008,
   xLOCKED     = 0x0010,
   xPROLOG     = 0x0020,
   xEPILOG     = 0x0040,
   xOPEN       = 0x0080,
};

enum mControlStyleFlags
{
   xVISIBLE    = 0x0001,
   xPREDRAW    = 0x0002,
   xPOSTDRAW   = 0x0004,
   xMOVABLE    = 0x0008,
   xAUTOCLEAR  = 0x0010,
   xCURSORED   = 0x0020,
   xALTMODE    = 0x0040,
   xTOOLCTL    = 0x0080,
};

//-------------------------------------------------------------//

// Control node

struct mControlNode
{
   mControlRegion  *rgn;              // border & area
   mControlSymbol  *sym;              // symbol or marking
   mControlText    *txt;              // associated text
   mKey             act;              // activation key
   short            sts;              // status flags

   mControlNode( );
   mControlNode( mControlRegion * r, mControlSymbol * s,
                 mControlText * t, mKey& k );
   virtual ~mControlNode( );
   virtual  void move( mPoint pt );
   virtual  void resize( int dx, int dy );
   void setstatus( short mask, int state )
   {
      if( state ) sts |= mask;
      else        sts &= ~mask;
   }
   int getstatus( short mask )
   {
      return ((sts&mask)==mask) ? 1 : 0;
   }
};

//-------------------------------------------------------------//

// Menu definition structure

struct mMenuDef
{
   char **labels;       // array of menu text labels
   mKey  *keys;         // activation key definitions
   short  nitems;       // number of items
   short  toggle;       // toggle char for highlighting
   mMenuDef( );
   mMenuDef( char **l, mKey *k, int n, int t );
   virtual ~mMenuDef( ) { }
};

//-------------------------------------------------------------//

// a text cursor class

class mTxCursor
{
   protected:

      mPoint  posn;     // cursor position
      char    hgt;      // cursor height in pixels
      char    ins;      // insert state
      char    act;      // active flag
      char    vis;      // visible flag

   public:

      mTxCursor( int h, int i );
      virtual ~mTxCursor( );

      virtual void draw( void );
      virtual void hide( void );
      virtual void show( void );
      virtual void move( int dx, int dy );
      virtual void move( mPoint newposn );
      virtual void toggle( void );
      void sethgt( int h );

      mPoint getposn( void )       { return posn; }
      void   setposn( mPoint pt )  { posn = pt; }
      int    visible( void )       { return vis; }
      int    insert( void )        { return ins; }
      int    active( void )        { return (act>0) ? 1 : 0; }
};

//-------------------------------------------------------------//

// a "text page" class

struct mTextPg
{
   char   *title;
   char  **lines;
   short   nlines;

   mTextPg( );
   mTextPg( char *t, char **l, int n );
   mTextPg( mTextPg& tp );
   virtual ~mTextPg( );
   mPoint   size( mFont* fnt );
};

//-------------------------------------------------------------//

// typedef for user-provided control task

class mWnControl;

typedef int (*mCtlTask)( mMsg&, mWnControl& );

//-------------------------------------------------------------//

// Virtual base class for all window controls

class mWnControl
{
      friend class mWindow;

   public :

      mWnControl   *prev;               // previous ctl
      mWnControl   *next;               // next ctl
      short         iden;               // identity
      short         tag;                // application value

   protected :

      short         class_id;           // Unique identifier
      short         status;             // control status flags
      short         style;              // control style flags
      short         nnodes;             // node count
      mControlNode *nodes;              // node list
      mMsg          action;             // xlated event
      void         *data;               // application data
      mCtlTask      task;               // application task
      mWindow      *wind;               // set by win << ctl

   private :

      void initcontrol( void );

   public :

      mWnControl( );
      mWnControl( int node_cnt );
      virtual ~mWnControl( );

      virtual void   draw( );
      virtual void   ghost( );
      virtual void   erase( int clr );
      virtual void   move( mPoint pt );
      virtual void   resize( int dx, int dy );
      virtual void   press( void );
      virtual void   unpress( void );
      virtual mRect  extent( void );
      virtual int    ptinctl( mPoint pt );
      virtual int    whichnode( mPoint pt );
      virtual int    ack( mEvent& evt );
      virtual mMsg&  xlate( mEvent& evt );
      virtual int    exec( mMsg& msg );

      // send message to control
      int operator << ( mMsg& msg ) { return exec(msg); }

      mWindow *      getwind( void )         { return wind; }
      void           setdata( void *dta )    { data = dta; }
      void *         getdata( void )         { return data; }
      void           settask( mCtlTask tsk ) { task = tsk; }
      mCtlTask       gettask( void )         { return task; }
      mControlNode * getnodes( void )        { return nodes; }

      void setstatus( short mask, int state )
      {
        if( state == -1 )  status = mask;
        else if( state )   status |= mask;
        else               status &= ~mask;
      }
      int getstatus( short mask )
      {
         return ((status & mask) == mask) ? 1 : 0;
      }
      int getstatusflags( void )
      {
         return status;
      }
      void setstyle( short mask, int state )
      {
        if( state == -1 )  style = mask;
        else if( state )   style |= mask;
        else               style &= ~mask;
      }
      int getstyle( short mask )
      {
         return ((style & mask) == mask) ? 1 : 0;
      }
      int getstyleflags( void )
      {
         return style;
      }
      void setbrush( mBrush br );

      void mshide( void );
      void msshow( void );
};

#endif
