//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWinMgr.H                                           //
// Desc:   The window manager                                  //
// Date:   Jan, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWINMGR_H_
#define _MWINMGR_H_

//-------------------------------------------------------------//

// type for a user-supplied manager task
class mWindowManager;
typedef void *mMgrData;
typedef int (*mMgrTask)( mWindowManager& wm, mMgrData md );

// max number of active manager tasks
#define NMT 8

//-------------------------------------------------------------//

void   SetDefaultPalette( int palno );
int    GetDefaultPalette( void );
void   SetMonoStyle( int style );
int    GetMonoStyle( void );
void   SetMinimizeOrg( mPoint p );
mPoint GetMinimizeOrg( void );
void   SetScrollingSpeed( int speed );
int    GetScrollingSpeed( void );

const int tx_cursor_id = 1001;

// manager flags
enum mManagerFlags
{
   zMODAL    = 0x0001,
   zMODALWIN = 0x0002,
   zMODALCTL = 0x0004,
   zACTIVE   = 0x0008,
   zFOCUS    = 0x0010,
   zMENUMODE = 0x0020,
   zLOCKED   = 0x0040,
   zPOSTQUIT = 0x0080,
};

//-------------------------------------------------------------//
//                      class mWindowManager                   //
//-------------------------------------------------------------//

class mWindowManager
{
   protected:

      mWindow       *wnhead;       // window list pointers
      mWindow       *wntail;
      mWindow       *wncurrent;
      mWnControl    *ctlcurrent;   // current ctl of cur win
      mWnCtlMenu    *ctlmenu;      // head of open menu hierarchy
      mGdMgr        *display;      // display manager instance
      mEventManager *evtmgr;       // event manager instance
      mMsDevice     *mouse;        // various devices
      mKbDevice     *keyboard;
      mTmDevice     *timer;
      mTxCursor     *txtcsr;       // text cursor
      mFont         *sysfont;      // the system font
      mRomFont      *romfont;      // the rom font
      mMgrTask       mgrtask[NMT]; // manager task table
      mMgrData       mgrdata[NMT]; // manager task data table
      mMsg           sysmsg;       // system message buffer
      int            ms_cursor;    // default mouse cursor
      int            wm_flags;     // window manager flags

      // execute messages
      void do_wind_msg( mMsg& msg );
      void do_ctrl_msg( mMsg& msg );
      void do_clnt_msg( mMsg& msg );
      void do_mngr_msg( mMsg& msg );
      void do_mous_msg( mMsg& msg );
      void do_kybd_msg( mMsg& msg );
      void do_timr_msg( mMsg& msg );

      // query messages
      void do_wind_qry( mMsg& msg );
      void do_ctrl_qry( mMsg& msg );
      void do_clnt_qry( mMsg& msg );
      void do_mngr_qry( mMsg& msg );
      void do_mous_qry( mMsg& msg );
      void do_kybd_qry( mMsg& msg );
      void do_timr_qry( mMsg& msg );

      // miscellaneous
      void  reset_menu( void );
      void  set_obscured_status( void );
      void  update_ms_cursor( void );
      void  draw_windows( void );
      void  redraw_window( mWindow *wn, mRect urgn );
      void  redraw_windows( int allwns, mRect urgn );
      void  update_windows( int allwns );
      void  wind_init( void );
      void  wind_term( void );
      int   ack( mEvent& evt );
      mMsg& xlate( mEvent& evt );
      int   exec( mMsg& msg );
      int   setcurwindow( mWindow *wn );

   public:

      mWindowManager( int device_flags = -1, mFont *sfnt = 0 );
     ~mWindowManager( );

      // attach and detach a window
      mWindowManager& operator << ( mWindow& wn );
      mWindowManager& operator >> ( mWindow& wn );

      // send message to window manager
      mWindowManager& operator << ( mMsg& msg );
      // receive message from window manager
      mWindowManager& operator >> ( mMsg& msg );

      // application process functions
      int process_ctl_list( mWnControl *ctl, mEvent& evt );
      int process_menu_list( mWnCtlMenu *ctl, mEvent& evt );
      void run( void );

      // task handling
      int  registertask( mMgrTask task, mMgrData data );
      void releasetask( int task_id );

      // parameter query functions
      mWindow&        curwindow( void )           { return *wncurrent; }
      mWnCtlMenu     *getctlmenu( void )          { return ctlmenu; }
      mMsDevice&      msdevice( void )            { return *mouse; }
      mKbDevice&      kbdevice( void )            { return *keyboard; }
      mTmDevice&      tmdevice( void )            { return *timer; }
      mTxCursor      *gettxtcsr( void )           { return txtcsr; }
      void            settxtcsr( mTxCursor *tc )  { txtcsr = tc; }
      mFont&          systemfont( void )          { return *sysfont; }
      mFont*          getsysfont( void )          { return sysfont; }
      mEventManager&  eventmgr( void )            { return *evtmgr; }
      mEvent*         lastevt( void )
         { return (mEvent *) evtmgr->lastdeq(); }
      int             getmscursor( void ) { return ms_cursor; }
      int             getbdrcursor( int area );
      mWindow *       findwindow( mPoint pt );
      mWindow *       findtopwindow( void );
      mWindow *       findbottomwindow( void );
      mWindow *       findnextwindow( mWindow* wn );
      mWindow *       findpreviouswindow( mWindow* wn );
      int             getstatus( int mask )
         { return ((wm_flags&mask)==mask) ? 1 : 0; }

      // parameter set functions
      void setsysfont( mFont *fnt );
      void setmscursor( int cursor );
      void setstatus( int x, int state )
      {
         if( state ) wm_flags |= x;
         else        wm_flags &= ~x;
      }

      // other public functions
      mQuilt* viewablearea( mWindow* wn, mRect ar );
};

#endif
