//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mWindow.H                                           //
// Desc:   Window-related classes                              //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MWINDOW_H_
#define _MWINDOW_H_

void mpe( char * );

// Window border types
enum mWnBorderTypes
{
   wBDRNONE    = 0,
   wBDRFIXED   = 1,
   wBDRSIZABLE = 2
};

// Window border areas
enum mWnBorderAreas
{
   wOUTSIDE    = -2,
   wINSIDE     = -1,
   wUPPER      =  1,
   wLOWER      =  2,
   wLEFT       =  3,
   wRIGHT      =  4,
   wUPPERLEFT  =  5,
   wUPPERRIGHT =  6,
   wLOWERLEFT  =  7,
   wLOWERRIGHT =  8
};

//-------------------------------------------------------------//
//                      miscellaneous                          //
//-------------------------------------------------------------//

void   draw_border_prompt( mRect& bdrout, mRect& bdrin );
void   alter_border_prompt( mRect& bdrout, mRect& bdrin,
                            mPoint& pt, mPoint& minpt, int area );
mPoint border_position( mRect& r, int area );
mPoint border_delta( int area, int dir );
mRect  border_limits( mWindow* win, int side );
int    next_border_area( int area );
void   sysmenuinit( mWnCtlBoxMenu& sm );
void   SetDefaultWnBdrThk( int thk );
int    GetDefaultWnBdrThk( void );
void   SetWnRotation( int state );
int    GetWnRotation( void );
mPoint GetWnSize( int clientDX, int clientDY, int ctlFlags );
void   SetVScrlBarLayout( int layout );
int    GetVScrlBarLayout( void );
void   SetHScrlBarLayout( int layout );
int    GetHScrlBarLayout( void );

//-------------------------------------------------------------//
//                      class mWnBorder                        //
//-------------------------------------------------------------//

class mWnBorder
{
   protected:

      uchar   bdrtype;           // fixed/sizable
      uchar   bdrthk;            // thickness
      uchar   bdrcrnr;           // inside corner hgt
      uchar   bdrflags;          // reserved
      mPen    bdrpen;            // edge colors
      mBrush  bdrbrush;          // fill colors
      mRect   bdrrect;           // border extent

   public:

      mWnBorder( mRect area, int type=wBDRFIXED );
      mWnBorder( );
      virtual ~mWnBorder( ) { }

      void  setbdrpen( mPen p )     { bdrpen = p; }
      void  setbdrbrush( mBrush b ) { bdrbrush = b; }
      void  setbdrrect( mRect r )   { bdrrect = r; }

      mPen   getbdrpen( void )      { return bdrpen; }
      mBrush getbdrbrush( void )    { return bdrbrush; }
      int    getbdrthkness( void )  { return bdrthk; }

      mRect interior( void )     { return bdrrect >> bdrthk; }
      mRect extent( void )       { return bdrrect; }
      int   bordertype( void )   { return bdrtype; }
      int   ctlhgt( void )       { return 255 & bdrcrnr; }
      int   ptinwindow( mPoint p );
      int   ptinborder( mPoint p );
      int   whicharea( mPoint p );
      int   mindxy( void );

      void  draw( void );
      void  ghost( void );
};

//-------------------------------------------------------------//

// Window system-controls type flags
enum mWnSysIdentifiers
{
   wcBORDER    = 0x0001,
   wcTITLE     = 0x0002,
   wcSYSMENU   = 0x0004,
   wcMINIMIZE  = 0x0010,
   wcMAXIMIZE  = 0x0020,
   wcAPPMENU   = 0x0040,
   wcHSCRLBAR  = 0x0100,
   wcVSCRLBAR  = 0x0200,
   wcTOOLBAR   = 0x0400,
};

// Generic control type identifiers
enum mWnCtlIdentifiers
{
   wcAPERTURE         = 0x1001,
   wcBUTTON           = 0x1002,
   wcTOGGLE           = 0x1003,
   wcCHECKBUTTON      = 0x1004,
   wcFIELD            = 0x1005,
   wcMLFIELD          = 0x1006,
   wcTEXT             = 0x1007,
   wcICON             = 0x1008,
   wcSYSICON          = 0x1009,
   wcMASK             = 0x100A,
   wcBOOK             = 0x100B,
   wcBARMENU          = 0x100C,
   wcBOXMENU          = 0x100D,
   wcHSCROLLBAR       = 0x1010,
   wcVSCROLLBAR       = 0x1011,
   wcHGAUGE           = 0x1012,
   wcVGAUGE           = 0x1013,
   wcHSCRLGAUGE       = 0x1014,
   wcVSCRLGAUGE       = 0x1015,
   wcHSLIDER          = 0x1016,
   wcVSLIDER          = 0x1017,
   wcTEXTLIST         = 0x1020,
   wcLIST             = 0x1021,
   wcLISTBOX          = 0x1022,
   wcTEXTCOMBOBOX     = 0x1030,
   wcCOMBOBOX         = 0x1031,
   wcSPINBUT          = 0x1040,
   wcBUTGROUP         = 0x1050,
   wcTOGGROUP         = 0x1051,
   wcRADIOGROUP       = 0x1052,
   wcCHKGROUP         = 0x1053,
   wcGROUPBOX         = 0x1060,

   // Lab Extension Controls
   wcLABSWITCH        = 0x2001,
   wcLABRCKSWITCH     = 0x2002,
   wcLABTOGSWITCH     = 0x2003,
   wcLABHEXSWITCH     = 0x2004,
   wcLABSELECTOR      = 0x2010,
   wcLABPOT           = 0x2011,
   wcLABLIGHT         = 0x2020,
   wcLABPILOTLIGHT    = 0x2021,
   wcLABLEDLIGHT      = 0x2022,
   wcLABLEDGAUGE      = 0x2023,
   wcLABINTDISPLAY    = 0x2030,
   wcLABCOUNTER       = 0x2031,
   wcLABADJCOUNTER    = 0x2032,
   wcLABMETER         = 0x2040,
   wcLABCRT           = 0x2050,
   wcLABSTRIPCHART    = 0x2060,

   // Pen Extension Controls
   wcPENFIELD         = 0x3001,
   wcPENCOMBOBOX      = 0x3002,
   wcPENGRID          = 0x3003,
   wcPENNOTEPAD       = 0x3004,
   wcPENSKETCHBOX     = 0x3005,

   wcCUSTOM           = 0x4000,
   wcUSER             = 0x8000,
};

// Window status flags
enum mWindowStatusFlags
{
   yOPEN          = 0x0001,   // window is open
   yMINIMIZED     = 0x0002,   // window is minimized
   yMAXIMIZED     = 0x0004,   // window is maximized
   yOBSCURED      = 0x0008,   // somebody's on top
   yCURRENT       = 0x0010,   // active focus window
   yMENUMODE      = 0x0020,   // menu is being processed
   ySYSMENUMODE   = 0x0040,   // window's system menu is open
   yMODAL         = 0x0080,   // window is modal
   yMODALSAVE     = 0x0100,   // save window's modality with menus
};

// Window Style flags
enum mWindowStyleFlags
{
   ySIZABLE       = 0x0001,   // window can be sized
   yMOVABLE       = 0x0002,   // window can be moved
   yGHOSTABLE     = 0x0004,   // window can be ghosted
   yBACKGROUND    = 0x0008,   // window cannot move to fg
   yDESTROY       = 0x0010,   // destroy when detached
   yCLOSEALL      = 0x0020,   // close win terminates run()
   yNOCLIENTFILL  = 0x0040,   // do not automatically fill the client area
   yBLITMOVE      = 0x0080,   // blit on move if possible
};

// typedef for window client task
typedef int (*mWinTask)( mMsg&, mWindow& );

class mWindowManager;

//-------------------------------------------------------------//
//                      class mWindow                          //
//-------------------------------------------------------------//

class mWindow : public mWnBorder
{
   friend class mWindowManager;

   public:

      mWindow     *prev;            // win chain links
      mWindow     *next;

   protected:

      // system-related members
      ushort       controlflags;    // system control list
      ushort       statusflags;     // current window status
      ushort       styleflags;      // current window's style
      char        *wntitle;         // window's title
      mFont       *wnfont;          // window's system font
      mPoint       wnorg;           // physical origin from lower left
      mPoint       restorg;         // restore origin
      ulong        tmstamp;         // time stamp - set by open
      int          width;           // default width
      int          height;          // default height
      int          minwidth;        // minimum allowable width
      int          minheight;       // minimum allowable height

      // window controls
      mWnControl    *head;
      mWnControl    *tail;

      // minimization related members
      mWnControl    *minimctls;
      mRect          minimrect;
      mPoint         minimorg;

      // window's main menu
      mWnCtlBarMenu *wnmenu;
      // window's current text cursored control
      mWnControl    *cursorctl;

      // client-related members
      mWnControl  *clientctl;       // start of client controls
      mFont       *clientfont;      // window's client font
      mRect        clientrect;      // extent of client aperture
      mPen         clientpen;       // pen for client drawing
      mBrush       clientbrush;     // brush for client drawing
      mWinTask     clienttask;      // window's client task
      void *       clientdata;      // pointer for client's use
      int          clienttag;       // int for client's use

      // pointer to the window manager
      mWindowManager *winmgr;       // set by WinMgr << Window

   private:

      void InitSysControls( mMenuDef *menu );
      void next_cursored_ctl( void );
      void prev_cursored_ctl( void );

   public:

      mWindow( char *title, mMenuDef *menu, mFont *fnt,
               int w, int h, int bdrtype, int sysflags=0 );
      mWindow();
      virtual ~mWindow( );

      //................................window manipulation functions
      void draw( void );
      void ghost( void );
      void update( mRect r );
      void open( void );
      void openbg( void );
      void close( void );
      void move( mPoint delta );
      void resize( mRect area );
      void minimize( void );
      void settitle( char *title );
      void setmenu( mMenuDef *mdef );
      void setmenu( mMenuDef *mdef, mFont *fnt );
      void setmenu( mWnCtlBarMenu *menu );
      void setmenu( mWnCtlBarMenu *menu, mFont *fnt );

      //................................window control functions
      mWindow& operator << ( mWnControl& ctl );
      mWindow& operator >> ( mWnControl& ctl );
      int      operator << ( mMsg& msg ) { return exec(msg); }
      int  exec( mMsg& msg );
      void broadcast( mMsg& msg );
      int  addtoolbar( int typ, int dim );

      //................................parameter set functions
      void setfont( mFont *fnt )           { wnfont = clientfont = fnt; }
      void setwnfont( mFont *fnt )         { wnfont = fnt; }
      void setclientfont( mFont *fnt )     { clientfont = fnt; }
      void setclientpen( mPen pn )         { clientpen = pn; }
      void setclientbrush( mBrush br )     { clientbrush = br; }
      void setclienttask( mWinTask task )  { clienttask = task; }
      void setclientdata( void *p )        { clientdata = p; }
      void setclienttag( int t )           { clienttag = t; }
      void setwnorigin( mPoint p )         { wnorg = p; }
      void setrestorg( mPoint p )          { restorg = p; }
      void setminimorg( mPoint p )         { minimorg = p; }
      void setsize( int w, int h )
      {
         width = w;
         height = h;
      }
      void setminsize( int w, int h )
      {
         minwidth = w;
         minheight = h;
      }
      void setstatus( int mask, int state )
      {
         if( state ) statusflags |= mask;
         else        statusflags &= ~mask;
      }
      void setstyle( int mask, int state )
      {
         if( state ) styleflags |= mask;
         else        styleflags &= ~mask;
      }

      //................................parameter query functions
      mWinTask     getclienttask( void )      { return clienttask; }
      mWnControl * getsyscontrol( int which );
      mWnControl * getcursorcontrol( void )   { return cursorctl; }
      mWnControl * getcontrollist( void )     { return head; }
      mWnControl * getclientctllist( void )   { return clientctl; }
      mWindowManager * getwnmgr( void )       { return winmgr; }
      mWnCtlBarMenu * getwnmenu( void )       { return wnmenu; }
      mPoint   getwnminsize( void ) { return mPoint(minwidth,minheight); }
      mFont *  getwnfont( void )              { return wnfont; }
      char  *  getwntitle( void )             { return wntitle; }
      mFont *  getclientfont( void )          { return clientfont; }
      mPen     getclientpen( void )           { return clientpen; }
      mBrush   getclientbrush( void )         { return clientbrush; }
      mRect    getclientrect( void )          { return clientrect; }
      void *   getclientdata( void )          { return clientdata; }
      int      getclienttag( void )           { return clienttag; }
      mPoint   getwnorigin( void )            { return wnorg; }
      mPoint   getrestorg( void )             { return restorg; }
      mPoint   getminimorg( void )            { return minimorg; }
      ushort   getcontrolflags( void )        { return controlflags; }
      ushort   getstatusflags( void )         { return statusflags; }
      ushort   getstyleflags( void )          { return styleflags; }
      int      getcontrolhgt( void )          { return mWnBorder::ctlhgt(); }
      int      getstatus( int mask )
      {
         return ((statusflags&mask) == mask) ? 1 : 0;
      }
      int      getstyle( int mask )
      {
         return ((styleflags&mask) == mask) ? 1 : 0;
      }

      //................................minimized window control functions
      mWnControl& setminimicon( mWnCtlSysIcon& si );
      mWnControl& setminimctls( mWnControl& ctls );
      void        freeminimctls( void );
      mWnControl *getminimhead( void )                { return minimctls; }
      mRect       getminimrect( void )                { return minimrect; }

      friend void DestroyWindow( mWindow *wn );
};

#endif
