//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mTime.Hpp                                           //
// Desc:   Time handling                                       //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MTIME_H_
#define _MTIME_H_

//-------------------------------------------------------------//
//                     Time Primitives                         //
//-------------------------------------------------------------//

int    mIsDst( void );
int    mGmtHrs( int lclhrs );
int    mLclHrs( int gmthrs );
char * mTimeZone( int resultcase=0 );
char * mAmPm( int hour, int resultcase=0 );
void   mParseTimeFormat( char * fmt, char * str, int hr,
                         int mn, int sc );
int    mParseTimeString( char * str, int * hr, int * mn,
                         int * sc );

//-------------------------------------------------------------//
//                       class mTime                           //
//-------------------------------------------------------------//

class mTime
{
   public:

      char hour;
      char min;
      char sec;

   protected:

      char * tmp;

   public:

      mTime( );
      mTime( mTime& t );
      mTime( int h, int m, int s );
      mTime( long s );
      virtual ~mTime( );

      //.....miscellaneous
      int isformatted( void )
      {
         return tmp ? 1 : 0;
      }

      //.....formatted times
      char * time( void );
      char * time( char * fmt );

      //.....hours on 12-hr clock
      int hour12( void );

      //.....rounded magnitudes
      long hours( void );
      long minutes( void );
      long seconds( void );

      //.....computation
      mTime  operator -  ( mTime& t );
      mTime  operator +  ( mTime& t );
      mTime& operator -= ( mTime& t );
      mTime& operator += ( mTime& t );

      //.....assignment
      mTime& operator = ( mTime& t );

      //.....time comparison
      int operator == ( mTime& t );
      int operator <  ( mTime& t );
      int operator <= ( mTime& t );
      int operator >  ( mTime& t );
      int operator >= ( mTime& t );
};

//-------------------------------------------------------------//
//                       System Time                           //
//-------------------------------------------------------------//

mTime& mSystemTime( void );

#endif
