//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mString.H                                           //
// Desc:   Definition of a String Class                        //
// Date:   Feb, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MSTRING_H_
#define _MSTRING_H_

//-------------------------------------------------------------//
//                       miscellaneous                         //
//-------------------------------------------------------------//

const int mAchar = '@';   // alpha character
const int mEchar = '^';   // escape character
const int mNchar = '#';   // numeric character
const int mRchar = '*';   // repeat character
const int mXchar = '&';   // any character

// apply format mask to "raw" to yield "cooked"
int apply_mask( char *cooked, char *raw, char *mask );

// is passed character one of the special characters?
int is_mask_char( int ch );

//-------------------------------------------------------------//
//                       class mString                         //
//-------------------------------------------------------------//

// The mString class provides methods for editing a null-
// terminated string, beyond what string.h provides

class mString
{
   protected:

      char *str;       // buffer to hold string
      int   max;       // max chars that can be stored
      int   len;       // current str length (0..max)

   public:

      mString( );
      mString( int nchars );
      mString( char *cstr );
      mString( mString& s );
      virtual ~mString( );

      void     put( char *s );
      char    *get( void ) { return str; }
      int      maxlen( void ) { return max; }
      int      length( void ) { return len; }
      int      index( int c );
      int      index( char *s );
      void     ovl( int c, int n );
      void     ovl( char *s, int n );
      void     ins( int c, int n );
      void     ins( char *s, int n );
      void     del( int n );
      void     setcase( int dir );
      void     clear( void );
      mString& trim( void );
      mString& substr( int i, int n );

      // assignment operator
      mString& operator = (mString& s );

      friend mString& operator +  ( mString& s1, mString& s2 );
      friend mString& operator += ( mString& s1, mString& s2 );
};

#endif
