//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mPropnl.H                                           //
// Desc:   A Proportional Machine                              //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MPROPNL_H_
#define _MPROPNL_H_

class mProportional
{
   protected:

      // domain
      short  dmin,
             dcur,
             dmax,
             dchg;

      // range
      short  rmin,
             rcur,
             rmax,
             rchg;

   public:

      mProportional( )
      {
      }
      mProportional( int dmn, int dmx, int rmn, int rmx )
      {
         dmin = dcur = dmn;
         dmax = dmx;
         rmin = rcur = rmn;
         rmax = rmx;
         dchg = rchg = 0;
      }
     ~mProportional( )
      {
      }

      int     domput( int dcu );
      mPoint  domread( void );
      mPoint  domextent( void ) { return mPoint( dmin, dmax ); }
      int     domget( void )    { return dcur; }
      int     domchg( void )    { return dchg; }
      int     domain( int dmn, int dcu, int dmx );
      int     domclip( int dtest );

      int     rngput( int rcu );
      mPoint  rngread( void );
      mPoint  rngextent( void ) { return mPoint( rmin, rmax ); }
      int     rngget( void )    { return rcur; }
      int     rngchg( void )    { return rchg; }
      int     range( int dmn, int dcu, int dmx );
      int     rngclip( int rtest );

      void    set( int dmn, int dmx, int rmn, int rmx )
      {
         dmin = dcur = dmn;
         dmax = dmx;
         rmin = rcur = rmn;
         rmax = rmx;
         dchg = rchg = 0;
      }
};

#endif
