//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mPath.H                                             //
// Desc:   PostScript-style path class                         //
// Date:   Mar, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MPATH_H_
#define _MPATH_H_

class mPath
{
   protected:

      mPoint  *pts;       // x-y point array
      mPoint  *idx;       // bgn-end index array
      short    pcnt;      // point count
      short    pmax;      // point capacity
      short    icnt;      // shape count
      short    imax;      // shape capacity

   public:

      mPath( );
      mPath( int np, int ns );
      virtual ~mPath( );

      void newpath( void );
      int  closepath( void );
      int  moveto( mPoint p );
      int  lineto( mPoint p );
      int  curveto( mPoint p1, mPoint p2, mPoint p3, int nseg=0 );
      int  arcto( mPoint po, int ang, int nseg=0 );
      void move( mPoint p );
      void scale( int xyn, int xyd );
      void scalex( int xn, int xd );
      void scaley( int yn, int yd );
      void rotate( int ang );
      void draw( mPen pn );
      void fill( mBrush br );
};

#endif
