//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mPalette.H                                          //
// Desc:   Custom Menuet palette definitions                   //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MPALETTE_H_
#define _MPALETTE_H_

//-------------------------------------------------------------//

// constant palette members

#define  PAL00   mRgb(   0,  0,  0 )  // BLACK
#define  PAL01   mRgb( 101,101,101 )  // DARK GRAY

#define  PAL05   mRgb( 251,190,113 )  // GOLD
#define  PAL06   mRgb( 219, 65, 65 )  // RED
#define  PAL07   mRgb(  51,153,102 )  // GREEN
#define  PAL08   mRgb(  16,105,134 )  // BLUE
#define  PAL09   mRgb( 150, 16, 65 )  // BURGUNDY
#define  PAL10   mRgb(  12,198,206 )  // SKY BLUE

#define  PAL14   mRgb( 202,202,202 )  // LIGHT GRAY
#define  PAL15   mRgb( 255,255,255 )  // WHITE

//-------------------------------------------------------------//

// built-in 16-color palettes

static mRgb AntiquePal[] =
{
   PAL00,
   PAL01,
   mRgb( 101,113,142 ),
   mRgb( 113,130,154 ),
   mRgb( 125,146,162 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 138,162,174 ),
   mRgb( 150,178,186 ),
   mRgb( 162,194,198 ),
   PAL14,
   PAL15
};

static mRgb BordeauxPal[] =
{
   PAL00,
   PAL01,
   mRgb( 112, 84, 84 ),
   mRgb( 140,110,102 ),
   mRgb( 168,135,120 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 199,158,135 ),
   mRgb( 227,184,153 ),
   mRgb( 255,209,171 ),
   PAL14,
   PAL15
};

static mRgb BrassPal[] =
{
   PAL00,
   PAL01,
   mRgb(  84, 84, 84 ),
   mRgb( 117,115,102 ),
   mRgb( 153,143,120 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 186,173,135 ),
   mRgb( 222,201,153 ),
   mRgb( 255,232,171 ),
   PAL14,
   PAL15
};

static mRgb CrystalPal[] =
{
   PAL00,
   PAL01,
   mRgb( 101,162,170 ),
   mRgb( 130,166,166 ),
   mRgb( 154,174,162 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 178,182,162 ),
   mRgb( 202,186,158 ),
   mRgb( 231,194,154 ),
   PAL14,
   PAL15
};

static mRgb DesertPal[] =
{
   PAL00,
   PAL01,
   mRgb( 223,162,113 ),
   mRgb( 223,174,130 ),
   mRgb( 223,182,150 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 223,194,162 ),
   mRgb( 223,202,182 ),
   mRgb( 223,215,198 ),
   PAL14,
   PAL15
};

static mRgb DorianPal[] =
{
   PAL00,
   PAL01,
   mRgb( 109,109,109 ),
   mRgb( 130,130,130 ),
   mRgb( 150,150,150 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 170,170,170 ),
   mRgb( 190,190,190 ),
   mRgb( 210,210,210 ),
   PAL14,
   PAL15
};

static mRgb GoldPal[] =
{
   PAL00,
   PAL01,
   mRgb( 184,117, 51 ),
   mRgb( 199,138, 77 ),
   mRgb( 212,158,102 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 227,176,130 ),
   mRgb( 240,196,156 ),
   mRgb( 255,217,181 ),
   PAL14,
   PAL15
};

static mRgb LeatherPal[] =
{
   PAL00,
   PAL01,
   mRgb( 174,121,105 ),
   mRgb( 182,134,121 ),
   mRgb( 190,150,134 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 198,162,146 ),
   mRgb( 202,178,158 ),
   mRgb( 210,190,170 ),
   PAL14,
   PAL15
};

static mRgb MeadowPal[] =
{
   PAL00,
   PAL01,
   mRgb( 142,134,121 ),
   mRgb( 162,154,138 ),
   mRgb( 182,170,146 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 202,194,178 ),
   mRgb( 223,215,198 ),
   mRgb( 243,235,219 ),
   PAL14,
   PAL15
};

static mRgb MossPal[] =
{
   PAL00,
   PAL01,
   mRgb(  84,102, 92 ),
   mRgb( 112,128,120 ),
   mRgb( 143,153,148 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 171,179,173 ),
   mRgb( 201,204,201 ),
   mRgb( 230,230,230 ),
   PAL14,
   PAL15
};

static mRgb MountainPal[] =
{
   PAL00,
   PAL01,
   mRgb( 130,109, 97 ),
   mRgb( 146,125,113 ),
   mRgb( 166,146,134 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 190,170,158 ),
   mRgb( 210,190,178 ),
   mRgb( 227,206,194 ),
   PAL14,
   PAL15
};

static mRgb OceanPal[] =
{
   PAL00,
   PAL01,
   mRgb(   4,138,138 ),
   mRgb(  24,150,150 ),
   mRgb(  45,158,162 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb(  65,166,178 ),
   mRgb(  85,174,190 ),
   mRgb( 105,186,202 ),
   PAL14,
   PAL15
};

static mRgb PewterPal[] =
{
   PAL00,
   PAL01,
   mRgb(  16,105,134 ),
   mRgb(  53,121,150 ),
   mRgb(  85,142,158 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 121,158,170 ),
   mRgb( 154,174,182 ),
   mRgb( 190,194,194 ),
   PAL14,
   PAL15
};

static mRgb ReefPal[] =
{
   PAL00,
   PAL01,
   mRgb(  15,105,128 ),
   mRgb(  59,128,138 ),
   mRgb(  99,153,150 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 143,176,161 ),
   mRgb( 184,201,173 ),
   mRgb( 227,224,184 ),
   PAL14,
   PAL15
};

static mRgb SkyPal[] =
{
   PAL00,
   PAL01,
   mRgb(  15, 99,128 ),
   mRgb(  43,122,148 ),
   mRgb(  71,143,168 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb(  97,166,186 ),
   mRgb( 125,186,207 ),
   mRgb( 153,209,227 ),
   PAL14,
   PAL15
};

static mRgb SunsetPal[] =
{
   PAL00,
   PAL01,
   mRgb( 142, 12, 12 ),
   mRgb( 162, 53, 49 ),
   mRgb( 182, 97, 81 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 202,138,117 ),
   mRgb( 223,182,150 ),
   mRgb( 243,223,186 ),
   PAL14,
   PAL15
};

static mRgb TomcatPal[] =
{
   PAL00,
   PAL01,
   mRgb(  12,121,162 ),
   mRgb(  53,134,162 ),
   mRgb(  89,146,158 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 130,162,154 ),
   mRgb( 170,174,154 ),
   mRgb( 210,186,150 ),
   PAL14,
   PAL15
};

static mRgb WoodPal[] =
{
   PAL00,
   PAL01,
   mRgb( 128, 84, 61 ),
   mRgb( 153,115, 84 ),
   mRgb( 179,143,105 ),
   PAL05,
   PAL06,
   PAL07,
   PAL08,
   PAL09,
   PAL10,
   mRgb( 204,173,128 ),
   mRgb( 230,201,148 ),
   mRgb( 255,232,171 ),
   PAL14,
   PAL15
};

static mRgb EgaBlue[] =
{
   mRgb(   0,   0,   0 ),   //  0
   mRgb(  64,  64,  64 ),   //  1
   mRgb(   0,  64, 128 ),   //  2
   mRgb(  64,  64, 192 ),   //  3
   mRgb(  64, 128, 192 ),   //  4
   mRgb( 192, 128,  64 ),   //  5
   mRgb( 192,  64,  64 ),   //  6
   mRgb(   0, 128, 128 ),   //  7
   mRgb(   0,  64,  64 ),   //  8
   mRgb( 128,   0,  64 ),   //  9
   mRgb( 192, 192, 128 ),   // 10
   mRgb(  64, 192, 192 ),   // 11
   mRgb(  64, 192, 192 ),   // 12
   mRgb( 128, 192, 192 ),   // 13
   mRgb( 128, 128, 128 ),   // 14
   mRgb( 192, 192, 192 ),   // 15
};

mRgb *PalList[] =
{
     AntiquePal,
     BordeauxPal,
     BrassPal,
     CrystalPal,
     DesertPal,
     DorianPal,
     GoldPal,
     LeatherPal,
     MeadowPal,
     MossPal,
     MountainPal,
     OceanPal,
     PewterPal,
     ReefPal,
     SkyPal,
     SunsetPal,
     TomcatPal,
     WoodPal,
     EgaBlue,
};

char *PalNames[] =
{
    "Antique",
    "Bordeaux",
    "Brass",
    "Crystal",
    "Desert",
    "Dorian",
    "Gold",
    "Leather",
    "Meadow",
    "Moss",
    "Mountain",
    "Ocean",
    "Pewter",
    "Reef",
    "Sky",
    "Sunset",
    "Tomcat",
    "Wood",
    "EGA-Blue",
    "User",
};

#endif
