//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   Mn_Const.H                                          //
// Desc:   Commonly used constants                             //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MN_CONST_H_
#define _MN_CONST_H_

// Common return codes & states

enum mStatusCodes
{
   INSTALLED  =   2,
   OKAY       =   1,
   FAILED     =   0,
   CANCEL     =  -1,
   HELP       =  -2,
   DISABLED   =  -3,
   NOTFOUND   = -11,
   NOMEMORY   = -22,
   BADFORMAT  = -33,
   EMPTY      = -44,
};

// Constants used in list processing

enum mListItems
{
   LAST_ITEM = -1,
   CURR_ITEM = -2,
};

// Constants used in string processing

enum mStringCodes
{
   UPPER   =  1,
   LOWER   = -1,
   FIXED   =  0,
   VARYING =  1,
};

// File I/O states

enum mFileStates
{
   fINPUT  = 1,
   fOUTPUT = 2,
   fUPDATE = 3,
};

// Geometric object comparison

enum mGeometricRelations
{
   EQUAL    =  0,
   INSIDE   =  1,
   ONSIDE   =  2,
   OUTSIDE  =  4,
   OVERLAP  =  8,
   CONTAIN  = 16,
};

// Justifications

enum mJustifications
{
   jHORZ    =  0x07,
   jLEFT    =  0x01,
   jRIGHT   =  0x02,
   jCENTER  =  0x04,

   jVERT    =  0xF0,
   jBASE    =  0x10,
   jUPPER   =  0x20,
   jLOWER   =  0x40,
   jMIDDLE  =  0x80,

   jXYTEXT  =  (jLEFT|jBASE),
   jXYRECT  =  (jCENTER|jMIDDLE),
};

// Graphics write modes

enum mPixelWriteModes
{
   wSET = 0,
   wXOR = 1,
};

// Directions

enum mDirections
{
   DIR_UP    =  90,
   DIR_DOWN  = 270,
   DIR_LEFT  = 180,
   DIR_RIGHT =   0,
   DIR_VERT  =   1,
   DIR_HORZ  =   2,
};

// Rotations

enum mRotations
{
   ROT_0   =   0,
   ROT_90  =  90,
   ROT_180 = 180,
   ROT_270 = 270,
};

// Region "height" states

enum mRegionTypes
{
   rgnINSET   = -1,
   rgnFLAT    =  0,
   rgnOUTSET  =  1,
   rgnRIDGED  =  2,
   rgnGROOVED =  3,
};

// Font status flags

enum mFontStatus
{
   fNOINIT     = 0,
   fINIT       = 1,
   fNOTFOUND   = 2,
   fLOADERROR  = 3,
   fALLOCERROR = 4,
};

// Important palette index defines

enum mColors
{
   cBLACK     =  0,     // grays
   cDKGRAY    =  1,
   cLTGRAY    = 14,
   cWHITE     = 15,

   cGOLD      =  5,     // standard static colors
   cRED       =  6,
   cGREEN     =  7,
   cBLUE      =  8,
   cBURGUNDY  =  9,
   cSKYBLUE   = 10,

   cDKCOLORLO =  2,     // thematic color
   cDKCOLORMD =  3,
   cDKCOLORHI =  4,
   cLTCOLORLO = 11,
   cLTCOLORMD = 12,
   cLTCOLORHI = 13,

   cHIGHLIGHT =  8,     // highlight color
};

// Error severity levels

enum mErrorLevels
{
   eWARNING  =  1,
   eSERIOUS  =  4,
   eFATAL    =  8,
};

// Error categories

enum mErrorCategories
{
   eSYSTEM    = 1,    // OS related error
   eFILEIO    = 2,    // IO error
   eMEMORY    = 3,    // Allocation failure
   ePARAM     = 4,    // Bad parameter
   eCONSTR    = 5,    // Constructor error
   eDISPMGR   = 6,    // Display manager
   eFONTMGR   = 7,    // Font manager
   eAPPL      = 8,    // Application specific
};

// Control status manipulation

enum mControlStatus
{
   stsREPL   = -1,    // Replace existing value
   stsCLEAR  =  0,    // Clear bit flags
   stsSET    =  1,    // Set bitflags
};

// Scrolling rates

enum mScrollingSpeeds
{
   sFAST    = 0,
   sMEDIUM  = 1,
   sSLOW    = 3,
};

// Button layout codes

enum mButtonLayouts
{
   butHORIZONTAL = 0x10,
   butLEFTRIGHT  = 0x11,
   butLEFTLEFT   = 0x12,
   butRIGHTRIGHT = 0x14,

   butVERTICAL   = 0x20,
   butUPDOWN     = 0x21,
   butDOWNDOWN   = 0x22,
   butUPUP       = 0x24,
};

enum mToolBarTypes
{
   mTlbTOP       = 0x0001,
   mTlbBOTTOM    = 0x0002,
   mTlbLEFT      = 0x0004,
   mTlbRIGHT     = 0x0008,
};

#define  isHORZ(x)       ( (x & butHORIZONTAL) ? 1 : 0 )
#define  isVERT(x)       ( (x & butVERTICAL) ? 1 : 0 )

// Miscellaneous

#define  KEEP            1
#define  DISCARD         0
#define  DEFAULT        -1
#define  _SIGNAL_   -32768
#define  pCENTER     -9999

#endif
