//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mn_Asm.H                                            //
// Desc:   Miscellaneous assembler functions                   //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MN_ASM_H_
#define _MN_ASM_H_

// turn on MetaWare High C++ special naming convention
//#ifdef __HIGHC__
//#pragma Global_aliasing_convention( "_%r" );
//#endif

// turn on Watcom special naming convention
#ifdef WATCOM
#define _CDCL_ cdecl
#else
#define _CDCL_
#endif

// keyboard rates and delays

const int delay250 = 0x0000;
const int delay500 = 0x0001;
const int delay750 = 0x0002;

const int rate30 = 0x0000;
const int rate25 = 0x0002;
const int rate20 = 0x0004;
const int rate15 = 0x0008;
const int rate10 = 0x000C;
const int rate05 = 0x0014;

// index defines for values returned by ms_query

const int mqXLOC  = 0;
const int mqYLOC  = 1;
const int mqBUTF  = 2;

// parameters to vo_fontmap

const int mapCGALO = 3;
const int mapCGAHI = 4;
const int mapEGA   = 2;
const int mapVGA   = 6;

extern "C"
{
   // bitmask write for EGA/VGA
   void _CDCL_ wrt_bitmask( int x, int y, char *mask,
                            int w, int h, int px );

   // read system timer tick count
   unsigned long _CDCL_ gettimercount( void );

   // int 16h keyboard interface
   int  _CDCL_ kb_test( void );
   int  _CDCL_ kb_read( void );
   int  _CDCL_ kb_readx( void );
   int  _CDCL_ kb_flags( void );
   void _CDCL_ kb_rate( int delay, int rate );
   int  _CDCL_ kb_write( int key );

   // int 33h mouse driver interface
   int   _CDCL_ ms_init( void );
   void  _CDCL_ ms_term( void );
   void  _CDCL_ ms_hide( void );
   void  _CDCL_ ms_show( void );
   int   _CDCL_ ms_test( void );
   void  _CDCL_ ms_read( int retv[3] );
   void  _CDCL_ ms_query( int retv[3] );
   void  _CDCL_ ms_limit( int x1, int y1, int x2, int y2 );
   void  _CDCL_ ms_posn( int x, int y );
   void  _CDCL_ ms_setcsr( void *masks, int xhot, int yhot );
   void  _CDCL_ ms_setcursor( int id );
   void  _CDCL_ ms_setcsrprocs( void (*)(int,int), void (*)(int,int) );

   // video and int 10h functions
   void  _CDCL_  setvideomode( int mode );
   int   _CDCL_  getvideomode( void );
   int   _CDCL_  vo_fonthgt( void );
   char  _CDCL_ *vo_fontmap( int which_map );
   int   _CDCL_  is_ega_color( void );
   int   _CDCL_  is_vga_color( void );
   int   _CDCL_  getvgapalreg( int reg_no );
   void  _CDCL_  setvgapalreg( int reg_no, int reg_val );
   void  _CDCL_  getvgadacreg( void *clrs, int clr1, int nclrs );
   void  _CDCL_  setvgadacreg( void *clrs, int clr1, int nclrs );

   // sound related functions
   void _CDCL_ set_freq( unsigned freq );
   void _CDCL_ start_snd( void );
   void _CDCL_ stop_snd( void );
   void _CDCL_ wait_for( unsigned int nTicks );
   void _CDCL_ beep( void );

   // file and directory search functions
   int   _CDCL_  ffilecount( char * pathspec );
   int   _CDCL_  fdircount( char * pathspec );
   int   _CDCL_  ffirstfile( char * pathspec );
   int   _CDCL_  ffirstdir( char * pathspec );
   int   _CDCL_  fnextfile( void );
   int   _CDCL_  fnextdir( void );
   char  _CDCL_ *fgetname( void );
   long  _CDCL_  fgetsize( void );
   long  _CDCL_  fgetdate( void );
   long  _CDCL_  fgettime( void );
   int   _CDCL_  fgetattr( void );

   // disk related functions
   long  _CDCL_  getdrivelist( void );
   int   _CDCL_  getdrivecount( void );
   int   _CDCL_  getcurrentdrive( void );
   char  _CDCL_ *getcurrentdir( void );
   int   _CDCL_  testdrive( int drive );

   // critical error handler interface
   void  _CDCL_  mceh_install( void );
   void  _CDCL_  mceh_remove( void );
   void  _CDCL_  mceh_clear( void );
   int   _CDCL_  mceh_installed( void );
   int   _CDCL_  mceh_query( void );
   int   _CDCL_  mceh_qerr( void );
   int   _CDCL_  mceh_qdrv( void );
   char  _CDCL_ *mceh_error( int err_code );

#ifdef __WATCOMC__
// EMS and XMS are not supported in 286/386 protected mode
#else
#ifdef __HIGHC__
// EMS and XMS are not supported in 286/386 protected mode
#else
#ifdef DOS386
// EMS and XMS are not supported in 286/386 protected mode
#else
   // ems access
   int    _CDCL_    EMS_installed( void );
   int    _CDCL_    EMS_kbavail( void );
   char   _CDCL_  * EMS_pgframeaddr( int physical_pg );
   int    _CDCL_    EMS_alloc( int npages );
   void   _CDCL_    EMS_free( int EMShandle );
   int    _CDCL_    EMS_mappage( int hand, int lpage, int ppage );

   // xms access
   struct XMSmovestruct
   {
      unsigned long  nbytes;
      unsigned short srchandle;
      unsigned long  srcoffset;
      unsigned short dsthandle;
      unsigned long  dstoffset;
   };

   int       _CDCL_ XMS_installed( void );
   int       _CDCL_ XMS_kbavail( void );
   unsigned  _CDCL_ XMS_alloc( int nKBytes );
   void      _CDCL_ XMS_free( unsigned XMShand );
   int       _CDCL_ XMS_move( XMSmovestruct *ms );
#endif
#endif
#endif

}

// turn off MetaWare High C++ special naming convention
//#ifdef __HIGHC__
//#pragma Global_aliasing_convention();
//#endif

#endif
