//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   Mn3Dials.H                                          //
// Desc:   Builtin dialogs and service windows                 //
// Date:   Jan, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MN3DIALS_H_
#define _MN3DIALS_H_

enum mDialogCodes
{
   mDlgPALETTE,
   mDlgSPALETTE,
   mDlgPALEDIT,
   mDlgWARNING,
   mDlgNOTIFY,
   mDlgQUERY,
   mDlgCALC,
   mDlgSCICALC,
   mDlgCALENDAR,
   mDlgQCALENDAR,
   mDlgCLOCK,
   mDlgFILEBOX,
   mDlgFILE,
   mDlgFREEMEM,
   mDlgEVTMON,
   mDlgEYES,
   mDlgABPAD,
   mDlgNUMPAD,
   mDlgFUNCPAD,
};

// various function callbacks used by the dialogs

typedef void (*RSPPROC)( mWindowManager& wm, int resp );
typedef void (*PCKPROC)( mWindowManager& wm, char *pick );
typedef void (*NPCKPROC)( mWindowManager& wm, char *pick, int type );
typedef void (*SIGPROC)( int );
typedef void (*KEYPROC)( int );
extern "C"
{
typedef int  (*PXLREAD)( int, int );
}

// dialog creation functions

mWindow* create_palette_window( mFont *fnt, mWindow *parent=0 );

mWindow* create_small_palette_window( mFont *fnt, mWindow *parent=0 );

mWindow* create_paledit_window( mFont *fnt, mWindow *parent=0 );

mWindow* create_warning_window( mFont *fnt, mTextPg *tp,
                                mWindow *parent=0 );

mWindow* notify( mFont *fnt, char *title, char *msg, mWindow *parent=0 );

mWindow* create_query_window( mFont *fnt, mTextPg *tp, RSPPROC proc,
                              mWindow *parent=0 );

mWindow* create_scientific_calc_window( mFont *lgFnt, mFont *smFnt,
                                        mWindow *parent=0 );

mWindow* create_calc_window( mFont *fnt, mWindow *parent=0 );

mWindow* create_calendar_window( mFont *lgFnt, mFont *smFnt,
                                 mWindow *parent=0 );

mWindow* create_clock_window( mFont *fnt, mWindow *parent=0 );

mWindow * create_filebox_window( mFont *fnt, char *title,
                                 char *path, char *pick,
                                 PCKPROC proc, mWindow *parent=0 );

mWindow * create_file_window( mFont *fnt, char *title,
                              char *path, char *pick,
                              char **typs, int ntyps, int ctyp,
                              NPCKPROC proc, int mustpick = 1,
                              mWindow *parent=0 );

mWindow * create_freemem_window( mFont *fnt, mWindow *parent=0 );

mWindow * create_eventmonitor( mFont *fnt, mWindow *parent=0 );

mWindow * create_eyes_window( mWindowManager& mgr, mWindow *parent=0 );

mWindow * alphabetic_pad_window( mFont *fnt, char *title,
                                 int dxy, mCtlTask keyp );

mWindow * numeric_pad_window( mFont *fnt, char *title,
                              int dxy, mCtlTask keyp );

mWindow * function_pad_window( mFont *fnt, char *title,
                               int dx, int dy, mCtlTask keyp );

#endif
