//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mMusic.H                                            //
// Desc:   Stuff for playing music via PC speaker              //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MMUSIC_H_
#define _MMUSIC_H_

//-------------------------------------------------------------//
//                           constants                         //
//-------------------------------------------------------------//

// n==natural, s=sharp, f=flat

enum mNotePitches
{
   // no pitch
   pOFF=-1,
   // zeroth octave
   Cn0=0,  Cs0=1,  Df0=1,  Dn0=2,  Ds0=3,  Ef0=3,  En0=4,
   Fn0=5,  Fs0=6,  Gf0=6,  Gn0=7,  Gs0=8,  Af0=8,  An0=9,
   As0=10, Bf0=10, Bn0=11,
   // first octave
   Cn1=12, Cs1=13, Df1=13, Dn1=14, Ds1=15, Ef1=15, En1=16,
   Fn1=17, Fs1=18, Gf1=18, Gn1=19, Gs1=20, Af1=20, An1=21,
   As1=22, Bf1=22, Bn1=23,
   // second octave
   Cn2=24, Cs2=25, Df2=25, Dn2=26, Ds2=27, Ef2=27, En2=28,
   Fn2=29, Fs2=30, Gf2=30, Gn2=31, Gs2=32, Af2=32, An2=33,
   As2=34, Bf2=34, Bn2=35,
   // third octave
   Cn3=36, Cs3=37, Df3=37, Dn3=38, Ds3=39, Ef3=39, En3=40,
   Fn3=41, Fs3=42, Gf3=42, Gn3=43, Gs3=44, Af3=44, An3=45,
   As3=46, Bf3=46, Bn3=47,
   // top note
   Cn4=48
};

enum Tempos
{
   Allegro,
   Andante,
   Lento,
};

enum Styles
{
   Slurred,
   Legato,
   Staccato,
};

//-------------------------------------------------------------//
//                           classes                           //
//-------------------------------------------------------------//

struct mNote
{
   int frq;
   int dur;
};

class mSong
{
   public:

      int     cnt;    // note count
      int     cur;    // current note
      mNote * notes;  // notes array
      int     tempo;  // duration multiplier
      int     style;  // legato-to-staccato

      mSong( );
      mSong( int ncnt, mNote * nts );
      virtual ~mSong( );

      void playfirst( void );
      int  playnext( void );
      void play( void );
};

//-------------------------------------------------------------//
//                       canned tunes                          //
//-------------------------------------------------------------//

enum SongThemes
{
   tStarTrek,
   tGoodBadUgly,
   tBachToccata,
   tEntertainer,
   tNewWorld,
   tBikeForTwo,
   tPolovetzian,
   tDannyBoy,
   tGoodKing,
   tSantaLucia,
   tStarWars,
   tThemeCnt,
};

mSong * mGetTheme( int which );

//-------------------------------------------------------------//
//                          chords                             //
//-------------------------------------------------------------//

void mMajorChord( int tonic, int cnt, mNote * notes );
void mMinorChord( int tonic, int cnt, mNote * notes );
void mDom7thChord( int tonic, int cnt, mNote * notes );
void mMaj7thChord( int tonic, int cnt, mNote * notes );
void mMin7thChord( int tonic, int cnt, mNote * notes );
void mDim7thChord( int tonic, int cnt, mNote * notes );
void mDom9thChord( int tonic, int cnt, mNote * notes );

//-------------------------------------------------------------//
//                       sound effects                         //
//-------------------------------------------------------------//

enum SoundEffectIDs
{
   fxAlarm,
   fxBleep,
   fxTelephone,
   fxRandomPitch,
   fxRandomPitchCnt,
   fxTick,
   fxFogHorn,
   fxCarHorn,
   fxBird,
   fxFalling,
   fxThud,
   fxCount,
};

void SoundEffect( int which );

#endif
