//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mMsg.H                                              //
// Desc:   Message class                                       //
// Date:   Jan, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MMSG_H_
#define _MMSG_H_

//-------------------------------------------------------------//

//................message verbs

enum mMsgVerbs
{
   mNULL         =   0,
   mUSERVERB     =   1001,

   mOPEN         =  11,
   mCLOSE        =  12,
   mCANCEL       =  13,
   mQUIT         =  14,
   mREOPEN       =  15,
   mPOSTQUIT     =  16,
   mATTACH       =  17,
   mDETACH       =  18,

   mMINIMIZE     =  21,
   mMAXIMIZE     =  22,
   mRESTORE      =  23,
   mTOP          =  24,
   mUNMINIMIZE   =  25,
   mGHOST        =  26,

   mCURRENT      =  31,
   mNEXT         =  32,
   mPREVIOUS     =  33,
   mNEW          =  34,
   mTOGGLE       =  35,
   mROTATE       =  36,
   mCONTINUE     =  37,
   mBLINK        =  38,

   mUP           =  41,
   mDOWN         =  42,
   mLEFT         =  43,
   mRIGHT        =  44,

   mCREATE       =  51,
   mDESTROY      =  52,
   mINIT         =  53,
   mTERM         =  54,
   mSET          =  55,
   mRESET        =  56,
   mDISABLE      =  57,
   mENABLE       =  58,
   mQUERY        =  59,

   mSETFOCUS     =  61,
   mSETMODAL     =  62,
   mSAVEORIGIN   =  63,
   mSETMENU      =  64,
   mIDLE         =  65,

   mBGNUPDATE    =  71,
   mUPDATE       =  72,
   mENDUPDATE    =  73,

   mBGNSELECT    =  81,
   mSELECT       =  82,
   mENDSELECT    =  83,
   mHIGHLIGHT    =  84,

   mBGNSCROLL    =  91,
   mSCROLL       =  92,
   mENDSCROLL    =  93,
   mPAGEUP       =  94,
   mPAGEDOWN     =  95,
   mPAGELEFT     =  96,
   mPAGERIGHT    =  97,

   mBGNDRAG      = 101,
   mDRAG         = 102,
   mENDDRAG      = 103,

   mBGNADJUST    = 111,
   mADJUST       = 112,
   mENDADJUST    = 113,

   mBGNMOVE      = 121,
   mMOVE         = 102,
   mENDMOVE      = 123,

   mBGNSIZE      = 131,
   mSIZE         = 132,
   mENDSIZE      = 133,
   mALTSIZE      = 134,
   mRESIZE       = 135,

   mBGNEXECUTE   = 141,
   mEXECUTE      = 142,
   mENDEXECUTE   = 143,
   mALTEXECUTE   = 144,

   mBGNDRAW      = 151,
   mDRAW         = 152,
   mENDDRAW      = 153,

   mBGNEDIT      = 161,
   mEDIT         = 162,
   mENDEDIT      = 163,
   mHOME         = 164,
   mEND          = 165,
   mINSERT       = 166,
   mDELETE       = 167,
   mOVERLAY      = 168,
   mBACKSPACE    = 169,

   mHIDECURSOR   = 171,
   mSHOWCURSOR   = 172,
   mLOCKCURSOR   = 173,
   mUNLOCKCURSOR = 174,
   mLIMITCURSOR  = 175,
   mSETCURSOR    = 176,
   mPOSNCURSOR   = 177,
   mMOVECURSOR   = 178,
   mGETCURSOR    = 179,

   mQUERYCURSOR  = 181,
   mQUERYDELTA   = 182,
   mQUERYPOSN    = 183,
   mQUERYBUTTONS = 184,

   mFLUSH        = 191,
   mREDUCE       = 192,

   mBGNPAINT     = 201,
   mPAINT        = 202,
   mENDPAINT     = 203,

   mSETWNDBGND   = 300,
   mSETDLGCLOSED = 301,

   mSETALARMON   = 400,
   mSETALARMOFF  = 401,
   mSETTIMEON    = 402,
   mSETTIMEOFF   = 403,

//   mSETCARDBACK  = 800,
//   mSETCARDGAME  = 801,
};

//................message nouns

enum mMsgNouns
{
   mNOTHING      =   0,
   mMANAGER      = 101,
   mCLIENT       = 201,
   mWINDOW       = 301,
   mCONTROL      = 401,
   mMOUSE        = 501,
   mKEYBOARD     = 502,
   mTIMER        = 503,
   mAPPL         = 504,
   mEVT          = 601,
   mMESSAGE      = 701,
   mUSERNOUN     = 901,
};

//-------------------------------------------------------------//
//                      struct mMsg                            //
//-------------------------------------------------------------//

struct mMsg               // an interpreted event
{
   int      noun;         // message object
   int      verb;         // message action
   int      param[4];     // message parameters (type-dependent)

   mMsg( );
   mMsg( int nou, int vrb );
   mMsg( int nou, int vrb, int a );
   mMsg( int nou, int vrb, int a1, int a2 );
   mMsg( int nou, int vrb, void *p );
   mMsg( int nou, int vrb, mRect& r );
   mMsg( int nou, int vrb, mPoint& p );
   mMsg( int nou, int vrb, mPoint& p1, mPoint& p2 );
   mMsg( int nou, int vrb, void *p, mPoint& pt );
   virtual ~mMsg( ) { }
   void clear( void );

   //................ set methods
   void set( int n, int v )
   {
      noun = n;
      verb = v;
   }
   void set( int n, int v, int p0, int p1 )
   {
      noun = n;
      verb = v;
      param[0] = p0;
      param[1] = p1;
   }
   void set( int n, int v, int p )
   {
      noun = n;
      verb = v;
      param[0] = p;
   }
   void set( int n, int v, mPoint p )
   {
      noun = n;
      verb = v;
      param[0] = p.x;
      param[1] = p.y;
   }

   //................ get methods
   void * msgpointer( void )
   {
#ifdef _MSC_VER
      return (void *)
         ( (((unsigned long) param[0]) << 16) |
            ((unsigned) param[1]) );
#else
#ifdef __SC__
      return (void *)
         ( (((unsigned long) param[0]) << 16) |
            ((unsigned) param[1]) );
#else
#ifdef __WATCOMC__
      return (void *)((unsigned long)param[0]);
#else
#ifdef __HIGHC__
      return (void *)((unsigned long)param[0]);
#else
#if (sizeof(int)==2)
      return (void *)
         ( (((unsigned long) param[0]) << 16) |
            ((unsigned) param[1]) );
#else
      return (void *)((unsigned long)param[0]);
#endif
#endif
#endif
#endif
#endif
   }
   mPoint msgpoint( void )
   {
      return mPoint( param[0], param[1] );
   }
   mPoint msgpoint1( void )
   {
      return mPoint( param[0], param[1] );
   }
   mPoint msgpoint2( void )
   {
      return mPoint( param[2], param[3] );
   }
   mRect  msgrect( void )
   {
      return mRect( param[0], param[1], param[2], param[3] );
   }
};

#endif
