//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mLists.H                                            //
// Desc:   Lists, Stack, and Queue classes                     //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MLISTS_H_
#define _MLISTS_H_

//-------------------------------------------------------------//
//                      class mItem                            //
//-------------------------------------------------------------//

// The mItem class holds a data pointer and pointers to a
// previous and next mItem.  If size is greater than zero
// then data points to an allocated buffer.  If size is
// 0 then data is a copy of a pointer to something.

class mItem
{
   friend class mList;
   friend class mListIterator;
   friend class mListManager;

   protected:

      mItem *prev;
      mItem *next;
      void  *data;
      int    size;

   public:

      mItem( );
      mItem( void *item, int nbytes );
      virtual ~mItem( );
};


//-------------------------------------------------------------//
//                      class mList                            //
//-------------------------------------------------------------//

// A doubly-linked list class.  Used in the implementation of
// stacks and queues.  If datasize is zero, then only pointers
// to items are stored.  If datasize is greater than zero, then
// data pointers point to a private copy of that many bytes.
// Int return codes are FAILED on failure, OKAY on success.

class mList
{
   protected:

      int    datasize;      // 0 ==> pointers, !0 ==> alloc
      int    itemcount;     // current item count
      int    allocerror;    // if set, an allocation failed
      mItem *head;          // pointer to head
      mItem *tail;          // pointer to tail

   public:

      mList( );
      mList( int maxsize );
      virtual ~mList( );
      int    count( void ) { return itemcount; }
      void * gethead( void );
      int    addhead( void * an_item );
      int    delhead( void );
      void * gettail( void );
      int    addtail( void * an_item );
      int    deltail( void );
};


//-------------------------------------------------------------//
//                     class mListIterator                     //
//-------------------------------------------------------------//

// An iterator class for mList.  Implements a current item
// and methods for sequential access to the list.

class mListIterator : public mList
{
   protected:

      mItem *curr;   // pointer to current item

   public:

      mListIterator( );
      mListIterator( int maxsize );
      virtual ~mListIterator( );

      // overrides of mList member functions
      int    addhead( void * an_item );
      int    delhead( void );
      int    addtail( void * an_item );
      int    deltail( void );

      void * first( void );
      void * last( void );
      void * next( void );
      void * previous( void );
      void * current( void ) { return( curr ? curr->data : 0 ); }
      void * find( int which );
      void * locate( int (*locate_func)(void *data) );
};


//-------------------------------------------------------------//
//                      class mListManager                     //
//-------------------------------------------------------------//

// Adds editing and applicator capabilities to a list iterator.

class mListManager : public mListIterator
{
   public:

      mListManager( ) : mListIterator( ) { }
      mListManager( int maxsize ) : mListIterator( maxsize ) { }
      virtual ~mListManager( ) { }

      int insert( void * an_item );         // insert at curr
      int remove( void );                   // delete curr
      int apply( int (*listapp)(void *) );  // apply to curr
};


//-------------------------------------------------------------//
//                      class mStack                           //
//-------------------------------------------------------------//

// A lifo list -  add at head, delete at head.  The lastin and
// lastout members allow rereads.  See discussion of datasize
// member of class mList.

class mStack : private mList
{
   protected:

      void *lastin;
      void *lastout;
      int   maxitemcnt;
      int   status;

   public:

      mStack( );
      mStack( int maxcnt, int maxlen );
      virtual ~mStack( );

      int   push( void *item );
      void *pop( void );
      void *lastpush( void );
      void *lastpop( void );
      void  flush( void );
      int   count( void );
      int   error( void );
};


//-------------------------------------------------------------//
//                      class mQueue                           //
//-------------------------------------------------------------//

// A fifo list -  add at tail, delete at head.  The lastin and
// lastout members allow rereads.  See discussion of datasize
// member of class mList.

class mQueue : private mList
{
   protected:

      void *lastin;
      void *lastout;
      int   maxitemcnt;
      int   status;

   public:

      mQueue( );
      mQueue( int maxcnt, int maxlen );
      virtual ~mQueue( );

      int   enqueue( void *item );
      void *dequeue( void );
      void *lastenq( void );
      void *lastdeq( void );
      void  flush( void );
      int   count( void );
      int   error( void );
};

#endif
