//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mimath.h                                            //
// Desc:   Integer math package                                //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MIMATH_H_
#define _MIMATH_H_

// turn on MetaWare High C++ special naming convention
//#ifdef __HIGHC__
//#pragma Global_aliasing_convention( "_%r" );
//#endif

// Define special Watcom naming convention
#ifdef __WATCOMC__
#define _CDCL_ cdecl
#else
#define _CDCL_
#endif

//..........functions from IMATH.ASM

extern "C"
{
   int  _CDCL_ iscale( int i, int m, int d );
   int  _CDCL_ itrunc( int i, int m, int d );
   int  _CDCL_ isqrt( int i );
   long _CDCL_ lscale( long i, long m, long d );
   long _CDCL_ lsqrt( long n );
   long _CDCL_ distsq2( int x1, int x2, int y1, int y2 );
   long _CDCL_ distsq3( int x1, int x2, int y1, int y2, int z1, int z2 );
   long _CDCL_ dist2( int x1, int x2, int y1, int y2 );
   long _CDCL_ dist3( int x1, int x2, int y1, int y2, int z1, int z2 );
}

//..........functions from MIMATH.CPP

int isin( int x, int ang );
int icos( int x, int ang );
int ihyp( int a, int b );

long isin( long x, int ang );
long icos( long x, int ang );
long ihyp( long a, long b );

unsigned int mRandomNumber( int bounds );

// turn off MetaWare High C++ special naming convention
//#ifdef METAWARE
//#pragma Global_aliasing_cnvention();
//#endif

#endif
