//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mImage.H                                            //
// Desc:   Format-independent image structures                 //
// Date:   Nov, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MIMAGE_H_
#define _MIMAGE_H_

enum mImageTypes
{
   imNONE,
   imICON,
   imBMP,
   imGIF,
   imIMG,
   imMSP,
   imPCX,
   imTIF,
   imTGA,
   imWPG,
   imJPG,
   imXBM,
   imEPS,
   imPTNG,
   imRAS,
};

enum mImageErrors
{
   imOKAY,
   imNOTFOUND,
   imBADFORMAT,
   imBADPARAM,
   imIOERROR,
   imUNSUPPORTED,
   imNOMEMORY,
   imOUTOFSYNC,
   imOVERFLOW,
   imENDOFIMAGE,
   imENDOFFILE
};

struct mImage
{
   public:
      int             status;
      int             itype;
      mPalette       *ipal;
      mArray         *imap;

   protected:
      int            *cmap;
      unsigned char  *mapped_row;

   public:
      mImage( )
      {
         status     = imOKAY;
         itype      = imNONE;
         ipal       = 0;
         imap       = 0;
         cmap       = 0;
         mapped_row = 0;
      }

     ~mImage( )
      {
         if( ipal )
            delete ipal;
         if( imap )
            delete imap;
         if( cmap )
            delete cmap;
         if( mapped_row )
            delete mapped_row;
      }

      void map( mPalette *mpal );
      void mapimage( mPalette *mpal );
      void clean( void );

      unsigned char *get( int row, mPalette *mpal );
      unsigned char *get( int row );
};

void mDrawImage( mPoint& llxy, mImage *img );
void mDrawImage( mRect&  bnds, mImage *img );

void mDrawImageInR( mPoint& llxy, mImage *img, mRect& visR );
void mDrawImageInR( mRect&  bnds, mImage *img, mRect& visR );

void mDrawImageOutR( mPoint& llxy, mImage *img, mRect& obsR );
void mDrawImageOutR( mRect&  bnds, mImage *img, mRect& obsR );

#endif
